/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import napkin.DrawnShapeGenerator;
import napkin.NapkinUtil;
import napkin.RandomValue;

public class DrawnCubicLineGenerator
extends DrawnShapeGenerator {
    private final RandomValue leftX = new RandomValue(10.0, 4.0);
    private final RandomValue leftY = new RandomValue(-0.7, 1.5);
    private final RandomValue rightX = new RandomValue(20.0, 8.0);
    private final RandomValue rightY = new RandomValue(-1.3, 2.0);
    private static boolean DEBUG = false;
    public static final DrawnCubicLineGenerator INSTANCE = new DrawnCubicLineGenerator();

    public RandomValue getLeftX() {
        return this.leftX;
    }

    public RandomValue getLeftY() {
        return this.leftY;
    }

    public RandomValue getRightX() {
        return this.rightX;
    }

    public RandomValue getRightY() {
        return this.rightY;
    }

    public Shape generate(AffineTransform matrix) {
        double lx = NapkinUtil.leftRight(this.leftX.generate(), true);
        double ly = this.leftY.generate();
        double rx = NapkinUtil.leftRight(this.rightX.generate(), false);
        double ry = this.rightY.generate();
        double[] coords = new double[]{0.0, 0.0, lx, ly, rx, ry, 100.0, 0.0};
        if (matrix != null) {
            matrix.transform(coords, 0, coords, 0, 4);
        }
        CubicCurve2D.Double line = new CubicCurve2D.Double(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], coords[6], coords[7]);
        if (!DEBUG) {
            return line;
        }
        GeneralPath shape = new GeneralPath(new Rectangle2D.Double(coords[0] - 2.0, coords[1] - 2.0, 4.0, 4.0));
        shape.append(line, false);
        shape.append(new Line2D.Double(coords[6] - 2.0, coords[7] - 2.0, coords[6] + 2.0, coords[7] + 2.0), false);
        shape.append(new Line2D.Double(coords[6] + 2.0, coords[7] - 2.0, coords[6] - 2.0, coords[7] + 2.0), false);
        return shape;
    }
}

