/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import napkin.DrawnShapeGenerator;
import napkin.NapkinUtil;
import napkin.RandomValue;
import napkin.RandomValueSource;

public class DrawnTriangleGenerator
extends DrawnShapeGenerator {
    private final RandomValue midX;
    private final RandomValue midY;
    private final RandomValue v1X;
    private final RandomValue v1Y;
    private final RandomValue v2X;
    private final RandomValue v2Y;
    private final RandomValue startAdjust;
    private final double rotate;
    public static final DrawnTriangleGenerator INSTANCE = new DrawnTriangleGenerator();

    public DrawnTriangleGenerator() {
        this(0.0);
    }

    public DrawnTriangleGenerator(double rotate) {
        this.rotate = rotate;
        double shimmy = 0.05;
        this.midX = new RandomValue(0.5, shimmy);
        this.midY = new RandomValue(0.0, shimmy);
        this.v1X = new RandomValue(0.0, shimmy);
        this.v1Y = new RandomValue(1.0, shimmy);
        this.v2X = new RandomValue(1.0, shimmy);
        this.v2Y = new RandomValue(1.0, shimmy);
        this.startAdjust = new RandomValue(0.07);
    }

    public Shape generate(AffineTransform matrix) {
        int i;
        GeneralPath t = new GeneralPath();
        double xScale = matrix == null ? 1.0 : matrix.getScaleX();
        double yScale = matrix == null ? 1.0 : matrix.getScaleY();
        double xMid = this.midX.generate();
        double yMid = this.midY.generate();
        double xV1 = this.v1X.generate();
        double yV1 = this.v1Y.generate();
        double xV2 = this.v2X.generate();
        double yV2 = this.v2Y.generate();
        if (this.rotate != 0.0) {
            matrix = NapkinUtil.copy(matrix);
            matrix.rotate(this.rotate, 0.5, 0.5);
        }
        double[] points = new double[]{xMid, yMid, xV1, yV1, xV2, yV2};
        NapkinUtil.transform(matrix, points);
        double minDist = Double.MAX_VALUE;
        int minPoint = 0;
        for (int i2 = 0; i2 < points.length; i2 += 2) {
            double x = points[i2];
            double y = points[i2 + 1];
            double dist = Math.sqrt(x * x + y * y);
            if (!(dist < minDist)) continue;
            minDist = dist;
            minPoint = i2;
        }
        float[] drawPoints = new float[points.length + 2];
        for (i = 0; i < points.length; ++i) {
            drawPoints[i] = (float)points[(i + minPoint) % points.length];
        }
        drawPoints[6] = drawPoints[0];
        drawPoints[7] = drawPoints[1];
        drawPoints[0] = (float)((double)drawPoints[0] + this.adjustStartOffset(this.startAdjust, xScale));
        drawPoints[1] = (float)((double)drawPoints[1] + this.adjustStartOffset(this.startAdjust, yScale));
        drawPoints[6] = (float)((double)drawPoints[6] + this.adjustStartOffset(this.startAdjust, xScale));
        drawPoints[7] = (float)((double)drawPoints[7] + this.adjustStartOffset(this.startAdjust, yScale));
        t.moveTo(drawPoints[0], drawPoints[1]);
        for (i = 2; i < drawPoints.length; i += 2) {
            t.lineTo(drawPoints[i], drawPoints[i + 1]);
        }
        return t;
    }

    private double adjustStartOffset(RandomValueSource off, double scale) {
        if (scale >= 1.0) {
            return off.generate();
        }
        double delta = 1.0 - scale;
        double exp = this.startAdjust.generate();
        double adjusted = Math.pow(delta, exp);
        double startScale = 1.0 - adjusted;
        return off.generate() * startScale;
    }

    public RandomValue getMidX() {
        return this.midX;
    }

    public RandomValue getMidY() {
        return this.midY;
    }

    public RandomValue getStartAdjust() {
        return this.startAdjust;
    }
}

