/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import napkin.NapkinTheme;
import napkin.NapkinUtil;

public abstract class NapkinBorder
extends AbstractBorder {
    private final Border formalBorder;
    private boolean recentlyFormal;

    public NapkinBorder(Border formalBorder) {
        this.formalBorder = formalBorder;
    }

    public Insets getBorderInsets(Component c) {
        if (this.isFormal(c)) {
            return this.formalBorder.getBorderInsets(c);
        }
        return this.doGetBorderInsets(c);
    }

    public boolean isBorderOpaque() {
        if (this.recentlyFormal) {
            return this.formalBorder.isBorderOpaque();
        }
        return this.doIsBorderOpaque();
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.isFormal(c)) {
            this.formalBorder.paintBorder(c, g, x, y, width, height);
        } else {
            NapkinTheme theme = NapkinUtil.currentTheme(c);
            Color penColor = theme.getPenColor();
            if (NapkinUtil.replace(g.getColor(), penColor)) {
                g.setColor(penColor);
            }
            this.doPaintBorder(c, g, x, y, width, height);
        }
    }

    protected boolean isFormal(Component c) {
        this.recentlyFormal = NapkinUtil.isFormal(c);
        return this.recentlyFormal;
    }

    protected abstract Insets doGetBorderInsets(Component var1);

    protected boolean doIsBorderOpaque() {
        return false;
    }

    protected abstract void doPaintBorder(Component var1, Graphics var2, int var3, int var4, int var5, int var6);
}

