/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import napkin.DrawnBoxGenerator;
import napkin.DrawnBoxHolder;
import napkin.DrawnCheckGenerator;
import napkin.DrawnCircleGenerator;
import napkin.DrawnQuadLineGenerator;
import napkin.DrawnShapeGenerator;
import napkin.DrawnTriangleGenerator;
import napkin.NapkinConstants;
import napkin.NapkinIcon;
import napkin.NapkinUtil;
import napkin.RandomValue;

public class NapkinIconFactory
implements NapkinConstants {
    public static Icon createCheckBoxIcon() {
        return new CheckBoxIcon();
    }

    public static Icon createRadioButtonIcon() {
        return new RadioButtonIcon();
    }

    public static Icon createArrowIcon(int pointTowards) {
        return NapkinIconFactory.createArrowIcon(pointTowards, 10);
    }

    public static Icon createArrowIcon(int pointTowards, int size) {
        return new ArrowIcon(pointTowards, size);
    }

    public static Icon createUnderlineIcon(int size) {
        return new CheckBoxIcon(size);
    }

    public static Icon createXIcon(int size) {
        return new XIcon(size);
    }

    public static class XIcon
    implements Icon {
        private final int size;
        private final DrawnBoxHolder mark;
        protected static final int SIZE = 15;
        protected static final int MID_INSET = 3;

        public XIcon() {
            this(15);
        }

        public XIcon(int size) {
            DrawnBoxGenerator box = new DrawnBoxGenerator();
            box.setAsX(true);
            this.mark = new DrawnBoxHolder(box);
            this.size = size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public void paintIcon(Component c, Graphics g1, int x, int y) {
            Graphics2D g = NapkinUtil.lineGraphics(g1, 2.5f);
            this.mark.shapeUpToDate(new Rectangle(x, y, this.size, this.size));
            this.mark.draw(g);
        }
    }

    public static class ArrowIcon
    extends NapkinIcon {
        private final int genNum;
        private final int size;
        public static final int DEFAULT_SIZE = 10;
        private static final DrawnTriangleGenerator[] ARROW_GEN = new DrawnTriangleGenerator[]{new DrawnTriangleGenerator(0.0), new DrawnTriangleGenerator(1.5707963267948966), new DrawnTriangleGenerator(Math.PI), new DrawnTriangleGenerator(-1.5707963267948966)};

        public ArrowIcon(int pointTowards, int size) {
            super(1, NapkinUtil.scaleMat(size));
            this.genNum = pointTowards / 2;
            this.size = size;
            this.init();
        }

        protected DrawnShapeGenerator createPlaceGenerator() {
            return ARROW_GEN[this.genNum];
        }

        protected DrawnShapeGenerator createMarkGenerator() {
            return ARROW_GEN[this.genNum];
        }

        protected int calcHeight() {
            return this.size;
        }

        protected int calcWidth() {
            return this.size;
        }

        protected boolean shouldUseMark(Component c) {
            if (super.shouldUseMark(c)) {
                return true;
            }
            return c.isFocusOwner();
        }
    }

    public static class RadioButtonIcon
    extends NapkinIcon {
        private static final int SIZE = 13;
        private static final double SCALE = 0.13;
        private static final AffineTransform SCALE_MAT = NapkinUtil.scaleMat(0.13);
        private static DrawnCircleGenerator placeGen;

        public RadioButtonIcon() {
            super(2, SCALE_MAT);
            this.init();
        }

        protected DrawnShapeGenerator createPlaceGenerator() {
            placeGen = new DrawnCircleGenerator();
            return placeGen;
        }

        protected DrawnShapeGenerator createMarkGenerator() {
            DrawnCircleGenerator markGen = new DrawnCircleGenerator(true);
            double skew = 33.0;
            RandomValue tlX = markGen.getTlX();
            RandomValue blX = markGen.getBlX();
            RandomValue trX = markGen.getTrX();
            RandomValue brX = markGen.getBrX();
            tlX.setMid(tlX.getMid() + skew);
            trX.setMid(trX.getMid() + skew);
            blX.setMid(blX.getMid() - skew);
            brX.setMid(brX.getMid() - skew);
            return markGen;
        }

        public int calcHeight() {
            double max = placeGen.getBrX().max();
            double min = placeGen.getBlX().min();
            return (int)Math.ceil(0.13 * (max - min));
        }

        public int calcWidth() {
            double max = placeGen.getBrY().max();
            double min = placeGen.getTrY().min();
            return (int)Math.ceil(0.13 * (max - min));
        }
    }

    public static class CheckBoxIcon
    extends NapkinIcon {
        private final int size;
        private final int midInset;
        protected static final int SIZE = 13;
        protected static final int MID_INSET = 3;
        private static DrawnCheckGenerator checkGen;

        public CheckBoxIcon() {
            this(13);
        }

        public CheckBoxIcon(int size) {
            super(1, null);
            this.size = size;
            this.midInset = size * Math.round(0.23076923f);
            this.init();
        }

        protected DrawnShapeGenerator createPlaceGenerator() {
            DrawnQuadLineGenerator placeGen = new DrawnQuadLineGenerator();
            placeGen.getCtlY().setMid(1.0);
            return placeGen;
        }

        protected DrawnShapeGenerator createMarkGenerator() {
            checkGen = new DrawnCheckGenerator(this.size - this.midInset);
            return checkGen;
        }

        protected int calcWidth() {
            RandomValue lx = checkGen.getLeftXScale();
            RandomValue mx = checkGen.getMidXScale();
            RandomValue rx = checkGen.getRightXScale();
            double l = mx.min() - lx.min();
            double r = mx.max() + rx.max();
            return (int)Math.round((double)this.size * (r - l));
        }

        protected int calcHeight() {
            RandomValue my = checkGen.getMidYScale();
            RandomValue ry = checkGen.getRightYScale();
            return (int)Math.round((double)this.size * (my.max() + ry.max()) + 2.0);
        }

        protected void doPaint(Graphics2D placeG, Graphics2D markG, int x, int y) {
            FontMetrics fm = placeG.getFontMetrics();
            int ypos = y + fm.getAscent();
            placeG.translate(x, ypos);
            placeG.scale((double)this.size / 100.0, 1.0);
            placeG.draw(this.place);
            if (markG != null) {
                markG.translate(x, ypos - this.size);
                markG.draw(this.mark);
            }
        }
    }
}

