/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.Border;
import napkin.DrawnCubicLineGenerator;
import napkin.DrawnLineHolder;
import napkin.DrawnShapeGenerator;
import napkin.NapkinBorder;
import napkin.NapkinBoxBorder;

public class NapkinLineBorder
extends NapkinBorder {
    private final boolean vertical;
    private DrawnLineHolder line;
    private static final Insets DEFAULT_VERT_INSETS = new Insets(0, 0, 0, NapkinBoxBorder.DEFAULT_INSETS.right);
    private static final Insets DEFAULT_HORIZ_INSETS = new Insets(0, 0, NapkinBoxBorder.DEFAULT_INSETS.bottom, 0);

    public NapkinLineBorder(Border formalBorder, boolean vertical) {
        super(formalBorder);
        this.vertical = vertical;
    }

    protected Insets doGetBorderInsets(Component c) {
        return this.vertical ? DEFAULT_VERT_INSETS : DEFAULT_HORIZ_INSETS;
    }

    public void doPaintBorder(Component c, Graphics g1, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)g1;
        Rectangle passed = new Rectangle(x, y, width, height);
        if (this.line == null) {
            this.line = new DrawnLineHolder((DrawnShapeGenerator)DrawnCubicLineGenerator.INSTANCE, this.vertical);
        }
        this.line.shapeUpToDate(passed, null);
        Insets insets = this.doGetBorderInsets(c);
        if (insets.bottom != 0) {
            y += c.getHeight() - insets.bottom;
        } else {
            x += c.getWidth() - insets.right;
        }
        g.translate(x, y);
        this.line.draw(g);
        g.translate(-x, -y);
    }
}

