/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public final class TrendyUtils {
    static void drawComboBoxSmallSkin(Graphics g, JComponent c, boolean down) {
        int w = c.getWidth();
        int h = c.getHeight() - 1;
        ComboBoxModel buttonModel = ((JComboBox)c).getModel();
        JComboBox combobox = (JComboBox)c;
        if (combobox.isEnabled()) {
            if (down) {
                g.setColor(new ColorUIResource(254, 254, 254));
                g.drawLine(2, 1, w - 3, 1);
                g.setColor(new ColorUIResource(246, 246, 246));
                g.drawLine(1, 2, w - 2, 2);
                g.setColor(new ColorUIResource(242, 242, 242));
                g.drawLine(1, 3, w - 2, 3);
                g.drawLine(1, 4, w - 2, 4);
                g.drawLine(1, 5, w - 2, 5);
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(new GradientPaint(0.0f, 0.0f, new ColorUIResource(240, 240, 240), 0.0f, h, new ColorUIResource(248, 248, 248)));
                g.fillRect(1, 6, w - 2, h - 11);
                g.setColor(new ColorUIResource(247, 247, 247));
                g.drawLine(1, h - 5, w - 2, h - 5);
                g.drawLine(1, h - 4, w - 2, h - 4);
                g.setColor(new ColorUIResource(243, 243, 243));
                g.drawLine(1, h - 3, w - 2, h - 3);
                g.setColor(new ColorUIResource(237, 237, 237));
                g.drawLine(1, h - 2, w - 2, h - 2);
                g.setColor(new ColorUIResource(221, 221, 221));
                g.drawLine(2, h - 1, w - 3, h - 1);
            } else {
                g.setColor(Color.white);
                g.drawLine(2, 1, w - 3, 1);
                g.drawLine(1, 2, w - 2, 2);
                g.setColor(new ColorUIResource(251, 251, 251));
                g.drawLine(1, 3, w - 2, 3);
                g.setColor(new ColorUIResource(248, 248, 248));
                g.drawLine(1, 4, w - 2, 4);
                g.setColor(new ColorUIResource(246, 246, 246));
                g.drawLine(1, 5, w - 2, 5);
                g.setColor(new ColorUIResource(244, 244, 244));
                g.drawLine(1, 6, w - 2, 6);
                g.setColor(new ColorUIResource(242, 242, 242));
                g.drawLine(1, 7, w - 2, 7);
                g.setColor(new ColorUIResource(240, 240, 240));
                g.fillRect(1, 8, w - 2, h - 14);
                g.setColor(new ColorUIResource(238, 238, 238));
                g.drawLine(1, h - 6, w - 2, h - 6);
                g.setColor(new ColorUIResource(235, 235, 235));
                g.drawLine(1, h - 5, w - 2, h - 5);
                g.setColor(new ColorUIResource(231, 231, 231));
                g.drawLine(1, h - 4, w - 2, h - 4);
                g.setColor(new ColorUIResource(224, 224, 224));
                g.drawLine(1, h - 3, w - 2, h - 3);
                g.setColor(new ColorUIResource(216, 216, 216));
                g.drawLine(1, h - 2, w - 2, h - 2);
                g.setColor(new ColorUIResource(206, 206, 206));
                g.drawLine(2, h - 1, w - 3, h - 1);
            }
        } else {
            g.setColor(new ColorUIResource(240, 240, 240));
            g.drawLine(2, 1, w - 3, 1);
            g.drawLine(1, 2, w - 2, 2);
            g.drawLine(1, 3, w - 2, 3);
            g.drawLine(1, 4, w - 2, 4);
            g.drawLine(1, 5, w - 2, 5);
            g.drawLine(1, 6, w - 2, 6);
            g.drawLine(1, 7, w - 2, 7);
            g.fillRect(1, 8, w - 2, h - 14);
            g.drawLine(1, h - 6, w - 2, h - 6);
            g.drawLine(1, h - 5, w - 2, h - 5);
            g.drawLine(1, h - 4, w - 2, h - 4);
            g.drawLine(1, h - 3, w - 2, h - 3);
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.drawLine(2, h - 1, w - 3, h - 1);
        }
        TrendyUtils.drawRoundRectBorderSmall(g, w, h, "NORMAL");
        int ny = c.getSize().height / 2 - 3;
        int nx = c.getWidth() - 15;
        if (down && combobox.isEnabled()) {
            ++nx;
            ++ny;
        }
        g.translate(nx, ny);
        if (combobox.isEnabled()) {
            g.setColor(new ColorUIResource(195, 195, 195));
            g.drawLine(0, 0, 8, 0);
            g.drawLine(1, 2, 4, 5);
            g.drawLine(7, 2, 4, 5);
            g.setColor(new ColorUIResource(100, 100, 100));
            g.drawLine(1, 1, 7, 1);
            g.drawLine(2, 2, 6, 2);
            g.drawLine(3, 3, 5, 3);
            g.drawLine(4, 4, 4, 4);
        } else {
            g.setColor(new ColorUIResource(220, 220, 220));
            g.drawLine(0, 0, 8, 0);
            g.drawLine(1, 2, 4, 5);
            g.drawLine(7, 2, 4, 5);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(1, 1, 7, 1);
            g.drawLine(2, 2, 6, 2);
            g.drawLine(3, 3, 5, 3);
            g.drawLine(4, 4, 4, 4);
        }
        g.translate(-nx, -ny);
    }

    static void drawComboBoxSkin(Graphics g, JComponent c, boolean down) {
        int w = c.getWidth();
        int h = c.getHeight() - 1;
        ComboBoxModel buttonModel = ((JComboBox)c).getModel();
        JComboBox combobox = (JComboBox)c;
        if (combobox.isEnabled()) {
            if (down) {
                g.setColor(new ColorUIResource(254, 254, 254));
                g.drawLine(5, 1, w - 6, 1);
                g.setColor(new ColorUIResource(246, 246, 246));
                g.drawLine(4, 2, w - 5, 2);
                g.setColor(new ColorUIResource(242, 242, 242));
                g.drawLine(3, 3, w - 4, 3);
                g.drawLine(2, 4, w - 3, 4);
                g.drawLine(2, 5, w - 3, 5);
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(new GradientPaint(0.0f, 0.0f, new ColorUIResource(240, 240, 240), 0.0f, h, new ColorUIResource(248, 248, 248)));
                g.fillRect(1, 6, w - 2, h - 12);
                g.setColor(new ColorUIResource(247, 247, 247));
                g.drawLine(2, h - 6, w - 3, h - 6);
                g.drawLine(2, h - 5, w - 3, h - 5);
                g.setColor(new ColorUIResource(243, 243, 243));
                g.drawLine(3, h - 4, w - 4, h - 4);
                g.setColor(new ColorUIResource(237, 237, 237));
                g.drawLine(4, h - 3, w - 5, h - 3);
                g.setColor(new ColorUIResource(221, 221, 221));
                g.drawLine(5, h - 2, w - 6, h - 2);
            } else {
                g.setColor(Color.white);
                g.drawLine(5, 1, w - 6, 1);
                g.drawLine(4, 2, w - 5, 2);
                g.setColor(new ColorUIResource(251, 251, 251));
                g.drawLine(3, 3, w - 4, 3);
                g.setColor(new ColorUIResource(248, 248, 248));
                g.drawLine(2, 4, w - 3, 4);
                g.setColor(new ColorUIResource(246, 246, 246));
                g.drawLine(2, 5, w - 3, 5);
                g.setColor(new ColorUIResource(244, 244, 244));
                g.drawLine(1, 6, w - 2, 6);
                g.setColor(new ColorUIResource(242, 242, 242));
                g.drawLine(1, 7, w - 2, 7);
                g.setColor(new ColorUIResource(240, 240, 240));
                g.fillRect(1, 8, w - 2, h - 15);
                g.setColor(new ColorUIResource(238, 238, 238));
                g.drawLine(1, h - 7, w - 2, h - 7);
                g.setColor(new ColorUIResource(235, 235, 235));
                g.drawLine(2, h - 6, w - 3, h - 6);
                g.setColor(new ColorUIResource(231, 231, 231));
                g.drawLine(2, h - 5, w - 3, h - 5);
                g.setColor(new ColorUIResource(224, 224, 224));
                g.drawLine(3, h - 4, w - 4, h - 4);
                g.setColor(new ColorUIResource(216, 216, 216));
                g.drawLine(4, h - 3, w - 5, h - 3);
                g.setColor(new ColorUIResource(206, 206, 206));
                g.drawLine(5, h - 2, w - 6, h - 2);
            }
        } else {
            g.setColor(new ColorUIResource(240, 240, 240));
            g.drawLine(5, 1, w - 6, 1);
            g.drawLine(4, 2, w - 5, 2);
            g.drawLine(3, 3, w - 4, 3);
            g.drawLine(2, 4, w - 3, 4);
            g.drawLine(2, 5, w - 3, 5);
            g.drawLine(1, 6, w - 2, 6);
            g.drawLine(1, 7, w - 2, 7);
            g.fillRect(1, 8, w - 2, h - 15);
            g.drawLine(2, h - 7, w - 3, h - 7);
            g.drawLine(2, h - 6, w - 3, h - 6);
            g.drawLine(2, h - 5, w - 3, h - 5);
            g.drawLine(3, h - 4, w - 4, h - 4);
            g.drawLine(4, h - 3, w - 5, h - 3);
            g.drawLine(5, h - 2, w - 6, h - 2);
        }
        TrendyUtils.drawRoundRectBorder(g, w, h, "NORMAL", down);
        if (!c.isEnabled()) {
            g.setColor(new ColorUIResource(240, 240, 240));
            g.drawLine(8, h, w - 9, h);
        }
        int ny = c.getSize().height / 2 - 2;
        int nx = c.getWidth() - 15;
        if (down && combobox.isEnabled()) {
            ++nx;
            ++ny;
        }
        g.translate(nx, ny);
        if (combobox.isEnabled()) {
            g.setColor(new ColorUIResource(195, 195, 195));
            g.drawLine(0, 0, 8, 0);
            g.drawLine(1, 2, 4, 5);
            g.drawLine(7, 2, 4, 5);
            g.setColor(new ColorUIResource(100, 100, 100));
            g.drawLine(1, 1, 7, 1);
            g.drawLine(2, 2, 6, 2);
            g.drawLine(3, 3, 5, 3);
            g.drawLine(4, 4, 4, 4);
        } else {
            g.setColor(new ColorUIResource(220, 220, 220));
            g.drawLine(0, 0, 8, 0);
            g.drawLine(1, 2, 4, 5);
            g.drawLine(7, 2, 4, 5);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(1, 1, 7, 1);
            g.drawLine(2, 2, 6, 2);
            g.drawLine(3, 3, 5, 3);
            g.drawLine(4, 4, 4, 4);
        }
        g.translate(-nx, -ny);
    }

    static void drawButtonSkinSmall(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        ButtonModel buttonModel = ((AbstractButton)c).getModel();
        if (buttonModel.isEnabled()) {
            if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                g.setColor(new ColorUIResource(254, 254, 254));
                g.drawLine(2, 1, w - 3, 1);
                g.setColor(new ColorUIResource(246, 246, 246));
                g.drawLine(1, 2, w - 2, 2);
                g.setColor(new ColorUIResource(242, 242, 242));
                g.drawLine(1, 3, w - 2, 3);
                g.drawLine(1, 4, w - 2, 4);
                g.drawLine(1, 5, w - 2, 5);
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(new GradientPaint(0.0f, 0.0f, new ColorUIResource(240, 240, 240), 0.0f, h, new ColorUIResource(248, 248, 248)));
                g.fillRect(1, 6, w - 2, h - 11);
                g.setColor(new ColorUIResource(247, 247, 247));
                g.drawLine(1, h - 5, w - 2, h - 5);
                g.drawLine(1, h - 4, w - 2, h - 4);
                g.setColor(new ColorUIResource(243, 243, 243));
                g.drawLine(1, h - 3, w - 2, h - 3);
                g.setColor(new ColorUIResource(237, 237, 237));
                g.drawLine(1, h - 2, w - 2, h - 2);
                g.setColor(new ColorUIResource(221, 221, 221));
                g.drawLine(2, h - 1, w - 3, h - 1);
            } else {
                g.setColor(Color.white);
                g.drawLine(2, 1, w - 3, 1);
                g.drawLine(1, 2, w - 2, 2);
                g.setColor(new ColorUIResource(251, 251, 251));
                g.drawLine(1, 3, w - 2, 3);
                g.setColor(new ColorUIResource(248, 248, 248));
                g.drawLine(1, 4, w - 2, 4);
                g.setColor(new ColorUIResource(246, 246, 246));
                g.drawLine(1, 5, w - 2, 5);
                g.setColor(new ColorUIResource(244, 244, 244));
                g.drawLine(1, 6, w - 2, 6);
                g.setColor(new ColorUIResource(242, 242, 242));
                g.drawLine(1, 7, w - 2, 7);
                g.setColor(new ColorUIResource(240, 240, 240));
                g.fillRect(1, 8, w - 2, h - 14);
                g.setColor(new ColorUIResource(238, 238, 238));
                g.drawLine(1, h - 6, w - 2, h - 6);
                g.setColor(new ColorUIResource(235, 235, 235));
                g.drawLine(1, h - 5, w - 2, h - 5);
                g.setColor(new ColorUIResource(231, 231, 231));
                g.drawLine(1, h - 4, w - 2, h - 4);
                g.setColor(new ColorUIResource(224, 224, 224));
                g.drawLine(1, h - 3, w - 2, h - 3);
                g.setColor(new ColorUIResource(216, 216, 216));
                g.drawLine(1, h - 2, w - 2, h - 2);
                g.setColor(new ColorUIResource(206, 206, 206));
                g.drawLine(2, h - 1, w - 3, h - 1);
            }
        } else {
            if (buttonModel.isSelected()) {
                g.setColor(new ColorUIResource(238, 238, 238));
            } else {
                g.setColor(new ColorUIResource(245, 245, 245));
            }
            g.drawLine(2, 1, w - 3, 1);
            g.drawLine(1, 2, w - 2, 2);
            g.drawLine(1, 3, w - 2, 3);
            g.drawLine(1, 4, w - 2, 4);
            g.drawLine(1, 5, w - 2, 5);
            g.drawLine(1, 6, w - 2, 6);
            g.drawLine(1, 7, w - 2, 7);
            g.fillRect(1, 8, w - 2, h - 14);
            g.drawLine(1, h - 6, w - 2, h - 6);
            g.drawLine(1, h - 5, w - 2, h - 5);
            g.drawLine(1, h - 4, w - 2, h - 4);
            g.drawLine(1, h - 3, w - 2, h - 3);
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.drawLine(2, h - 1, w - 3, h - 1);
        }
    }

    static void drawRoundRectBorderSmall(Graphics g, int w, int h, String action) {
        ColorUIResource c1 = new ColorUIResource(0);
        ColorUIResource c2 = new ColorUIResource(0);
        if (action.equals("NORMAL")) {
            c1 = new ColorUIResource(100, 100, 100);
            c2 = new ColorUIResource(190, 190, 190);
        } else if (action.equals("ROLLOVER")) {
            c1 = new ColorUIResource(60, 100, 180);
            c2 = new ColorUIResource(90, 135, 215);
        } else if (action.equals("FOCUS")) {
            c1 = new ColorUIResource(105, 150, 225);
            c2 = new ColorUIResource(177, 200, 235);
        }
        g.setColor(c1);
        g.drawLine(2, 0, w - 3, 0);
        g.drawLine(0, 2, 0, h - 3);
        g.drawLine(w - 1, 2, w - 1, h - 3);
        g.drawLine(2, h - 1, w - 3, h - 1);
        g.drawLine(1, 1, 1, 1);
        g.drawLine(w - 2, 1, w - 2, 1);
        g.drawLine(1, h - 2, 1, h - 2);
        g.drawLine(w - 2, h - 2, w - 2, h - 2);
        g.setColor(c2);
        g.drawLine(1, 0, 0, 1);
        g.drawLine(w - 2, 0, w - 1, 1);
        g.drawLine(w - 2, h - 1, w - 1, h - 2);
        g.drawLine(1, h - 1, 0, h - 2);
    }

    public static boolean isTooSmall(JComponent c) {
        int diff = 0;
        if (c instanceof JComboBox) {
            diff = 2;
        }
        if (c.getHeight() <= 20 && c.getWidth() <= 20) {
            return true;
        }
        return c.getHeight() <= 15 + diff && c.getWidth() >= 20 || c.getHeight() >= 20 && c.getWidth() <= 15 + diff;
    }

    static void drawButtonSkin(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight() - 1;
        ButtonModel buttonModel = ((AbstractButton)c).getModel();
        if (buttonModel.isEnabled()) {
            if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                g.setColor(new ColorUIResource(254, 254, 254));
                g.drawLine(5, 1, w - 6, 1);
                g.setColor(new ColorUIResource(246, 246, 246));
                g.drawLine(4, 2, w - 5, 2);
                g.setColor(new ColorUIResource(242, 242, 242));
                g.drawLine(3, 3, w - 4, 3);
                g.drawLine(2, 4, w - 3, 4);
                g.drawLine(2, 5, w - 3, 5);
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(new GradientPaint(0.0f, 0.0f, new ColorUIResource(240, 240, 240), 0.0f, h, new ColorUIResource(248, 248, 248)));
                g.fillRect(1, 6, w - 2, h - 12);
                g.setColor(new ColorUIResource(247, 247, 247));
                g.drawLine(2, h - 6, w - 3, h - 6);
                g.drawLine(2, h - 5, w - 3, h - 5);
                g.setColor(new ColorUIResource(243, 243, 243));
                g.drawLine(3, h - 4, w - 4, h - 4);
                g.setColor(new ColorUIResource(237, 237, 237));
                g.drawLine(4, h - 3, w - 5, h - 3);
                g.setColor(new ColorUIResource(221, 221, 221));
                g.drawLine(5, h - 2, w - 6, h - 2);
            } else {
                g.setColor(Color.white);
                g.drawLine(5, 1, w - 6, 1);
                g.drawLine(4, 2, w - 5, 2);
                g.setColor(new ColorUIResource(251, 251, 251));
                g.drawLine(3, 3, w - 4, 3);
                g.setColor(new ColorUIResource(248, 248, 248));
                g.drawLine(2, 4, w - 3, 4);
                g.setColor(new ColorUIResource(246, 246, 246));
                g.drawLine(2, 5, w - 3, 5);
                g.setColor(new ColorUIResource(244, 244, 244));
                g.drawLine(1, 6, w - 2, 6);
                g.setColor(new ColorUIResource(242, 242, 242));
                g.drawLine(1, 7, w - 2, 7);
                g.setColor(new ColorUIResource(240, 240, 240));
                g.fillRect(1, 8, w - 2, h - 15);
                g.setColor(new ColorUIResource(238, 238, 238));
                g.drawLine(1, h - 7, w - 2, h - 7);
                g.setColor(new ColorUIResource(235, 235, 235));
                g.drawLine(2, h - 6, w - 3, h - 6);
                g.setColor(new ColorUIResource(231, 231, 231));
                g.drawLine(2, h - 5, w - 3, h - 5);
                g.setColor(new ColorUIResource(224, 224, 224));
                g.drawLine(3, h - 4, w - 4, h - 4);
                g.setColor(new ColorUIResource(216, 216, 216));
                g.drawLine(4, h - 3, w - 5, h - 3);
                g.setColor(new ColorUIResource(206, 206, 206));
                g.drawLine(5, h - 2, w - 6, h - 2);
            }
        } else {
            if (buttonModel.isSelected()) {
                g.setColor(new ColorUIResource(238, 238, 238));
            } else {
                g.setColor(new ColorUIResource(245, 245, 245));
            }
            g.drawLine(5, 1, w - 6, 1);
            g.drawLine(4, 2, w - 5, 2);
            g.drawLine(3, 3, w - 4, 3);
            g.drawLine(2, 4, w - 3, 4);
            g.drawLine(2, 5, w - 3, 5);
            g.drawLine(1, 6, w - 2, 6);
            g.drawLine(1, 7, w - 2, 7);
            g.fillRect(1, 8, w - 2, h - 14);
            g.drawLine(2, h - 6, w - 3, h - 6);
            g.drawLine(2, h - 5, w - 3, h - 5);
            g.drawLine(3, h - 4, w - 4, h - 4);
            g.drawLine(4, h - 3, w - 5, h - 3);
            g.drawLine(5, h - 2, w - 6, h - 2);
        }
    }

    static void drawSpinnerRoundRectBorder(Graphics g, int w, int h, String action) {
        ColorUIResource c1 = new ColorUIResource(0);
        ColorUIResource c2 = new ColorUIResource(0);
        ColorUIResource c3 = new ColorUIResource(0);
        ColorUIResource c4 = new ColorUIResource(0);
        ColorUIResource c5 = new ColorUIResource(0);
        ColorUIResource c6 = new ColorUIResource(0);
        if (action.equals("NORMAL")) {
            c1 = new ColorUIResource(140, 140, 140);
            c2 = new ColorUIResource(130, 130, 130);
            c3 = new ColorUIResource(170, 170, 170);
            c4 = new ColorUIResource(210, 210, 210);
            c5 = new ColorUIResource(165, 165, 165);
            c6 = new ColorUIResource(155, 155, 155);
        } else if (action.equals("ROLLOVER")) {
            c1 = new ColorUIResource(105, 190, 105);
            c2 = new ColorUIResource(85, 140, 85);
            c3 = new ColorUIResource(105, 165, 105);
            c4 = new ColorUIResource(160, 210, 160);
            c5 = new ColorUIResource(145, 200, 145);
            c6 = new ColorUIResource(140, 190, 140);
        } else if (action.equals("FOCUS")) {
            c1 = new ColorUIResource(105, 150, 225);
            c2 = new ColorUIResource(92, 120, 166);
            c3 = new ColorUIResource(130, 165, 220);
            c4 = new ColorUIResource(210, 220, 240);
            c5 = new ColorUIResource(163, 190, 230);
            c6 = new ColorUIResource(120, 150, 205);
        }
        g.setColor(c1);
        g.drawLine(5, 0, w - 7, 0);
        g.drawLine(0, 6, 0, h - 7);
        g.drawLine(w - 1, 6, w - 1, h - 7);
        g.setColor(c2);
        g.drawLine(6, h - 1, w - 7, h - 1);
        g.setColor(c5);
        g.drawLine(0, 5, 1, 5);
        g.drawLine(5, 1, 5, 0);
        g.setColor(c1);
        g.drawLine(1, 4, 1, 3);
        g.drawLine(4, 1, 3, 1);
        g.drawLine(3, 1, 1, 3);
        g.setColor(c4);
        g.drawLine(4, 0, 5, 1);
        g.drawLine(0, 4, 1, 5);
        g.drawLine(2, 3, 3, 2);
        g.setColor(c5);
        g.drawLine(w - 1, 5, w - 2, 5);
        g.drawLine(w - 6, 0, w - 6, 1);
        g.setColor(c1);
        g.drawLine(w - 2, 4, w - 2, 3);
        g.drawLine(w - 5, 1, w - 4, 1);
        g.drawLine(w - 4, 1, w - 2, 3);
        g.setColor(c4);
        g.drawLine(w - 5, 0, w - 6, 1);
        g.drawLine(w - 1, 4, w - 2, 5);
        g.drawLine(w - 4, 2, w - 3, 3);
        g.setColor(c3);
        g.drawLine(2, h - 4, 3, h - 3);
        g.drawLine(5, h - 2, 5, h - 1);
        g.setColor(c5);
        g.drawLine(0, h - 6, 1, h - 6);
        g.setColor(c6);
        g.drawLine(1, h - 5, 1, h - 4);
        g.drawLine(4, h - 2, 3, h - 2);
        g.drawLine(3, h - 2, 1, h - 4);
        g.setColor(c3);
        g.drawLine(w - 3, h - 4, w - 4, h - 3);
        g.drawLine(w - 6, h - 2, w - 6, h - 1);
        g.setColor(c5);
        g.drawLine(w - 1, h - 6, w - 2, h - 6);
        g.setColor(c6);
        g.drawLine(w - 2, h - 5, w - 2, h - 4);
        g.drawLine(w - 5, h - 2, w - 4, h - 2);
        g.drawLine(w - 4, h - 2, w - 2, h - 4);
    }

    static void drawButtonBorder(Graphics g, AbstractButton b) {
        boolean down;
        boolean bl = down = b.getModel().isArmed() && b.getModel().isPressed() || b.getModel().isSelected();
        if (b.isContentAreaFilled() && !(b.getParent() instanceof JToolBar)) {
            if (b.getModel().isRollover() && b.isRolloverEnabled()) {
                if (TrendyUtils.isTooSmall(b)) {
                    TrendyUtils.drawRoundRectBorderSmall(g, b.getWidth(), b.getHeight(), "ROLLOVER");
                } else {
                    TrendyUtils.drawRoundRectBorder(g, b.getWidth(), b.getHeight() - 1, "ROLLOVER", down);
                }
            } else if (b.hasFocus() && b.isFocusPainted()) {
                if (TrendyUtils.isTooSmall(b)) {
                    TrendyUtils.drawRoundRectBorderSmall(g, b.getWidth(), b.getHeight(), "FOCUS");
                } else {
                    TrendyUtils.drawRoundRectBorder(g, b.getWidth(), b.getHeight() - 1, "FOCUS", down);
                }
            } else if (TrendyUtils.isTooSmall(b)) {
                TrendyUtils.drawRoundRectBorderSmall(g, b.getWidth(), b.getHeight(), "NORMAL");
            } else {
                TrendyUtils.drawRoundRectBorder(g, b.getWidth(), b.getHeight() - 1, "NORMAL", down);
            }
        }
    }

    static void drawRoundRectBorder(Graphics g, int w, int h, String action, boolean down) {
        ColorUIResource c1 = new ColorUIResource(0);
        ColorUIResource c2 = new ColorUIResource(0);
        ColorUIResource c3 = new ColorUIResource(0);
        ColorUIResource c4 = new ColorUIResource(0);
        ColorUIResource c5 = new ColorUIResource(0);
        ColorUIResource c6 = new ColorUIResource(0);
        ColorUIResource c7 = new ColorUIResource(0);
        if (action.equals("NORMAL")) {
            c1 = new ColorUIResource(100, 100, 100);
            c2 = new ColorUIResource(80, 80, 80);
            c3 = new ColorUIResource(150, 150, 150);
            c4 = new ColorUIResource(200, 200, 200);
            c5 = new ColorUIResource(150, 150, 150);
            c6 = new ColorUIResource(115, 115, 115);
            c7 = new ColorUIResource(125, 125, 125);
        } else if (action.equals("ROLLOVER")) {
            c1 = new ColorUIResource(30, 160, 30);
            c2 = new ColorUIResource(55, 120, 55);
            c3 = new ColorUIResource(80, 160, 80);
            c4 = new ColorUIResource(140, 222, 140);
            c5 = new ColorUIResource(100, 170, 100);
            c6 = new ColorUIResource(60, 150, 60);
            c7 = new ColorUIResource(100, 170, 100);
        } else if (action.equals("FOCUS")) {
            c1 = new ColorUIResource(60, 100, 180);
            c2 = new ColorUIResource(45, 80, 135);
            c3 = new ColorUIResource(110, 150, 215);
            c4 = new ColorUIResource(170, 200, 255);
            c5 = new ColorUIResource(125, 165, 225);
            c6 = new ColorUIResource(85, 125, 205);
            c7 = new ColorUIResource(90, 135, 215);
        }
        g.setColor(c1);
        g.drawLine(5, 0, w - 7, 0);
        g.drawLine(0, 6, 0, h - 7);
        g.drawLine(w - 1, 6, w - 1, h - 7);
        g.setColor(c2);
        g.drawLine(6, h - 1, w - 7, h - 1);
        g.setColor(c5);
        g.drawLine(0, 5, 1, 5);
        g.drawLine(5, 1, 5, 0);
        g.setColor(c7);
        g.drawLine(1, 4, 1, 3);
        g.drawLine(4, 1, 3, 1);
        g.drawLine(3, 1, 1, 3);
        g.setColor(c4);
        g.drawLine(4, 0, 5, 1);
        g.drawLine(0, 4, 1, 5);
        g.drawLine(2, 3, 3, 2);
        g.setColor(c5);
        g.drawLine(w - 1, 5, w - 2, 5);
        g.drawLine(w - 6, 0, w - 6, 1);
        g.setColor(c7);
        g.drawLine(w - 2, 4, w - 2, 3);
        g.drawLine(w - 5, 1, w - 4, 1);
        g.drawLine(w - 4, 1, w - 2, 3);
        g.setColor(c4);
        g.drawLine(w - 5, 0, w - 6, 1);
        g.drawLine(w - 1, 4, w - 2, 5);
        g.drawLine(w - 4, 2, w - 3, 3);
        g.setColor(c3);
        g.drawLine(2, h - 4, 3, h - 3);
        g.drawLine(5, h - 2, 5, h - 1);
        g.setColor(c5);
        g.drawLine(0, h - 6, 1, h - 6);
        g.setColor(c6);
        g.drawLine(1, h - 5, 1, h - 4);
        g.drawLine(4, h - 2, 3, h - 2);
        g.drawLine(3, h - 2, 1, h - 4);
        g.setColor(c3);
        g.drawLine(w - 3, h - 4, w - 4, h - 3);
        g.drawLine(w - 6, h - 2, w - 6, h - 1);
        g.setColor(c5);
        g.drawLine(w - 1, h - 6, w - 2, h - 6);
        g.setColor(c6);
        g.drawLine(w - 2, h - 5, w - 2, h - 4);
        g.drawLine(w - 5, h - 2, w - 4, h - 2);
        g.drawLine(w - 4, h - 2, w - 2, h - 4);
        if (down) {
            g.setColor(new ColorUIResource(240, 240, 240));
        } else {
            g.setColor(new ColorUIResource(210, 210, 210));
        }
        g.drawLine(8, h, w - 9, h);
    }

    static void drawMenuItemBackground(Graphics g, JMenuItem menuItem) {
        Color oldColor = g.getColor();
        ButtonModel model = menuItem.getModel();
        int w = menuItem.getWidth();
        int h = menuItem.getHeight();
        if (!menuItem.isEnabled()) {
            g.setColor(new ColorUIResource(245, 245, 245));
            g.fillRect(0, 0, w, h);
            g.setColor(new ColorUIResource(250, 250, 250));
            g.fillRect(1, 1, w - 2, h - 2);
        } else if (model.isArmed() || model.isSelected() && menuItem instanceof JMenu) {
            g.setColor((Color)UIManager.get("Menu.selectionBackground"));
            g.fillRect(0, 0, w, h);
        } else if (!(menuItem instanceof JMenu) || !((JMenu)menuItem).isTopLevelMenu()) {
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
        }
        g.setColor(oldColor);
    }

    static void drawMenuBackground(Graphics g, JMenu menu) {
        int w = menu.getWidth();
        int h = menu.getHeight();
        if (menu.isSelected()) {
            g.setColor(new ColorUIResource(200, 200, 200));
            g.drawLine(0, 1, w - 1, 1);
            g.drawLine(0, 1, 0, h);
            g.drawLine(w - 1, 1, w - 1, h);
            g.setColor((Color)UIManager.get("Menu.selectionBackground"));
            g.fillRect(1, 2, w - 2, h);
        }
    }

    static boolean isToolbarButton(JComponent c) {
        return c.getParent() instanceof JToolBar;
    }

    static void drawToolbarButtonSkin(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        AbstractButton b = (AbstractButton)c;
        if (c.getParent() instanceof JToolBar) {
            g.setColor(c.getParent().getBackground());
        } else {
            g.setColor((Color)UIManager.get("ToolBar.background"));
        }
        g.fillRect(0, 0, b.getWidth(), b.getHeight());
        if (b.getModel().isSelected() || b.getModel().isPressed() && b.getModel().isArmed()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new ColorUIResource(225, 225, 225), 0.0f, h, new ColorUIResource(255, 255, 255)));
            g2.fillRect(1, 1, w - 2, h - 2);
            g.setColor(new ColorUIResource(170, 170, 170));
            g.drawLine(2, 0, w - 3, 0);
            g.drawLine(0, 2, 0, h - 3);
            g.setColor(new ColorUIResource(250, 250, 250));
            g.drawLine(w - 1, 2, w - 1, h - 3);
            g.drawLine(2, h - 1, w - 3, h - 1);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(0, 1, 1, 0);
            g.drawLine(w - 1, 1, w - 2, 0);
            g.setColor(new ColorUIResource(230, 230, 230));
            g.drawLine(1, h - 1, 0, h - 2);
            g.setColor(new ColorUIResource(250, 250, 250));
            g.drawLine(w - 1, h - 2, w - 2, h - 1);
            g.setColor(new ColorUIResource(240, 240, 240));
            g.drawLine(0, 0, 0, 0);
            g.drawLine(w - 1, 0, w - 1, 0);
        } else if (b.getModel().isRollover()) {
            g.setColor(new ColorUIResource(200, 200, 200));
            g.drawLine(2, 0, w - 3, 0);
            g.drawLine(2, h - 1, w - 3, h - 1);
            g.drawLine(0, 2, 0, h - 3);
            g.drawLine(w - 1, 2, w - 1, h - 3);
            g.drawLine(1, 1, 1, 1);
            g.drawLine(w - 2, 1, w - 2, 1);
            g.drawLine(1, h - 2, 1, h - 2);
            g.drawLine(w - 2, h - 2, w - 2, h - 2);
            g.setColor(new ColorUIResource(220, 220, 220));
            g.drawLine(0, 1, 1, 0);
            g.drawLine(w - 1, 1, w - 2, 0);
            g.drawLine(1, h - 1, 0, h - 2);
            g.drawLine(w - 1, h - 2, w - 2, h - 1);
            g.setColor(new ColorUIResource(235, 235, 235));
            g.drawLine(1, 2, 2, 1);
            g.drawLine(w - 2, 2, w - 3, 1);
            g.setColor(new ColorUIResource(215, 215, 215));
            g.drawLine(2, h - 2, 1, h - 3);
            g.drawLine(w - 2, h - 3, w - 3, h - 2);
        }
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static class spinnerButton
    extends JButton {
        JButton c = this;
        private boolean _$10094 = false;
        Dimension d;

        public spinnerButton(String type) {
            if (type.equals("up")) {
                this._$10094 = true;
            }
            this.setBorder(null);
            this.setContentAreaFilled(false);
        }

        private void _$10095(Graphics g) {
            int w = (int)this.getSize().getWidth();
            int h = (int)this.getSize().getHeight();
            boolean index = false;
            if (this.getModel().isEnabled()) {
                if (this.getModel().isPressed()) {
                    g.setColor(new ColorUIResource(210, 210, 210));
                    g.drawLine(1, 0, w - 1, 0);
                    g.fillRect(1, 1, w - 1, h - 3);
                    g.drawLine(1, h - 4, w - 1, h - 4);
                    g.drawLine(1, h - 3, w - 2, h - 3);
                    g.drawLine(1, h - 2, w - 3, h - 2);
                    g.drawLine(1, h - 1, w - 5, h - 1);
                    g.drawLine(1, 0, w - 1, 0);
                    g.drawLine(w - 1, 1, w - 1, h - 3);
                    g.drawLine(w - 2, 1, w - 2, h - 4);
                    g.drawLine(w - 3, 1, w - 3, h - 4);
                    g.setColor(new ColorUIResource(150, 150, 150));
                    g.drawLine(0, 0, 0, h);
                } else {
                    g.setColor(new ColorUIResource(247, 247, 247));
                    g.drawLine(1, 0, w - 1, 0);
                    g.setColor(new ColorUIResource(247, 247, 247));
                    g.fillRect(1, 1, w - 1, h - 3);
                    g.setColor(new ColorUIResource(240, 240, 240));
                    g.drawLine(1, h - 4, w - 1, h - 4);
                    g.setColor(new ColorUIResource(230, 230, 230));
                    g.drawLine(1, h - 3, w - 2, h - 3);
                    g.setColor(new ColorUIResource(220, 220, 220));
                    g.drawLine(1, h - 2, w - 3, h - 2);
                    g.setColor(new ColorUIResource(215, 215, 215));
                    g.drawLine(1, h - 1, w - 5, h - 1);
                    g.setColor(new ColorUIResource(240, 240, 240));
                    g.drawLine(1, 0, w - 1, 0);
                    g.setColor(new ColorUIResource(150, 150, 150));
                    g.drawLine(0, 0, 0, h);
                    g.setColor(new ColorUIResource(230, 230, 230));
                    g.drawLine(w - 1, 1, w - 1, h - 3);
                    g.setColor(new ColorUIResource(235, 235, 235));
                    g.drawLine(w - 2, 1, w - 2, h - 4);
                    g.setColor(new ColorUIResource(240, 240, 240));
                    g.drawLine(w - 3, 1, w - 3, h - 4);
                }
            } else {
                g.setColor(new ColorUIResource(235, 235, 235));
                g.drawLine(1, 0, w - 1, 0);
                g.fillRect(1, 1, w - 1, h - 3);
                g.drawLine(1, h - 4, w - 1, h - 4);
                g.drawLine(1, h - 3, w - 2, h - 3);
                g.drawLine(1, h - 2, w - 3, h - 2);
                g.drawLine(1, h - 1, w - 5, h - 1);
                g.drawLine(1, 0, w - 1, 0);
                g.drawLine(w - 1, 1, w - 1, h - 3);
                g.drawLine(w - 2, 1, w - 2, h - 4);
                g.drawLine(w - 3, 1, w - 3, h - 4);
                g.setColor(new ColorUIResource(150, 150, 150));
                g.drawLine(0, 0, 0, h);
            }
        }

        private void _$10096(Graphics g) {
            this.d = this.getSize();
            int h = (int)this.d.getHeight();
            int w = (int)this.d.getWidth();
            if (this.getModel().isEnabled()) {
                if (this.getModel().isPressed()) {
                    g.setColor(new ColorUIResource(210, 210, 210));
                    g.drawLine(1, 0, w - 5, 0);
                    g.drawLine(1, 1, w - 3, 1);
                    g.drawLine(1, 2, w - 2, 2);
                    g.fillRect(1, 3, w - 1, h - 3);
                    g.drawLine(1, h - 4, w - 1, h - 4);
                    g.drawLine(1, h - 3, w - 1, h - 3);
                    g.drawLine(1, h - 2, w - 1, h - 2);
                    g.drawLine(1, h - 1, w - 1, h - 1);
                    g.drawLine(1, h - 1, w - 1, h - 1);
                    g.drawLine(w - 1, 3, w - 1, h - 3);
                    g.drawLine(w - 2, 2, w - 2, h - 4);
                    g.drawLine(w - 3, 1, w - 3, h - 4);
                    g.setColor(new ColorUIResource(150, 150, 150));
                    g.drawLine(0, 0, 0, h);
                } else {
                    g.setColor(new ColorUIResource(240, 240, 240));
                    g.drawLine(1, 0, w - 5, 0);
                    g.setColor(new ColorUIResource(247, 247, 247));
                    g.drawLine(1, 1, w - 3, 1);
                    g.drawLine(1, 2, w - 2, 2);
                    g.fillRect(1, 3, w - 1, h - 3);
                    g.setColor(new ColorUIResource(240, 240, 240));
                    g.drawLine(1, h - 4, w - 1, h - 4);
                    g.setColor(new ColorUIResource(230, 230, 230));
                    g.drawLine(1, h - 3, w - 1, h - 3);
                    g.setColor(new ColorUIResource(220, 220, 220));
                    g.drawLine(1, h - 2, w - 1, h - 2);
                    g.setColor(new ColorUIResource(215, 215, 215));
                    g.drawLine(1, h - 1, w - 1, h - 1);
                    g.setColor(new ColorUIResource(150, 150, 150));
                    g.drawLine(1, h - 1, w - 1, h - 1);
                    g.drawLine(0, 0, 0, h);
                    g.setColor(new ColorUIResource(230, 230, 230));
                    g.drawLine(w - 1, 3, w - 1, h - 3);
                    g.setColor(new ColorUIResource(235, 235, 235));
                    g.drawLine(w - 2, 2, w - 2, h - 4);
                    g.setColor(new ColorUIResource(240, 240, 240));
                    g.drawLine(w - 3, 1, w - 3, h - 4);
                }
            } else {
                g.setColor(new ColorUIResource(235, 235, 235));
                g.drawLine(1, 0, w - 5, 0);
                g.drawLine(1, 1, w - 3, 1);
                g.drawLine(1, 2, w - 2, 2);
                g.fillRect(1, 3, w - 1, h - 3);
                g.drawLine(1, h - 4, w - 1, h - 4);
                g.drawLine(1, h - 3, w - 1, h - 3);
                g.drawLine(1, h - 2, w - 1, h - 2);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.drawLine(w - 1, 3, w - 1, h - 3);
                g.drawLine(w - 2, 2, w - 2, h - 4);
                g.drawLine(w - 3, 1, w - 3, h - 4);
                g.setColor(new ColorUIResource(150, 150, 150));
                g.drawLine(0, 0, 0, h);
            }
        }

        public void paintComponent(Graphics g) {
            if (this._$10094) {
                this._$10096(g);
            } else {
                this._$10095(g);
            }
            this.drawArrow(g);
        }

        protected void drawArrow(Graphics g) {
            this.d = this.getSize();
            if (this.getModel().isEnabled()) {
                g.setColor(new ColorUIResource(100, 100, 100));
            } else {
                g.setColor(new ColorUIResource(190, 190, 190));
            }
            int baseY = (int)(this.d.getHeight() / 2.0 - 2.0);
            if (!this._$10094) {
                ++baseY;
            }
            g.translate(5, baseY);
            if (this._$10094) {
                g.drawLine(2, 0, 3, 0);
                g.drawLine(1, 1, 4, 1);
                g.drawLine(0, 2, 1, 2);
                g.drawLine(4, 2, 5, 2);
            } else {
                g.drawLine(2, 2, 3, 2);
                g.drawLine(1, 1, 4, 1);
                g.drawLine(0, 0, 1, 0);
                g.drawLine(4, 0, 5, 0);
            }
            g.translate(-6, -baseY);
        }

        protected void paintBorder(Graphics g) {
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 6);
        }

        public Dimension getMinimumSize() {
            return new Dimension(16, 6);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }
}

