/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.skin.Skin;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LiquidTableHeaderUI
extends TableHeaderUI {
    protected static final int HEADER_HEIGHT = 22;
    private int columnSelected = -1;
    protected JTableHeader header;
    protected MouseInputListener mouseInputListener;
    protected CellRendererPane rendererPane;
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    private Skin skin;

    private Dimension createHeaderSize(long width) {
        TableColumnModel columnModel = this.header.getColumnModel();
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent h) {
        return new LiquidTableHeaderUI();
    }

    private int getHeaderHeight() {
        return 22;
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createHeaderSize(width);
    }

    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createHeaderSize(width);
    }

    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }

    public Skin getSkin() {
        if (this.skin == null) {
            this.skin = new Skin("tableheader.png", 8, 4, 13, 4, 10);
        }
        return this.skin;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    public void installUI(JComponent c) {
        this.header = (JTableHeader)c;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void paint(Graphics g, JComponent c) {
        int column;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        int columnMargin = cm.getColumnMargin();
        Rectangle cellRect = this.header.getHeaderRect(cMin);
        if (ltr) {
            column = cMin;
            while (column <= cMax) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
                ++column;
            }
        } else {
            int columnWidth;
            TableColumn aColumn = cm.getColumn(cMin);
            if (aColumn != draggedColumn) {
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                cellRect.x += columnMargin;
                this.paintCell(g, cellRect, cMin);
            }
            column = cMin + 1;
            while (column <= cMax) {
                aColumn = cm.getColumn(column);
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                cellRect.x -= columnWidth;
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                ++column;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedColumnIndex);
        }
        this.rendererPane.removeAll();
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        int index = 0;
        Component component = this.getHeaderRenderer(columnIndex);
        if (columnIndex == this.columnSelected) {
            index = 1;
        }
        this.getSkin().draw(g, index, cellRect.x, cellRect.y, cellRect.width, cellRect.height);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private int mouseXOffset;
        private Cursor otherCursor = LiquidTableHeaderUI.access$000();

        private boolean canResize(TableColumn column) {
            return column != null && LiquidTableHeaderUI.this.header.getResizingAllowed() && column.getResizable();
        }

        private TableColumn getResizingColumn(Point p, int column) {
            if (column == -1) {
                return null;
            }
            Rectangle r = LiquidTableHeaderUI.this.header.getHeaderRect(column);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return null;
            }
            int midPoint = r.x + r.width / 2;
            int columnIndex = LiquidTableHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? (p.x < midPoint ? column - 1 : column) : (p.x < midPoint ? column : column - 1);
            if (columnIndex == -1) {
                return null;
            }
            return LiquidTableHeaderUI.this.header.getColumnModel().getColumn(columnIndex);
        }

        private TableColumn getResizingColumn(Point p) {
            return this.getResizingColumn(p, LiquidTableHeaderUI.this.header.columnAtPoint(p));
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            int mouseX = e.getX();
            TableColumn resizingColumn = LiquidTableHeaderUI.this.header.getResizingColumn();
            TableColumn draggedColumn = LiquidTableHeaderUI.this.header.getDraggedColumn();
            boolean headerLeftToRight = LiquidTableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            if (resizingColumn != null) {
                JTable table;
                Container container;
                int oldWidth = resizingColumn.getWidth();
                int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
                resizingColumn.setWidth(newWidth);
                if (LiquidTableHeaderUI.this.header.getParent() == null || (container = LiquidTableHeaderUI.this.header.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                    return;
                }
                if (!container.getComponentOrientation().isLeftToRight() && !headerLeftToRight && (table = LiquidTableHeaderUI.this.header.getTable()) != null) {
                    JViewport viewport = ((JScrollPane)container).getViewport();
                    int viewportWidth = viewport.getWidth();
                    int diff = newWidth - oldWidth;
                    int newHeaderWidth = table.getWidth() + diff;
                    Dimension tableSize = table.getSize();
                    tableSize.width += diff;
                    table.setSize(tableSize);
                    if (newHeaderWidth >= viewportWidth && table.getAutoResizeMode() == 0) {
                        Point p = viewport.getViewPosition();
                        p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                        viewport.setViewPosition(p);
                        this.mouseXOffset += diff;
                    }
                }
            } else if (draggedColumn != null) {
                TableColumnModel cm = LiquidTableHeaderUI.this.header.getColumnModel();
                int draggedDistance = mouseX - this.mouseXOffset;
                int direction = draggedDistance < 0 ? -1 : 1;
                int columnIndex = LiquidTableHeaderUI.this.viewIndexForColumn(draggedColumn);
                int newColumnIndex = columnIndex + (headerLeftToRight ? direction : -direction);
                if (0 <= newColumnIndex && newColumnIndex < cm.getColumnCount()) {
                    int width = cm.getColumn(newColumnIndex).getWidth();
                    if (Math.abs(draggedDistance) > width / 2) {
                        this.mouseXOffset += direction * width;
                        LiquidTableHeaderUI.this.header.setDraggedDistance(draggedDistance - direction * width);
                        cm.moveColumn(columnIndex, newColumnIndex);
                        return;
                    }
                }
                this.setDraggedDistance(draggedDistance, columnIndex);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            LiquidTableHeaderUI.this.columnSelected = -1;
            LiquidTableHeaderUI.this.header.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            if (this.canResize(this.getResizingColumn(e.getPoint())) != (LiquidTableHeaderUI.this.header.getCursor() == resizeCursor)) {
                this.swapCursor();
            }
            Point p = e.getPoint();
            TableColumnModel columnModel = LiquidTableHeaderUI.this.header.getColumnModel();
            int index = LiquidTableHeaderUI.this.header.columnAtPoint(p);
            if (index != LiquidTableHeaderUI.this.columnSelected) {
                LiquidTableHeaderUI.this.columnSelected = index;
                LiquidTableHeaderUI.this.header.repaint();
            }
        }

        public void mousePressed(MouseEvent e) {
            LiquidTableHeaderUI.this.header.setDraggedColumn(null);
            LiquidTableHeaderUI.this.header.setResizingColumn(null);
            LiquidTableHeaderUI.this.header.setDraggedDistance(0);
            Point p = e.getPoint();
            TableColumnModel columnModel = LiquidTableHeaderUI.this.header.getColumnModel();
            int index = LiquidTableHeaderUI.this.header.columnAtPoint(p);
            if (index != -1) {
                TableColumn resizingColumn = this.getResizingColumn(p, index);
                if (this.canResize(resizingColumn)) {
                    LiquidTableHeaderUI.this.header.setResizingColumn(resizingColumn);
                    this.mouseXOffset = LiquidTableHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? p.x - resizingColumn.getWidth() : p.x + resizingColumn.getWidth();
                } else if (LiquidTableHeaderUI.this.header.getReorderingAllowed()) {
                    TableColumn hitColumn = columnModel.getColumn(index);
                    LiquidTableHeaderUI.this.header.setDraggedColumn(hitColumn);
                    this.mouseXOffset = p.x;
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.setDraggedDistance(0, LiquidTableHeaderUI.this.viewIndexForColumn(LiquidTableHeaderUI.this.header.getDraggedColumn()));
            LiquidTableHeaderUI.this.header.setResizingColumn(null);
            LiquidTableHeaderUI.this.header.setDraggedColumn(null);
        }

        private void setDraggedDistance(int draggedDistance, int column) {
            LiquidTableHeaderUI.this.header.setDraggedDistance(draggedDistance);
            if (column != -1) {
                LiquidTableHeaderUI.this.header.getColumnModel().moveColumn(column, column);
            }
        }

        private void swapCursor() {
            Cursor tmp = LiquidTableHeaderUI.this.header.getCursor();
            LiquidTableHeaderUI.this.header.setCursor(this.otherCursor);
            this.otherCursor = tmp;
        }
    }
}

