/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fsp.fsplib;

import java.io.IOException;
import java.net.DatagramPacket;

public class FSPpacket {
    public static final int HSIZE = 12;
    public static final int SPACE = 1024;
    public static final int MAXSPACE = 1024;
    public static final int MAXSIZE = 1036;
    protected boolean serverside = false;
    public byte cmd;
    public byte sum;
    public short bb_key;
    public short bb_seq;
    public short bb_len;
    public int bb_pos;
    public int xtra_len;
    public byte[] buf = new byte[1024];
    public static final byte CC_VERSION = 16;
    public static final byte CC_INFO = 17;
    public static final byte CC_ERR = 64;
    public static final byte CC_GET_DIR = 65;
    public static final byte CC_GET_FILE = 66;
    public static final byte CC_UP_LOAD = 67;
    public static final byte CC_INSTALL = 68;
    public static final byte CC_DEL_FILE = 69;
    public static final byte CC_DEL_DIR = 70;
    public static final byte CC_GET_PRO = 71;
    public static final byte CC_SET_PRO = 72;
    public static final byte CC_MAKE_DIR = 73;
    public static final byte CC_BYE = 74;
    public static final byte CC_GRAB_FILE = 75;
    public static final byte CC_GRAB_DONE = 76;
    public static final byte CC_STAT = 77;
    public static final byte CC_RENAME = 78;
    public static final byte CC_LIMIT = -128;
    public static final byte CC_TEST = -127;

    public FSPpacket() {
    }

    public FSPpacket(boolean serverside) {
        this();
        this.serverside = serverside;
    }

    public boolean disassemble(DatagramPacket udp) {
        short nbb_len;
        byte[] data = udp.getData();
        short nsum = (short)udp.getLength();
        int nxtra_len = nsum - 12 - (nbb_len = (short)(data[6] << 8 | data[7] & 0xFF));
        if (nxtra_len < 0) {
            return false;
        }
        if (nbb_len + nxtra_len > 1024) {
            return false;
        }
        this.sum = data[1];
        data[1] = 0;
        int t = nsum - 1;
        if (!this.serverside) {
            nsum = 0;
        }
        while (t >= 0) {
            nsum = (short)(nsum + (data[t] & 0xFF));
            --t;
        }
        byte csum = (byte)(nsum + (nsum >>> 8));
        if (csum != this.sum) {
            return false;
        }
        this.cmd = data[0];
        this.bb_key = (short)(data[2] << 8 | data[3] & 0xFF);
        this.bb_seq = (short)(data[4] << 8 | data[5] & 0xFF);
        this.bb_pos = (data[8] << 8 | data[9] & 0xFF) << 16;
        this.bb_pos |= (data[10] & 0xFF) << 8 | data[11] & 0xFF;
        this.bb_len = nbb_len;
        this.xtra_len = nxtra_len;
        System.arraycopy(data, 12, this.buf, 0, this.bb_len + this.xtra_len);
        return true;
    }

    public DatagramPacket assemble(DatagramPacket udp) {
        byte[] data = udp.getData();
        int payload = this.bb_len + this.xtra_len;
        if (payload > 1024) {
            throw new IllegalArgumentException("Maximum supported payload by this library is 1024");
        }
        if (data.length < 12 + payload) {
            data = new byte[payload + 12];
            udp.setData(data);
        }
        data[0] = this.cmd;
        data[1] = 0;
        data[2] = (byte)(this.bb_key >>> 8 & 0xFF);
        data[3] = (byte)(this.bb_key & 0xFF);
        data[4] = (byte)(this.bb_seq >>> 8 & 0xFF);
        data[5] = (byte)(this.bb_seq & 0xFF);
        data[6] = (byte)(this.bb_len >>> 8 & 0xFF);
        data[7] = (byte)(this.bb_len & 0xFF);
        data[8] = (byte)(this.bb_pos >>> 24 & 0xFF);
        data[9] = (byte)(this.bb_pos >>> 16 & 0xFF);
        data[10] = (byte)(this.bb_pos >>> 8 & 0xFF);
        data[11] = (byte)(this.bb_pos & 0xFF);
        System.arraycopy(this.buf, 0, data, 12, payload);
        short nsum = 0;
        if (!this.serverside) {
            nsum = (short)(12 + payload);
        }
        for (int t = 12 + payload - 1; t >= 0; --t) {
            nsum = (short)(nsum + (data[t] & 0xFF));
        }
        data[1] = (byte)(nsum + (nsum >>> 8));
        this.sum = data[1];
        udp.setLength(12 + payload);
        return udp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(40);
        sb.append(this.getClass());
        sb.append(" cmd=0x");
        sb.append(Integer.toString(this.cmd & 0xFF, 16));
        sb.append(" sum=0x");
        sb.append(Integer.toString(this.sum & 0xFF, 16));
        sb.append(" key=0x");
        sb.append(Integer.toString(this.bb_key & 0xFFFF, 16));
        sb.append(" seq=0x");
        sb.append(Integer.toString(this.bb_seq & 0xFFFF, 16));
        sb.append(" len=");
        sb.append(this.bb_len);
        sb.append(" pos=");
        sb.append(this.bb_pos);
        sb.append(" xtra_len=");
        sb.append(this.xtra_len);
        return sb.toString();
    }

    public void setData(byte[] data1, int offset1, int length1, byte[] data2, int offset2, int length2) {
        if (length1 + length2 > 1024) {
            throw new IllegalArgumentException("Maximum supported payload size is 1024");
        }
        if (length1 > 0) {
            try {
                System.arraycopy(data1, offset1, this.buf, 0, length1);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("invalid offset1/length1");
            }
        } else if (length1 < 0) {
            throw new IllegalArgumentException("length1 can not be negative");
        }
        this.bb_len = (short)length1;
        if (length2 > 0) {
            try {
                System.arraycopy(data2, offset2, this.buf, this.bb_len, length2);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("invalid offset2/length2");
            }
        } else if (length2 < 0) {
            throw new IllegalArgumentException("length2 can not be negative");
        }
        this.xtra_len = (short)length2;
    }

    public boolean isServerSide() {
        return this.serverside;
    }

    public void expect(byte command) throws IOException {
        if (this.cmd == command) {
            return;
        }
        if (this.cmd == 64) {
            throw new IOException("FSP ERR: " + new String(this.buf, 0, this.bb_len - 1));
        }
        throw new IOException("Unexpected FSP server response. Expected: " + command + " Received: " + this.cmd);
    }
}

