/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fsp.fsplib;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sf.fsp.fsplib.FSPpacket;

public class FSPsession {
    private DatagramSocket socket = new DatagramSocket();
    private DatagramPacket udp;
    private FSPpacket packet;
    private short seq;
    private int timeout;
    private int delay;
    private int maxdelay;
    private int port;
    private InetAddress host;
    private String hostadr;
    private static Hashtable locks;
    private volatile Object writer;
    private Object lockwait;
    public static final int MIN_DELAY = 1000;
    public static final int DEFAULT_DELAY = 1340;
    public static final int MAX_DELAY = 60000;
    public static final int DEFAULT_TIMEOUT = 300000;

    public FSPsession(String host, int port) throws SocketException, UnknownHostException {
        this(InetAddress.getByName(host), port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSPsession(InetAddress host, int port) throws SocketException {
        this.udp = new DatagramPacket(new byte[1036], 1036, host, port);
        if (port == 0) {
            port = 21;
        }
        this.udp.setPort(port);
        this.udp.setAddress(host);
        this.packet = new FSPpacket();
        this.seq = (short)((int)(Math.random() * 65535.0) & 0xFFF8);
        this.timeout = 300000;
        this.delay = 1340;
        this.maxdelay = 60000;
        if (locks == null) {
            locks = new Hashtable();
        }
        this.hostadr = host.getHostAddress() + ":" + port;
        this.hostadr = this.hostadr.intern();
        Hashtable hashtable = locks;
        synchronized (hashtable) {
            Short k = (Short)locks.get(this.hostadr);
            if (k == null) {
                k = new Short(0);
                locks.put(this.hostadr, k);
            }
            Enumeration en = locks.keys();
            while (en.hasMoreElements()) {
                String hkey = (String)en.nextElement();
                if (!this.hostadr.equals(hkey)) continue;
                this.hostadr = hkey;
                break;
            }
        }
        this.port = port;
        this.host = host;
        this.lockwait = new Object();
    }

    public FSPpacket interact(byte cmd, long filepos, byte[] data1, int offset1, int length1, byte[] data2, int offset2, int length2) throws SocketTimeoutException {
        int rdelay = this.delay;
        int rtimeout = 0;
        this.packet.setData(data1, offset1, length1, data2, offset2, length2);
        Short k = new Short((short)((int)(Math.random() * 65535.0) & 0xFFF8));
        this.seq = k == this.seq ? (short)(this.seq ^ 0x1080) : k;
        this.packet.bb_seq = this.seq;
        this.packet.bb_pos = (int)(filepos & 0xFFFFFFFFFFFFFFFFL);
        this.packet.cmd = cmd;
        String string = this.hostadr;
        synchronized (string) {
            k = (Short)locks.get(this.hostadr);
            this.packet.bb_key = k;
            while (true) {
                this.packet.bb_seq = (short)(this.packet.bb_seq + 1);
                this.packet.bb_seq = (short)(this.seq + (this.packet.bb_seq & 7));
                this.packet.assemble(this.udp);
                try {
                    this.socket.setSoTimeout(rdelay);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                try {
                    this.socket.send(this.udp);
                    this.udp.setLength(1036);
                    this.socket.receive(this.udp);
                    if (this.packet.disassemble(this.udp)) {
                        if (this.packet.cmd != cmd && this.packet.cmd != 64 || (long)this.packet.bb_pos != filepos && (cmd == 65 || cmd == 66 || cmd == 67 || cmd == 75 || cmd == 17)) continue;
                        if ((this.packet.bb_seq & 0xFFF8) == (this.seq & 0xFFF8)) {
                            locks.put(this.hostadr, new Short(this.packet.bb_key));
                            return this.packet;
                        }
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if ((rtimeout += rdelay) >= this.timeout) {
                    throw new SocketTimeoutException("Timeout");
                }
                if ((rdelay = (int)((float)rdelay * 1.5f)) <= this.maxdelay) continue;
                rdelay = this.maxdelay;
            }
        }
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.interact((byte)74, 0L, null, 0, 0, null, 0, 0);
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
        this.udp = null;
        this.packet = null;
        this.host = null;
        this.port = 0;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        if (delay < 1000) {
            this.delay = 1000;
        } else if (delay > 60000) {
            this.delay = 60000;
        }
        this.delay = delay;
    }

    public int getMaxDelay() {
        return this.maxdelay;
    }

    public void setMaxDelay(int delay) {
        this.maxdelay = delay > 60000 ? 60000 : delay;
    }

    public int getTimeout() {
        if (this.timeout == Integer.MAX_VALUE) {
            return 0;
        }
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout > 0) {
            this.timeout = timeout;
        } else if (timeout == 0) {
            this.timeout = Integer.MAX_VALUE;
        }
    }

    public InetAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void finalize() {
        this.timeout = 7000;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockWriter(Object lock, boolean wait) {
        Object object = this.lockwait;
        synchronized (object) {
            if (this.writer != null && this.writer != lock) {
                if (wait) {
                    do {
                        try {
                            this.lockwait.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (this.writer != null);
                    this.writer = lock;
                    return;
                }
                throw new IllegalStateException("Writer is locked");
            }
            this.writer = lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockWriter(Object lock) {
        Object object = this.lockwait;
        synchronized (object) {
            if (this.writer == null || this.writer != lock) {
                throw new IllegalStateException("Not write lock owner");
            }
            this.writer = null;
            this.lockwait.notify();
        }
    }
}

