/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.sweet.components.win32;

import chrriis.dj.sweet.components.OleAccess;
import chrriis.dj.sweet.components.win32.JWMediaPlayer;

public class WMPControls {
    private OleAccess oleAccess;

    WMPControls(JWMediaPlayer wMediaPlayer) {
        this.oleAccess = wMediaPlayer.getOleAccess();
    }

    public boolean isPlayEnabled() {
        return Boolean.TRUE.equals(this.oleAccess.getOleProperty(new String[]{"controls", "isAvailable"}, "Play"));
    }

    public void play() {
        this.oleAccess.invokeOleFunction(new String[]{"controls", "Play"}, new Object[0]);
    }

    public boolean isStopEnabled() {
        return Boolean.TRUE.equals(this.oleAccess.getOleProperty(new String[]{"controls", "isAvailable"}, "Stop"));
    }

    public void stop() {
        this.oleAccess.invokeOleFunction(new String[]{"controls", "Stop"}, new Object[0]);
    }

    public boolean isPauseEnabled() {
        return Boolean.TRUE.equals(this.oleAccess.getOleProperty(new String[]{"controls", "isAvailable"}, "Pause"));
    }

    public void pause() {
        this.oleAccess.invokeOleFunction(new String[]{"controls", "Pause"}, new Object[0]);
    }

    public void setAbsolutePosition(int time) {
        this.oleAccess.setOleProperty(new String[]{"controls", "currentPosition"}, (double)time / 1000.0);
    }

    public int getAbsolutePosition() {
        try {
            return (int)Math.round((Double)this.oleAccess.getOleProperty(new String[]{"controls", "currentPosition"}, new Object[0]) * 1000.0);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

