/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.C018FE95;
import com.sun.gssapi.GSSCredSpi;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSNameSpi;
import com.sun.gssapi.MechInfo;
import com.sun.gssapi.MechTable;
import com.sun.gssapi.Oid;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class GSSManager {
    private static MechInfo m_defaultMech;

    static {
        GSSManager.initialize();
    }

    static C018FE95 _M4092FBA(Oid oid) throws GSSException {
        MechInfo mechInfo = GSSManager.getMechInfo(oid, true);
        return mechInfo._M4092FBA();
    }

    private static void addUniqueOid(Vector vector, Oid oid) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (!((Oid)enumeration.nextElement()).equals(oid)) continue;
            return;
        }
        vector.addElement(oid);
    }

    static GSSCredSpi getCredInstance(Oid oid) throws GSSException {
        MechInfo mechInfo = GSSManager.getMechInfo(oid, true);
        return mechInfo.getCredInstance();
    }

    public static Oid getDefaultMech() throws GSSException {
        if (m_defaultMech != null) {
            return m_defaultMech.getOid();
        }
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            String[] stringArray = MechInfo.getMechsForProvider(providerArray[n]);
            if (stringArray != null) {
                m_defaultMech = new MechInfo(providerArray[n], stringArray[0]);
                return m_defaultMech.getOid();
            }
            ++n;
        }
        throw new GSSException(2);
    }

    private static synchronized MechInfo getMechInfo(Oid oid, boolean bl) throws GSSException {
        MechInfo mechInfo = MechTable.getMechInfo(oid);
        if (mechInfo != null) {
            if (bl) {
                MechTable.putMechInfo(mechInfo);
            }
            return mechInfo;
        }
        Provider[] providerArray = Security.getProviders();
        String string = oid.toString();
        int n = 0;
        while (n < providerArray.length) {
            if (MechInfo.implementsMech(providerArray[n], string)) {
                try {
                    mechInfo = new MechInfo(providerArray[n], string);
                    if (bl) {
                        MechTable.putMechInfo(mechInfo);
                    }
                    return mechInfo;
                }
                catch (GSSException gSSException) {}
            }
            ++n;
        }
        throw new GSSException(2);
    }

    public static Oid[] getMechs() {
        Object[] objectArray;
        Provider[] providerArray = Security.getProviders();
        Vector vector = new Vector(5, 3);
        int n = 0;
        while (n < providerArray.length) {
            objectArray = MechInfo.getMechsForProvider(providerArray[n]);
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    try {
                        GSSManager.addUniqueOid(vector, new Oid((String)objectArray[n2]));
                    }
                    catch (GSSException gSSException) {}
                    ++n2;
                }
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new Oid[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Oid[] getMechsForName(Oid oid) {
        Object[] objectArray;
        Provider[] providerArray = Security.getProviders();
        Vector vector = new Vector(5, 3);
        int n = 0;
        while (n < providerArray.length) {
            objectArray = MechInfo.getInfoForAllMechs(providerArray[n]);
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (((MechInfo)objectArray[n2]).supportsName(oid)) {
                        GSSManager.addUniqueOid(vector, ((MechInfo)objectArray[n2]).getOid());
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new Oid[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static GSSNameSpi getNameInstance(Oid oid) throws GSSException {
        MechInfo mechInfo = GSSManager.getMechInfo(oid, true);
        return mechInfo.getNameInstance();
    }

    public static Oid[] getNamesForMech(Oid oid) throws GSSException {
        MechInfo mechInfo = GSSManager.getMechInfo(oid, false);
        return mechInfo.getNames();
    }

    private static void initialize() {
        int n = 1;
        try {
            String string;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.gssapi.mechs");
            while ((string = resourceBundle.getString("gss.provider." + n++)) != null) {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                if (!(obj instanceof Provider)) continue;
                Security.addProvider((Provider)obj);
            }
        }
        catch (Exception exception) {}
    }

    private static void showProviderDetails() {
        Provider[] providerArray = Security.getProviders();
        boolean bl = false;
        int n = 0;
        while (n < providerArray.length) {
            MechInfo[] mechInfoArray = MechInfo.getInfoForAllMechs(providerArray[n]);
            if (mechInfoArray != null) {
                bl = true;
            }
            ++n;
        }
    }
}

