/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.framework.HImageButton;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.ConnectionHandler;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.DataConnection;
import net.sf.jftp.net.FtpConnection;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.logging.Log;

public class DownloadQueue
extends HPanel
implements ActionListener {
    private static final String SEP = "--> ";
    int NumRetry = 5;
    private DefaultListModel liststr = new DefaultListModel();
    private JList list = new JList(this.liststr);
    private ArrayList queue = new ArrayList();
    private queueDownloader thread = new queueDownloader();
    private QueueRecord lastDownload;
    private BasicConnection con;
    private HImageButton start = new HImageButton(Settings.resumeImage, "start", "Start queue download...", this);
    private HImageButton stop = new HImageButton(Settings.pauseImage, "stop", "Stop queue download...", this);
    private HImageButton save = new HImageButton(Settings.saveImage, "save", "Save queue list to file...", this);
    private HImageButton load = new HImageButton(Settings.cdImage, "load", "Load queue list from...", this);
    private HImageButton up = new HImageButton(Settings.downloadImage, "up", "Change order of queue", this);
    private HImageButton down = new HImageButton(Settings.uploadImage, "down", "Change order of queue", this);
    private HImageButton delete = new HImageButton(Settings.deleteImage, "del", "Delete item in queue", this);
    private boolean isThere = false;
    private boolean downloading = false;
    private ConnectionHandler handler = new ConnectionHandler();
    private JLabel statuslabel;

    public DownloadQueue() {
        this.setLayout(new BorderLayout());
        HPanel cmdP = new HPanel();
        cmdP.add(this.start);
        cmdP.add(this.stop);
        cmdP.add(new JLabel("   "));
        cmdP.add(this.up);
        cmdP.add(this.down);
        cmdP.add(this.delete);
        cmdP.add(new JLabel("   "));
        cmdP.add(this.save);
        cmdP.add(this.load);
        this.start.setSize(24, 24);
        this.stop.setSize(24, 24);
        this.up.setSize(24, 24);
        this.down.setSize(24, 24);
        this.delete.setSize(24, 24);
        this.save.setSize(24, 24);
        this.load.setSize(24, 24);
        JScrollPane dP = new JScrollPane(this.list);
        this.add((Component)cmdP, "South");
        this.add((Component)dP, "Center");
        HPanel status = new HPanel();
        this.statuslabel = new JLabel("");
        this.statuslabel.setSize(100, 100);
        status.add(this.statuslabel);
        this.add((Component)status, "North");
        this.start.setToolTipText("Start queue download...");
        this.stop.setToolTipText("Stop queue download...");
        this.save.setToolTipText("Save queue list to file...");
        this.load.setToolTipText("Load queue list from...");
        this.up.setToolTipText("Change order of queue");
        this.down.setToolTipText("Change order of queue");
        this.delete.setToolTipText("Delete item in queue");
    }

    public void addFtp(String file) {
        Log.debug("Remote File" + JFtp.remoteDir.getPath() + file + "Local File" + JFtp.localDir.getPath() + file + "HostName" + JFtp.hostinfo.hostname);
        QueueRecord rec = new QueueRecord();
        rec.type = "ftp";
        rec.hostname = JFtp.hostinfo.hostname;
        rec.username = JFtp.hostinfo.username;
        rec.password = JFtp.hostinfo.password;
        rec.port = JFtp.hostinfo.port;
        rec.local = JFtp.localDir.getPath();
        rec.remote = JFtp.remoteDir.getPath();
        rec.file = file;
        this.queue.add(rec);
        this.liststr.addElement(rec.hostname + " : " + rec.remote + rec.file);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("start")) {
            if (this.thread != null) {
                if (!this.thread.isAlive()) {
                    this.thread = new queueDownloader();
                    this.thread.start();
                }
            } else {
                this.thread = new queueDownloader();
                this.thread.start();
            }
        } else if (e.getActionCommand().equals("stop")) {
            if (this.thread != null) {
                this.thread.block = true;
                FtpConnection ftpcon = (FtpConnection)this.con;
                DataConnection dcon = ftpcon.getDataConnection();
                dcon.getCon().work = false;
                try {
                    dcon.sock.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equals("down")) {
            if (this.list.getSelectedIndex() != -1) {
                int a = this.list.getSelectedIndex();
                int b = a + 1;
                QueueRecord qa = (QueueRecord)this.queue.get(b);
                this.queue.remove(b);
                this.queue.add(a, qa);
                String sa = (String)this.liststr.get(b);
                this.liststr.remove(b);
                this.liststr.add(a, sa);
                this.list.setSelectedIndex(b);
            }
        } else if (e.getActionCommand().equals("up")) {
            if (this.list.getSelectedIndex() != -1) {
                int a = this.list.getSelectedIndex() - 1;
                int b = a + 1;
                QueueRecord qa = (QueueRecord)this.queue.get(b);
                this.queue.remove(b);
                this.queue.add(a, qa);
                String sa = (String)this.liststr.get(b);
                this.liststr.remove(b);
                this.liststr.add(a, sa);
                this.list.setSelectedIndex(a);
            }
        } else if (e.getActionCommand().equals("del")) {
            if (this.list.getSelectedIndex() != -1) {
                this.queue.remove(this.list.getSelectedIndex());
                this.liststr.remove(this.list.getSelectedIndex());
                this.list.setSelectedIndex(0);
            }
        } else if (e.getActionCommand().equals("save")) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Save file");
            chooser.setDialogType(1);
            int returnVal = chooser.showSaveDialog(new JDialog());
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                this.saveList(f);
            }
        } else if (e.getActionCommand().equals("load")) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Open file");
            chooser.setDialogType(0);
            int returnVal = chooser.showOpenDialog(new JDialog());
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                this.loadList(f);
            }
        }
    }

    private void saveList(File file) {
        try {
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fos = new FileOutputStream(file);
            PrintStream f = new PrintStream(fos);
            for (int i = 0; i <= this.queue.size(); ++i) {
                QueueRecord rec = (QueueRecord)this.queue.get(i);
                f.println(rec.type);
                f.println(rec.hostname);
                f.println(rec.username);
                f.println(rec.password);
                f.println(rec.port);
                f.println(rec.file);
                f.println(rec.local);
                f.println(rec.remote);
                f.println(rec.localip);
                f.println(rec.domain);
            }
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadList(File file) {
        try {
            BufferedReader breader = new BufferedReader(new FileReader(file));
            boolean Eof = false;
            this.queue.clear();
            this.liststr.clear();
            while (!Eof) {
                QueueRecord rec = new QueueRecord();
                rec.type = breader.readLine();
                rec.hostname = breader.readLine();
                rec.username = breader.readLine();
                rec.password = breader.readLine();
                rec.port = breader.readLine();
                rec.file = breader.readLine();
                rec.local = breader.readLine();
                rec.remote = breader.readLine();
                rec.localip = breader.readLine();
                rec.domain = breader.readLine();
                if (rec.hostname == null) {
                    Eof = true;
                    continue;
                }
                this.queue.add(rec);
                this.liststr.addElement(rec.hostname + " : " + rec.remote + rec.file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void debug(String msg) {
        System.out.println(msg);
    }

    public void debugRaw(String msg) {
        System.out.print(msg);
    }

    public void debug(String msg, Throwable throwable) {
    }

    public void warn(String msg) {
    }

    public void warn(String msg, Throwable throwable) {
    }

    public void error(String msg) {
    }

    public void error(String msg, Throwable throwable) {
    }

    public void info(String msg) {
    }

    public void info(String msg, Throwable throwable) {
    }

    public void fatal(String msg) {
    }

    public void fatal(String msg, Throwable throwable) {
    }

    class queueDownloader
    extends Thread
    implements ConnectionListener {
        public boolean block = false;
        public boolean connected = false;
        public QueueRecord last;
        private FtpConnection conFtp;

        queueDownloader() {
        }

        @Override
        public void run() {
            try {
                while (DownloadQueue.this.queue.size() >= 1 && !this.block) {
                    QueueRecord rec;
                    this.last = rec = (QueueRecord)DownloadQueue.this.queue.get(0);
                    if (!this.connected) {
                        DownloadQueue.this.con = new FtpConnection(rec.hostname, Integer.parseInt(rec.port), "/");
                        this.conFtp = (FtpConnection)DownloadQueue.this.con;
                        this.conFtp.addConnectionListener(this);
                        this.conFtp.setConnectionHandler(DownloadQueue.this.handler);
                        this.conFtp.login(rec.username, rec.password);
                        this.connected = true;
                    }
                    this.conFtp.chdirNoRefresh(rec.remote);
                    this.conFtp.setLocalPath(rec.local);
                    int i = 0;
                    while (!DownloadQueue.this.isThere) {
                        if (++i > DownloadQueue.this.NumRetry) {
                            return;
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.conFtp.download(rec.file);
                    DownloadQueue.this.statuslabel.setText("");
                    if (DownloadQueue.this.queue.size() >= 1) {
                        rec = (QueueRecord)DownloadQueue.this.queue.get(0);
                        if (rec.hostname.compareTo(this.last.hostname) == 0 && rec.port.compareTo(this.last.port) == 0 && rec.username.compareTo(this.last.username) == 0 && rec.password.compareTo(this.last.password) == 0) {
                            this.connected = true;
                        } else {
                            this.conFtp.disconnect();
                            this.connected = false;
                        }
                    } else {
                        this.conFtp.disconnect();
                        this.connected = false;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.connected) {
                DownloadQueue.this.con.disconnect();
            }
        }

        @Override
        public void updateRemoteDirectory(BasicConnection con) {
        }

        @Override
        public void connectionInitialized(BasicConnection con) {
            DownloadQueue.this.isThere = true;
        }

        @Override
        public void updateProgress(String file, String type, long bytes) {
            String strtmp = StringUtils.getFile(file).compareTo("") == 0 ? "directory " + file : "file " + StringUtils.getFile(file);
            DownloadQueue.this.statuslabel.setText("Downloading " + strtmp + " - kbyte " + bytes / 1024L);
            String tmp = type.length() >= 10 ? type.substring(0, 9) : " ";
            if (!(type.compareTo("FINISHED") != 0 && tmp.compareTo("DFINISHED") != 0 || this.block)) {
                DownloadQueue.this.queue.remove(0);
                DownloadQueue.this.liststr.remove(0);
            }
        }

        @Override
        public void connectionFailed(BasicConnection con, String why) {
            System.out.println("connection failed!");
        }

        @Override
        public void actionFinished(BasicConnection con) {
        }
    }

    class QueueRecord {
        public String type;
        public String hostname;
        public String username;
        public String password;
        public String port;
        public String file;
        public String local;
        public String remote;
        public String localip;
        public String domain;
    }
}

