/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sf.jftp.gui.base.AppMenuBar;
import net.sf.jftp.gui.framework.GUIDefaults;
import net.sf.jftp.system.LocalIO;

public class StatusCanvas
extends JPanel {
    JLabel host = new JLabel("");
    JLabel separator = new JLabel("   ");
    JLabel text = new JLabel("Have a lot of fun...");
    String drawText = "";
    int pos = 0;
    Image image;
    Graphics offg;
    boolean slide = false;
    int interval = 3;
    boolean fwd = false;

    public StatusCanvas() {
        this.setMinimumSize(new Dimension(200, 25));
        this.setPreferredSize(new Dimension(320, 25));
        this.setLayout(null);
        this.setVisible(true);
    }

    public void setInterval(int x) {
        this.interval = x;
    }

    public void forward() {
        this.fwd = true;
    }

    public void setText(String msg) {
        this.text.setText("");
        this.drawText = msg;
        this.slide = false;
        if (AppMenuBar.fadeMenu.getState()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusCanvas.this.pos = 30;
                    while (StatusCanvas.this.pos > 0) {
                        StatusCanvas.this.paintImmediately(0, 0, StatusCanvas.this.getSize().width, StatusCanvas.this.getSize().height);
                        LocalIO.pause(StatusCanvas.this.interval);
                        --StatusCanvas.this.pos;
                    }
                }
            });
        } else {
            this.repaint();
        }
        this.validate();
    }

    public void scrollText(String msg) {
        this.text.setText("");
        this.drawText = msg;
        this.slide = true;
        if (AppMenuBar.fadeMenu.getState()) {
            this.pos = 700;
            while (this.pos > msg.length() * -6 && !this.fwd) {
                this.repaint();
                LocalIO.pause(this.interval);
                --this.pos;
            }
        } else {
            this.repaint();
        }
        this.fwd = false;
        this.validate();
    }

    public void setHost(String h) {
        this.host.setText(h);
        this.validate();
    }

    public String getHost() {
        return this.host.getText();
    }

    public void fresh() {
        this.image = null;
        this.offg = null;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.image == null) {
            this.image = this.createImage(this.getWidth(), this.getHeight());
        }
        if (this.offg == null) {
            this.offg = this.image.getGraphics();
        }
        this.offg.setColor(GUIDefaults.light);
        this.offg.setFont(GUIDefaults.status);
        this.offg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.offg.setColor(new Color(125, 125, 175));
        if (!this.slide) {
            this.offg.drawString(this.drawText, 10, 15 + this.pos);
        } else {
            this.offg.drawString(this.drawText, 10 + this.pos, 15);
        }
        this.offg.setColor(GUIDefaults.front);
        this.offg.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        this.offg.drawRect(0, 0, this.getSize().width - 2, this.getSize().height - 2);
        g.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paintComponent(g);
    }
}

