/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base.dir;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.dir.DirEntry;
import net.sf.jftp.gui.base.dir.MaterializedTableModel;

public class TableUtils {
    public static void calcColumnWidths(JTable table) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int margin = columns.getColumnMargin();
        int rowCount = data.getRowCount();
        int totalWidth = 0;
        for (int i = columns.getColumnCount() - 1; i >= 0; --i) {
            TableColumn column = columns.getColumn(i);
            int columnIndex = column.getModelIndex();
            int width = -1;
            TableCellRenderer h = column.getHeaderRenderer();
            if (h == null) {
                h = defaultHeaderRenderer;
            }
            if (h != null) {
                Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, i);
                width = c.getPreferredSize().width;
            }
            for (int row = rowCount - 1; row >= 0; --row) {
                TableCellRenderer r = table.getCellRenderer(row, i);
                Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, i);
                width = Math.max(width, c.getPreferredSize().width);
            }
            if (width >= 0) {
                column.setPreferredWidth(width + margin);
            }
            totalWidth += column.getPreferredWidth();
        }
    }

    public static void setFixedWidths(JTable table) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int rowCount = data.getRowCount();
        for (int i = 0; i < columns.getColumnCount(); ++i) {
            TableColumn column = columns.getColumn(i);
            int columnIndex = column.getModelIndex();
            int width = -1;
            if (i == 0) {
                column.setPreferredWidth(20);
                column.setMaxWidth(20);
                continue;
            }
            if (i == 1) {
                column.setMinWidth(100);
                column.setPreferredWidth(400);
                continue;
            }
            if (i == 2) {
                column.setMinWidth(60);
                column.setPreferredWidth(80);
                continue;
            }
            if (i != 3) continue;
            column.setMinWidth(25);
            column.setPreferredWidth(25);
        }
    }

    public static void copyTableSelectionsToJList(JList list, JTable listTbl) {
        list.setSelectedIndices(new int[0]);
        int rows = listTbl.getRowCount();
        Vector<Integer> sel = new Vector<Integer>();
        for (int i = 0; i < rows; ++i) {
            if (!listTbl.getSelectionModel().isSelectedIndex(i)) continue;
            sel.add(new Integer(listTbl.convertRowIndexToModel(i)));
        }
        int[] tmp = new int[sel.size()];
        for (int i = 0; i < sel.size(); ++i) {
            tmp[i] = (Integer)sel.get(i);
        }
        list.setSelectedIndices(tmp);
    }

    private static synchronized TableModel generateTableModel(JList l) {
        MaterializedTableModel dataModel = new MaterializedTableModel(l){

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return ImageIcon.class;
                }
                if (columnIndex == 3) {
                    return JLabel.class;
                }
                return String.class;
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public int getRowCount() {
                return this.list.getModel().getSize();
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (this.list.getModel().getSize() == 0) {
                    return "" + null;
                }
                DirEntry ret = (DirEntry)this.list.getModel().getElementAt(row);
                if (col == 0) {
                    return ret.getImageIcon();
                }
                if (col == 1) {
                    return ret.toString();
                }
                if (col == 2) {
                    String tmp = "" + ret.getFileSize();
                    String r = tmp.replaceAll(" >", "");
                    return r;
                }
                if (col == 3) {
                    return ret;
                }
                return ret;
            }
        };
        return dataModel;
    }

    public static void layoutTable(JList list, JTable listTbl) {
        TableUtils.layoutTable(list, listTbl, null);
    }

    public static void layoutTable(JList list, JTable listTbl, Vector names) {
        listTbl.setModel(TableUtils.generateTableModel(list));
        if (Settings.useFixedTableWidths) {
            TableUtils.setFixedWidths(listTbl);
        } else {
            TableUtils.calcColumnWidths(listTbl);
        }
        if (names != null) {
            TableUtils.modifyTableHeader(listTbl.getTableHeader(), names);
        }
        TableUtils.tryToEnableRowSorting(listTbl);
    }

    public static void tryToEnableRowSorting(JTable listTbl) {
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(listTbl.getModel());
        listTbl.setRowSorter(sorter);
    }

    public static void modifyTableHeader(JTableHeader head, Vector columnNames) {
        TableColumnModel m = head.getColumnModel();
        if (m.getColumnCount() != columnNames.size()) {
            System.out.println("Column mismatch: " + m.getColumnCount() + "/" + columnNames.size());
            return;
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            TableColumn c = m.getColumn(i);
            c.sizeWidthToFit();
            c.setHeaderValue(columnNames.get(i));
        }
    }

    public static JComponent makeTable(JTable table, JComponent cont) {
        JTableHeader header = table.getTableHeader();
        cont.setLayout(new BorderLayout());
        cont.add((Component)header, "North");
        cont.add((Component)table, "Center");
        return cont;
    }
}

