/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.tasks;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.system.logging.Log;

public class BookmarkManager
extends JInternalFrame
implements ActionListener {
    private JTextArea info = new JTextArea(25, 50);
    private JButton save = new JButton("Save and close");
    private JButton close = new JButton("Close");

    public BookmarkManager() {
        super("Manage Bookmarks", true, true, true, true);
        this.setLocation(50, 50);
        this.setSize(600, 540);
        this.getContentPane().setLayout(new BorderLayout());
        this.load(Settings.bookmarks);
        JScrollPane jsp = new JScrollPane(this.info);
        this.getContentPane().add("Center", jsp);
        HPanel closeP = new HPanel();
        closeP.setLayout(new FlowLayout(1));
        closeP.add(this.save);
        this.close.addActionListener(this);
        this.save.addActionListener(this);
        this.getContentPane().add("South", closeP);
        this.info.setCaretPosition(0);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close) {
            this.dispose();
        } else {
            this.save(Settings.bookmarks);
            JFtp.menuBar.loadBookmarks();
            this.dispose();
        }
    }

    private void setDefaultText() {
        this.info.setText("");
        this.info.append("# JFtp Bookmark Configuration file\n");
        this.info.append("#\n");
        this.info.append("# Syntax: protocol#host#user#password#port#dir/domain#local\n");
        this.info.append("#\n");
        this.info.append("# Note: not all values are used by every connection, but all fields must contain at least\n");
        this.info.append("# one character.\n");
        this.info.append("Use \"<%hidden%>\" for password fields you don't want to fill out.");
        this.info.append("#\n");
        this.info.append("# protocol: FTP, SFTP, SMB or NFS (uppercase)\n");
        this.info.append("# host: hostname or ip for ftp + sftp, valid url for smb + nfs  (\"(LAN)\" for smb lan browsing)\n");
        this.info.append("# user, password: the login data\n");
        this.info.append("# port: this must be a number (even if it is not used for smb+nfs, set it in the url for nfs)\n");
        this.info.append("# dir/domain: inital directory for the connection, domainname for smb\n");
        this.info.append("# local: \"true\" if connection should be opened in local tab, \"false\" otherwise\n");
        this.info.append("# directories must be included in <dir></dir> tags and can be ended using a single\n# <enddir> tag");
        this.info.append("#\n");
        this.info.append("#\n");
        this.info.append("\n<dir>JFtp</dir>\n");
        this.info.append("FTP#upload.sourceforge.net#anonymous#j-ftp@sf.net#21#/incoming#false\n");
        this.info.append("<enddir>\n");
        this.info.append("\n");
        this.info.append("FTP#ftp.kernel.org#anonymous#j-ftp@sf.net#21#/pub/linux/kernel/v2.6#false\n");
        this.info.append("\n");
        this.info.append("SMB#(LAN)#guest#guest#-1#-#false\n\n");
    }

    private void load(String file) {
        String data = "";
        String now = "";
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            while ((data = in.readLine()) != null) {
                now = now + data + "\n";
            }
        }
        catch (IOException e) {
            Log.debug("No bookmarks.txt found, using defaults.");
            this.setDefaultText();
            return;
        }
        this.info.setText(now);
    }

    private void save(String file) {
        try {
            PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
            out.println(this.info.getText());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Log.debug(e + " @BookmarkManager.save()");
        }
    }

    @Override
    public Insets getInsets() {
        Insets std = super.getInsets();
        return new Insets(std.top + 5, std.left + 5, std.bottom + 5, std.right + 5);
    }
}

