/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net.wrappers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import net.sf.jftp.config.Settings;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.logging.Log;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.webdav.lib.WebdavFile;
import org.apache.webdav.lib.WebdavResource;

public class WebdavConnection
implements BasicConnection {
    public static int webdavBuffer = 32000;
    private String path = "";
    private String pwd = "";
    private Vector listeners = new Vector();
    private String[] files;
    private String[] size = new String[0];
    private int[] perms = null;
    private String baseFile;
    private int fileCount;
    private boolean shortProgress = false;
    private String user;
    private String pass;

    public WebdavConnection(String path, String user, String pass, ConnectionListener l) {
        this.user = user;
        this.pass = pass;
        this.listeners.add(l);
        this.chdir(path);
    }

    @Override
    public int removeFileOrDir(String file) {
        Log.debug("Feature is not implemented yet");
        return -1;
    }

    private void cleanLocalDir(String dir) {
        try {
            WebdavFile f2;
            String[] tmp;
            dir = dir.replace('\\', '/');
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            if ((tmp = (f2 = new WebdavFile(this.getURL(dir))).list()) == null) {
                return;
            }
            for (int i = 0; i < tmp.length; ++i) {
                WebdavFile f3 = new WebdavFile(this.getURL(dir + tmp[i]));
                if (!f3.getAbsolutePath().equals(f3.getCanonicalPath())) {
                    f3.delete();
                }
                if (f3.isDirectory()) {
                    this.cleanLocalDir(dir + tmp[i]);
                    f3.delete();
                    continue;
                }
                f3.delete();
            }
        }
        catch (Exception ex) {
            Log.debug("Error: " + ex.toString());
            ex.printStackTrace();
        }
    }

    @Override
    public void sendRawCommand(String cmd) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public String getPWD() {
        return this.pwd;
    }

    @Override
    public boolean cdup() {
        return this.chdir(this.pwd.substring(0, this.pwd.lastIndexOf("/") + 1));
    }

    @Override
    public boolean mkdir(String dirName) {
        Log.debug("Feature is not implemented yet");
        return false;
    }

    @Override
    public void list() throws IOException {
    }

    @Override
    public boolean chdir(String p) {
        try {
            String p2 = this.processPath(p);
            if (p2 == null) {
                return false;
            }
            WebdavResource f = this.getResource(p2);
            if (!f.exists() || !f.isCollection()) {
                Log.debug("Access denied.");
                return false;
            }
            this.pwd = p2;
            Log.out("PWD: " + this.pwd);
            this.fireDirectoryUpdate();
            return true;
        }
        catch (Exception ex) {
            Log.debug("Error: " + ex.toString());
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean chdirNoRefresh(String p) {
        String p2 = this.processPath(p);
        if (p2 == null) {
            return false;
        }
        this.pwd = p2;
        return true;
    }

    @Override
    public String getLocalPath() {
        return this.path;
    }

    public String processPath(String p) {
        try {
            if (!p.startsWith("http://")) {
                p = this.pwd + p;
            }
            if (!p.endsWith("/")) {
                p = p + "/";
            }
            while (p.endsWith("/../")) {
                p = p.substring(0, p.lastIndexOf("/../") - 1);
                p = p.substring(0, p.lastIndexOf("/"));
            }
            while (p.endsWith("/./")) {
                p = p.substring(0, p.lastIndexOf("/./") - 1);
                p = p.substring(0, p.lastIndexOf("/"));
            }
            Log.out("\n\n\nprocessPath URL: " + p);
            WebdavResource f = this.getResource(p);
            String p2 = p;
            if (f.exists() && f.isCollection()) {
                try {
                    if (!p2.endsWith("/")) {
                        p2 = p2 + "/";
                    }
                    return p2;
                }
                catch (Exception ex) {
                    Log.debug("Error: can not get pathname (processPath)!");
                    return null;
                }
            }
            Log.debug("(processpPath) No such path: \"" + p + "\"");
            return null;
        }
        catch (Exception ex) {
            Log.debug("Error: " + ex.toString());
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setLocalPath(String p) {
        try {
            File f;
            p = p.replace('\\', '/');
            if (StringUtils.isRelative(p)) {
                p = this.path + p;
            }
            if ((f = new File(p = p.replace('\\', '/'))).exists()) {
                try {
                    this.path = f.getCanonicalPath();
                    this.path = this.path.replace('\\', '/');
                    if (this.path.endsWith("/")) return true;
                    this.path = this.path + "/";
                    return true;
                }
                catch (Exception ex) {
                    Log.debug("Error: can not get pathname (local)!");
                    return false;
                }
            } else {
                Log.debug("(local) No such path: \"" + p + "\"");
                return false;
            }
        }
        catch (Exception ex) {
            Log.debug("Error: " + ex.toString());
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public String[] sortLs() {
        try {
            Log.out("sortLs PWD: " + this.pwd);
            WebdavResource fp = this.getResource(this.pwd);
            WebdavResource[] f = fp.listWebdavResources();
            this.files = new String[f.length];
            this.size = new String[f.length];
            this.perms = new int[f.length];
            boolean accessible = false;
            for (int i = 0; i < f.length; ++i) {
                this.files[i] = f[i].getName();
                Log.out("sortLs files[" + i + "]: " + this.files[i]);
                this.size[i] = "" + (int)f[i].getGetContentLength();
                this.perms[i] = 23;
                if (!f[i].isCollection() || this.files[i].endsWith("/")) continue;
                this.files[i] = this.files[i] + "/";
            }
            return this.files;
        }
        catch (Exception ex) {
            Log.debug("Error: " + ex.toString());
            ex.printStackTrace();
            return new String[0];
        }
    }

    @Override
    public String[] sortSize() {
        return this.size;
    }

    @Override
    public int[] getPermissions() {
        return this.perms;
    }

    @Override
    public int handleDownload(String file) {
        this.transfer(file);
        return 0;
    }

    @Override
    public int handleUpload(String file) {
        this.transfer(file, true);
        return 0;
    }

    @Override
    public int download(String file) {
        this.transfer(file);
        return 0;
    }

    @Override
    public int upload(String file) {
        this.transfer(file, true);
        return 0;
    }

    private void transferDir(String dir, String out) {
        try {
            this.fileCount = 0;
            this.shortProgress = true;
            this.baseFile = StringUtils.getDir(dir);
            WebdavFile f2 = new WebdavFile(this.getURL(dir));
            String[] tmp = f2.list();
            if (tmp == null) {
                return;
            }
            WebdavFile fx = new WebdavFile(this.getURL(out));
            if (!fx.mkdir()) {
                Log.debug("Can not create directory: " + out + " - already exist or permission denied?");
            }
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = tmp[i].replace('\\', '/');
                WebdavFile f3 = new WebdavFile(this.getURL(dir + tmp[i]));
                if (f3.isDirectory()) {
                    if (!tmp[i].endsWith("/")) {
                        tmp[i] = tmp[i] + "/";
                    }
                    this.transferDir(dir + tmp[i], out + tmp[i]);
                    continue;
                }
                this.fireProgressUpdate(this.baseFile, "DGET:" + this.fileCount, -1);
                this.work(dir + tmp[i], out + tmp[i]);
            }
            this.fireProgressUpdate(this.baseFile, "DFINISHED:" + this.fileCount, -1);
            this.shortProgress = false;
        }
        catch (Exception ex) {
            Log.debug("Error: " + ex.toString());
            ex.printStackTrace();
        }
    }

    private HttpURL getURL(String u) {
        try {
            HttpURL url = new HttpURL(u);
            url.setUserinfo(this.user, this.pass);
            return url;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("ERROR: " + ex);
            return null;
        }
    }

    private WebdavResource getResource(String res) throws HttpException, IOException {
        return new WebdavResource(this.getURL(res));
    }

    private void transfer(String file) {
        this.transfer(file, false);
    }

    private void transfer(String file, boolean up) {
        String out = StringUtils.getDir(file);
        if (StringUtils.isRelative(file)) {
            file = this.getPWD() + file;
        }
        file = file.replace('\\', '/');
        out = out.replace('\\', '/');
        String outfile = StringUtils.getFile(file);
        if (file.endsWith("/")) {
            if (up) {
                Log.debug("Directory upload not implemented yet.");
                return;
            }
            this.transferDir(file, this.getLocalPath() + out);
            return;
        }
        if (up) {
            this.work(this.getLocalPath() + outfile, file);
        } else {
            this.work(file, this.getLocalPath() + outfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work(String file, String outfile) {
        Log.out("transfer started\nfile: " + file + "\noutfile: " + outfile);
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            if (outfile.startsWith("http://")) {
                String resPath = outfile.substring(0, outfile.lastIndexOf("/") + 1);
                String name = outfile.substring(outfile.lastIndexOf("/") + 1);
                Log.debug("Uploading " + file + " to " + resPath + " as " + name);
                WebdavResource res = this.getResource(resPath);
                if (res.putMethod(new File(file))) {
                    this.fireProgressUpdate(file, "FINISHED", -1);
                } else {
                    Log.debug("Upload failed.");
                    this.fireProgressUpdate(file, "FAILED", -1);
                }
                return;
            }
            Log.debug("Downloading " + file + " to " + outfile);
            out = new BufferedOutputStream(new FileOutputStream(outfile));
            in = new BufferedInputStream(this.getResource(file).getMethodData());
            byte[] buf = new byte[webdavBuffer];
            int len = 0;
            int reallen = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                this.fireProgressUpdate(StringUtils.getFile(file), "GET", reallen += len);
            }
            this.fireProgressUpdate(file, "FINISHED", -1);
        }
        catch (IOException ex) {
            Log.debug("Error with file IO (" + ex + ")!");
            ex.printStackTrace();
            this.fireProgressUpdate(file, "FAILED", -1);
        }
        finally {
            try {
                out.flush();
                out.close();
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public int upload(String file, InputStream in) {
        Log.debug("Upload using InputStream is not implemented yet!");
        return -1;
    }

    @Override
    public InputStream getDownloadInputStream(String file) {
        if (StringUtils.isRelative(file)) {
            file = this.getPWD() + file;
        }
        file = file.replace('\\', '/');
        try {
            return this.getResource(file).getMethodData();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug(ex.toString() + " @WebdavConnection::getDownloadInputStream");
            return null;
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener l) {
        this.listeners.add(l);
    }

    public void setConnectionListeners(Vector l) {
        this.listeners = l;
    }

    public void fireDirectoryUpdate() {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ConnectionListener)this.listeners.elementAt(i)).updateRemoteDirectory(this);
        }
    }

    public boolean login(String user, String pass) {
        return true;
    }

    public void fireProgressUpdate(String file, String type, int bytes) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionListener listener = (ConnectionListener)this.listeners.elementAt(i);
            if (this.shortProgress && Settings.shortProgress) {
                if (type.startsWith("DFINISHED")) {
                    listener.updateProgress(this.baseFile, "DFINISHED:" + this.fileCount, bytes);
                }
                listener.updateProgress(this.baseFile, "DGET:" + this.fileCount, bytes);
                continue;
            }
            listener.updateProgress(file, type, bytes);
        }
    }

    @Override
    public Date[] sortDates() {
        return null;
    }

    @Override
    public boolean rename(String from, String to) {
        Log.debug("Not implemented!");
        return false;
    }
}

