/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.nfs;

import com.sun.xfile.XFile;
import com.sun.xfile.XFileInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import sun.misc.Compare;
import sun.misc.Sort;
import sun.net.www.MessageHeader;
import sun.net.www.MimeEntry;
import sun.net.www.MimeTable;
import sun.net.www.URLConnection;
import sun.net.www.protocol.nfs.StringCompare;

public class NfsURLConnection
extends URLConnection {
    InputStream is = null;
    XFileInputStream nis = null;
    XFile nfsFile = null;
    boolean isConnected = false;

    NfsURLConnection(URL uRL) {
        super(uRL);
    }

    public void connect() throws IOException {
        String string = this.url.getHost();
        try {
            InetAddress.getByName(string);
        }
        catch (Exception exception) {
            throw new IOException("Unknown Host");
        }
        if (this.isConnected) {
            return;
        }
        try {
            this.nfsFile = new XFile(this.url.toString());
        }
        catch (Exception exception) {
            throw new IOException("Unable to open xfile");
        }
        this.isConnected = true;
    }

    public InputStream getInputStream() throws IOException {
        boolean bl = false;
        if (!this.isConnected) {
            this.connect();
        }
        if (!this.nfsFile.exists()) {
            throw new IOException("Cannot Access File " + this.nfsFile.getPath() + "!");
        }
        if (!this.nfsFile.canRead()) {
            throw new IOException("Read Access Not Allowed for " + this.nfsFile.getPath());
        }
        String string = this.url.getFile();
        if (string.equals("/")) {
            string = "/.";
            bl = true;
        } else if (string.charAt(0) == '/') {
            string = string.substring(1, string.length());
        }
        MessageHeader messageHeader = new MessageHeader();
        MimeTable mimeTable = MimeTable.getDefaultTable();
        if (this.nfsFile.isDirectory()) {
            Object[] objectArray;
            int n;
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = Integer.getInteger("hotjava.file.iconheight", 32);
            int n3 = Integer.getInteger("hotjava.file.iconwidth", 32);
            messageHeader.add("content-type", "text/html");
            this.setProperties(messageHeader);
            stringBuffer.append("<HTML>\n<HEAD>\n<TITLE>");
            stringBuffer.append(System.getProperty("file.dir.title", "Directory Listing"));
            stringBuffer.append("</TITLE>\n");
            stringBuffer.append("<BASE HREF=\"" + this.url.toString());
            if (this.url.toString().endsWith("/")) {
                stringBuffer.append("\">");
            } else {
                stringBuffer.append("/\">");
            }
            stringBuffer.append("</HEAD>\n<BODY>\n");
            if (bl) {
                stringBuffer.append("<H1>\n/</H1>\n<HR>\n");
            } else {
                stringBuffer.append("<H1>\n" + string + "</H1>\n<HR>\n");
            }
            if (!bl) {
                string2 = this.url.toString();
                n = string2.length() - 1;
                if (this.url.getFile() != null) {
                    if (string2.endsWith("/")) {
                        --n;
                    }
                    string2 = string2.substring(0, string2.lastIndexOf(47, n));
                    stringBuffer.append("<A HREF=\"" + string2 + "\">");
                    stringBuffer.append("<H2>Go To Parent Directory</H2></A>\n<BR>\n");
                }
            }
            if ((objectArray = this.nfsFile.list()) != null) {
                string2 = new StringCompare();
                Sort.quicksort((Object[])objectArray, (Compare)string2);
                n = Boolean.getBoolean("file.hidedotfiles") ? 1 : 0;
                int n4 = 0;
                while (n4 < objectArray.length) {
                    if (!(((String)objectArray[n4]).equals("..") || ((String)objectArray[n4]).equals(".") || n != 0 && ((String)objectArray[n4]).charAt(0) == '.')) {
                        stringBuffer.append("<IMG ALIGN=middle SRC=\"");
                        XFile xFile = new XFile(this.nfsFile, (String)objectArray[n4]);
                        if (xFile.isDirectory()) {
                            stringBuffer.append("doc:/lib/images/ftp/directory.gif\" WIDTH=" + n3 + " HEIGHT=" + n2 + ">\n");
                        } else if (xFile.isFile()) {
                            String string3;
                            String string4 = "doc:/lib/images/ftp/file.gif";
                            MimeEntry mimeEntry = mimeTable.findByFileName((String)objectArray[n4]);
                            if (mimeEntry != null && (string3 = mimeEntry.getImageFileName()) != null) {
                                string4 = string3;
                            }
                            stringBuffer.append(string4);
                            stringBuffer.append("\" WIDTH=" + n3 + " HEIGHT=" + n2 + ">\n");
                        } else {
                            stringBuffer.append("doc:/lib/images/ftp/file.gif\" WIDTH=" + n3 + " HEIGHT=" + n2 + ">\n");
                        }
                        stringBuffer.append("<A HREF=\"" + (String)objectArray[n4] + "\">");
                        stringBuffer.append(String.valueOf(objectArray[n4]) + "</A>\n<BR>");
                    }
                    ++n4;
                }
            }
            stringBuffer.append("</BODY>\n</HTML>\n");
            this.is = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        } else {
            MimeEntry mimeEntry = mimeTable.findByFileName(string);
            if (mimeEntry != null) {
                messageHeader.add("content-type", mimeEntry.getType());
            }
            this.setProperties(messageHeader);
            if (!this.nfsFile.exists()) {
                throw new IOException("Cannot Access File " + this.nfsFile.getPath() + "!");
            }
            this.is = new XFileInputStream(this.nfsFile);
            if (this.is == null) {
                throw new IOException("Unable to Open InputStream for " + this.url.getFile());
            }
        }
        return this.is;
    }
}

