/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.util.Buffer;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;

public class BandwidthTrackerImpl
implements Serializable {
    static final long serialVersionUID = 7694080781117787305L;
    static final int HISTORY_SIZE = 10;
    transient Buffer snapShots = new Buffer(10);
    private transient int numMeasures = 0;
    private transient float averageBandwidth = 0.0f;
    private transient float cachedBandwidth = 0.0f;
    long lastTime;
    int lastAmountRead;
    float measuredBandwidth;

    public synchronized void measureBandwidth(int amountRead) {
        long currentTime = System.currentTimeMillis();
        if (this.lastAmountRead == 0 || currentTime == this.lastTime) {
            this.measuredBandwidth = 0.0f;
        } else {
            this.measuredBandwidth = (float)(amountRead - this.lastAmountRead) / (float)(currentTime - this.lastTime);
            this.measuredBandwidth = Math.max(this.measuredBandwidth, 0.0f);
        }
        this.lastTime = currentTime;
        this.lastAmountRead = amountRead;
        this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + this.measuredBandwidth) / (float)(++this.numMeasures);
        this.snapShots.add(new Float(this.measuredBandwidth));
        this.cachedBandwidth = 0.0f;
    }

    public synchronized float getMeasuredBandwidth() throws InsufficientDataException {
        if (this.cachedBandwidth != 0.0f) {
            return this.cachedBandwidth;
        }
        int size = this.snapShots.getSize();
        if (size < 3) {
            throw new InsufficientDataException();
        }
        Iterator iter = this.snapShots.iterator();
        float total = 0.0f;
        while (iter.hasNext()) {
            total += ((Float)iter.next()).floatValue();
        }
        this.cachedBandwidth = total / (float)size;
        return this.cachedBandwidth;
    }

    public synchronized float getAverageBandwidth() {
        if (this.snapShots.getSize() < 3) {
            return 0.0f;
        }
        return this.averageBandwidth;
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.snapShots = new Buffer(10);
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        try {
            in.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Class not found");
        }
        catch (NotActiveException e) {
            throw new IOException("Not active");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

