/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CreationTimeCache {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$CreationTimeCache == null ? (class$com$limegroup$gnutella$CreationTimeCache = CreationTimeCache.class$("com.limegroup.gnutella.CreationTimeCache")) : class$com$limegroup$gnutella$CreationTimeCache);
    private static final File CTIME_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "createtimes.cache");
    private static CreationTimeCache instance = new CreationTimeCache();
    private final Map URN_TO_TIME_MAP = this.createMap();
    private final SortedMap TIME_TO_URNSET_MAP = new TreeMap(Comparators.inverseLongComparator());
    static /* synthetic */ Class class$com$limegroup$gnutella$CreationTimeCache;

    public static synchronized CreationTimeCache instance() {
        return instance;
    }

    private CreationTimeCache() {
        this.pruneTimes(false);
        this.constructURNMap();
    }

    public synchronized Long getCreationTime(URN urn) {
        return (Long)this.URN_TO_TIME_MAP.get(urn);
    }

    public long getCreationTimeAsLong(URN urn) {
        Long l = this.getCreationTime(urn);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public synchronized void removeTime(URN urn) {
        this.removeURNFromURNSet(urn, (Long)this.URN_TO_TIME_MAP.remove(urn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneTimes(boolean shouldClearURNSetMap) {
        FileManager fileManager = RouterService.getFileManager();
        synchronized (fileManager) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                Iterator iter = this.URN_TO_TIME_MAP.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry currEntry = iter.next();
                    if (!(currEntry.getKey() instanceof URN) || !(currEntry.getValue() instanceof Long)) {
                        iter.remove();
                        continue;
                    }
                    URN currURN = (URN)currEntry.getKey();
                    Long cTime = (Long)currEntry.getValue();
                    FileDesc fd = RouterService.getFileManager().getFileDescForUrn(currURN);
                    if (fd != null && fd.getFile() != null && fd.getFile().exists()) continue;
                    iter.remove();
                    if (!shouldClearURNSetMap) continue;
                    this.removeURNFromURNSet(currURN, cTime);
                }
            }
        }
    }

    public synchronized void pruneTimes() {
        this.pruneTimes(true);
    }

    public synchronized void addTime(URN urn, long time) throws IllegalArgumentException {
        if (urn == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        if (time <= 0L) {
            throw new IllegalArgumentException("Bad Time = " + time);
        }
        Long cTime = new Long(time);
        this.URN_TO_TIME_MAP.put(urn, cTime);
    }

    public synchronized void commitTime(URN urn) throws IllegalArgumentException {
        if (urn == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        Long cTime = (Long)this.URN_TO_TIME_MAP.get(urn);
        if (cTime == null) {
            throw new IllegalArgumentException("Never added URN via addTime()");
        }
        HashSet<URN> urnSet = (HashSet<URN>)this.TIME_TO_URNSET_MAP.get(cTime);
        if (urnSet == null) {
            urnSet = new HashSet<URN>();
            this.TIME_TO_URNSET_MAP.put(cTime, urnSet);
        }
        urnSet.add(urn);
    }

    public synchronized List getFiles(int max) throws IllegalArgumentException {
        return this.getFiles(null, max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFiles(QueryRequest request, int max) throws IllegalArgumentException {
        FileManager fileManager = RouterService.getFileManager();
        synchronized (fileManager) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                if (max < 1) {
                    throw new IllegalArgumentException("bad max = " + max);
                }
                ArrayList<URN> urnList = new ArrayList<URN>();
                Iterator iter = this.TIME_TO_URNSET_MAP.entrySet().iterator();
                MediaType.Aggregator filter = request == null ? null : MediaType.getAggregator(request);
                ArrayList<URN> toRemove = null;
                while (iter.hasNext() && urnList.size() < max) {
                    Map.Entry currEntry = iter.next();
                    Set urns = (Set)currEntry.getValue();
                    Iterator innerIter = urns.iterator();
                    while (urnList.size() < max && innerIter.hasNext()) {
                        URN currURN = (URN)innerIter.next();
                        FileDesc fd = RouterService.getFileManager().getFileDescForUrn(currURN);
                        if (fd == null || fd instanceof IncompleteFileDesc) {
                            if (toRemove == null) {
                                toRemove = new ArrayList<URN>();
                            }
                            toRemove.add(currURN);
                            continue;
                        }
                        if (filter == null) {
                            urnList.add(currURN);
                            continue;
                        }
                        if (!filter.allow(fd.getName())) continue;
                        urnList.add(currURN);
                    }
                }
                if (toRemove != null) {
                    Iterator removees = toRemove.iterator();
                    while (removees.hasNext()) {
                        URN currURN = (URN)removees.next();
                        this.removeTime(currURN);
                    }
                }
                return urnList;
            }
        }
    }

    public synchronized List getFiles() {
        return this.getFiles(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void persistCache() {
        block11: {
            ObjectOutputStream oos = null;
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(CTIME_CACHE_FILE)));
            oos.writeObject(this.URN_TO_TIME_MAP);
            Object var4_2 = null;
            try {
                if (oos != null) {
                    oos.close();
                }
                break block11;
            }
            catch (IOException ignored) {}
            break block11;
            {
                catch (IOException e) {
                    ErrorService.error(e);
                    Object var4_3 = null;
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        break block11;
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private synchronized void removeURNFromURNSet(URN urn, Long refTime) {
        block2: {
            block1: {
                if (refTime == null) break block1;
                Set urnSet = (Set)this.TIME_TO_URNSET_MAP.get(refTime);
                if (urnSet == null || !urnSet.remove(urn) || urnSet.size() >= 1) break block2;
                this.TIME_TO_URNSET_MAP.remove(refTime);
                break block2;
            }
            Iterator iter = this.TIME_TO_URNSET_MAP.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry currEntry = iter.next();
                Set urnSet = (Set)currEntry.getValue();
                if (!urnSet.contains(urn)) continue;
                urnSet.remove(urn);
                if (urnSet.size() >= 1) break;
                iter.remove();
                break;
            }
        }
    }

    private void constructURNMap() {
        Set entries = this.URN_TO_TIME_MAP.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry currEntry = iter.next();
            Long cTime = (Long)currEntry.getValue();
            URN urn = (URN)currEntry.getKey();
            if (RouterService.getFileManager().getFileDescForUrn(urn) instanceof IncompleteFileDesc) continue;
            HashSet<URN> urnSet = (HashSet<URN>)this.TIME_TO_URNSET_MAP.get(cTime);
            if (urnSet == null) {
                urnSet = new HashSet<URN>();
                this.TIME_TO_URNSET_MAP.put(cTime, urnSet);
            }
            urnSet.add(urn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map createMap() {
        Map map;
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(CTIME_CACHE_FILE)));
                map = (Map)ois.readObject();
                Object var5_4 = null;
                if (ois == null) return map;
            }
            catch (Throwable t) {
                LOG.error("Unable to read creation time file", t);
                HashMap hashMap = new HashMap();
                Object var5_5 = null;
                if (ois == null) return hashMap;
                try {
                    ois.close();
                    return hashMap;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (ois == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            ois.close();
            throw throwable;
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return map;
        }
        ois.close();
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

