/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.PushProxyInterface;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RequeryDownloader;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.udpconnect.UDPConnection;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadManager
implements BandwidthTracker {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$DownloadManager == null ? (class$com$limegroup$gnutella$DownloadManager = DownloadManager.class$("com.limegroup.gnutella.DownloadManager")) : class$com$limegroup$gnutella$DownloadManager);
    private int SNAPSHOT_CHECKPOINT_TIME = 30000;
    private ActivityCallback callback;
    private MessageRouter router;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager = new IncompleteFileManager();
    private List active = new LinkedList();
    private List waiting = new LinkedList();
    private final Map UDP_FAILOVER = new TreeMap(new GUID.GUIDByteComparator());
    private final ProcessingQueue FAILOVERS = new ProcessingQueue("udp failovers");
    private static long UDP_PUSH_FAILTIME = 5000L;
    public static long TIME_BETWEEN_REQUERIES = 2700000L;
    private long lastRequeryTime = 0L;
    private List querySentMDs = new ArrayList();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private Runnable _waitingPump;
    static /* synthetic */ Class class$com$limegroup$gnutella$DownloadManager;

    public void initialize() {
        this.initialize(RouterService.getCallback(), RouterService.getMessageRouter(), RouterService.getFileManager());
    }

    protected void initialize(ActivityCallback callback, MessageRouter router, FileManager fileManager) {
        this.callback = callback;
        this.router = router;
        this.fileManager = fileManager;
        this.scheduleWaitingPump();
    }

    public void postGuiInit() {
        File real = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File backup = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        if (!this.readSnapshot(real)) {
            LOG.debug("Reading real downloads.dat failed");
            if (this.readSnapshot(backup)) {
                LOG.debug("Reading backup downloads.bak succeeded.");
                this.copyBackupToReal();
            } else if (backup.exists() || real.exists()) {
                LOG.debug("Reading both downloads files failed.");
                MessageService.showError("DOWNLOAD_COULD_NOT_READ_SNAPSHOT");
            }
        } else {
            LOG.debug("Reading downloads.dat worked!");
        }
        Runnable checkpointer = new Runnable(){

            public void run() {
                if (DownloadManager.this.downloadsInProgress() > 0 && !DownloadManager.this.writeSnapshot()) {
                    DownloadManager.this.copyBackupToReal();
                }
            }
        };
        RouterService.schedule(checkpointer, this.SNAPSHOT_CHECKPOINT_TIME, this.SNAPSHOT_CHECKPOINT_TIME);
    }

    public void scheduleWaitingPump() {
        if (this._waitingPump != null) {
            return;
        }
        this._waitingPump = new Runnable(){

            public void run() {
                DownloadManager.this.pumpDownloads();
            }
        };
        RouterService.schedule(this._waitingPump, 1000L, 1000L);
    }

    private synchronized void pumpDownloads() {
        int index = 1;
        Iterator i = this.waiting.iterator();
        while (i.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)i.next();
            if (md.isAlive()) continue;
            if (md.isCancelled()) {
                i.remove();
                this.cleanupCompletedDownload(md, false);
                continue;
            }
            if (this.hasFreeSlot() && (md.hasNewSources() || md.getRemainingStateTime() <= 0)) {
                i.remove();
                this.active.add(md);
                md.startDownload();
                continue;
            }
            if (!md.isPaused()) {
                md.setInactivePriority(index++);
            }
            md.handleInactivity();
        }
    }

    private synchronized void copyBackupToReal() {
        File real = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File backup = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        real.delete();
        CommonUtils.copy(backup, real);
    }

    public boolean isIncomplete(URN urn) {
        return this.incompleteFileManager.getFileForUrn(urn) != null;
    }

    public IncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    public synchronized int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    public synchronized int getNumIndividualDownloaders() {
        int ret = 0;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)iter.next();
            ret += md.getNumDownloaders();
        }
        return ret;
    }

    public synchronized int getNumActiveDownloads() {
        return this.active.size();
    }

    public synchronized int getNumWaitingDownloads() {
        return this.waiting.size();
    }

    public synchronized boolean isGuidForQueryDownloading(GUID guid) {
        GUID dGUID;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            dGUID = ((ManagedDownloader)iter.next()).getQueryGUID();
            if (dGUID == null || !dGUID.equals(guid)) continue;
            return true;
        }
        iter = this.waiting.iterator();
        while (iter.hasNext()) {
            dGUID = ((ManagedDownloader)iter.next()).getQueryGUID();
            if (dGUID == null || !dGUID.equals(guid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllDownloads() {
        ArrayList buf;
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            buf = new ArrayList(this.active.size() + this.waiting.size());
            buf.addAll(this.active);
            buf.addAll(this.waiting);
            this.active.clear();
            this.waiting.clear();
        }
        Iterator i = buf.iterator();
        while (i.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)i.next();
            md.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized boolean writeSnapshot() {
        boolean bl;
        ArrayList buf = new ArrayList(this.active.size() + this.waiting.size());
        buf.addAll(this.active);
        buf.addAll(this.waiting);
        File outFile = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue().delete();
        outFile.renameTo(SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue());
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue())));
                out.writeObject(buf);
                IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
                synchronized (incompleteFileManager) {
                    out.writeObject(this.incompleteFileManager);
                }
                out.flush();
                bl = true;
                Object var7_7 = null;
                if (out == null) return bl;
            }
            catch (IOException e) {
                boolean bl2 = false;
                Object var7_8 = null;
                if (out == null) return bl2;
                try {
                    out.close();
                    return bl2;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (out == null) throw throwable;
            try {}
            catch (IOException ignored) {
                throw throwable;
            }
            out.close();
            throw throwable;
        }
        try {}
        catch (IOException ignored) {
            // empty catch block
            return bl;
        }
        out.close();
        return bl;
    }

    public synchronized boolean readSnapshot(File file) {
        LinkedList buf = null;
        try {
            ConverterObjectInputStream in = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            buf = (LinkedList)in.readObject();
            this.incompleteFileManager = (IncompleteFileManager)in.readObject();
        }
        catch (Throwable t) {
            LOG.error("Unable to read download file", t);
            return false;
        }
        if (this.incompleteFileManager.purge(true)) {
            this.writeSnapshot();
        }
        buf = new LinkedList(new HashSet(buf));
        try {
            Iterator iter = buf.iterator();
            while (iter.hasNext()) {
                ManagedDownloader downloader = (ManagedDownloader)iter.next();
                if (downloader instanceof RequeryDownloader) continue;
                this.waiting.add(downloader);
                downloader.initialize(this, this.fileManager, this.callback);
                this.callback.addDownload(downloader);
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public synchronized Downloader download(RemoteFileDesc[] files, List alts, boolean overwrite, GUID queryGUID) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        String filename;
        File downloadDir;
        File completeFile;
        String conflict = this.conflicts(files, null);
        if (conflict != null) {
            throw new AlreadyDownloadingException(conflict);
        }
        if (!overwrite && (completeFile = new File(downloadDir = SharingSettings.getSaveDirectory(), filename = files[0].getFileName())).exists()) {
            throw new FileExistsException(filename);
        }
        this.incompleteFileManager.purge(false);
        ManagedDownloader downloader = new ManagedDownloader(files, this.incompleteFileManager, queryGUID);
        this.initializeDownload(downloader);
        Iterator iter = alts.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            downloader.addDownload(rfd, false);
        }
        return downloader;
    }

    public synchronized Downloader download(URN urn, String textQuery, String filename, String[] defaultURL, boolean overwrite) throws IllegalArgumentException, AlreadyDownloadingException, FileExistsException {
        File downloadDir;
        File completeFile;
        if (textQuery == null && urn == null && filename == null && (defaultURL == null || defaultURL.length == 0)) {
            throw new IllegalArgumentException("Need something for requeries");
        }
        if (!overwrite && filename != null && !filename.equals("") && (completeFile = new File(downloadDir = SharingSettings.getSaveDirectory(), filename)).exists()) {
            throw new FileExistsException(filename);
        }
        this.incompleteFileManager.purge(false);
        if (urn != null && this.conflicts(urn)) {
            String ex = filename != null && !filename.equals("") ? filename : urn.toString();
            throw new AlreadyDownloadingException(ex);
        }
        MagnetDownloader downloader = new MagnetDownloader(this.incompleteFileManager, urn, textQuery, filename, defaultURL);
        this.initializeDownload(downloader);
        return downloader;
    }

    public synchronized Downloader download(File incompleteFile) throws AlreadyDownloadingException, CantResumeException {
        ManagedDownloader md;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            md = (ManagedDownloader)iter.next();
            if (!md.conflicts(incompleteFile)) continue;
            throw new AlreadyDownloadingException(md.getFileName());
        }
        iter = this.waiting.iterator();
        while (iter.hasNext()) {
            md = (ManagedDownloader)iter.next();
            if (!md.conflicts(incompleteFile)) continue;
            throw new AlreadyDownloadingException(md.getFileName());
        }
        this.incompleteFileManager.purge(false);
        ResumeDownloader downloader = null;
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
            String name = IncompleteFileManager.getCompletedName(incompleteFile);
            int size = ByteOrder.long2int(IncompleteFileManager.getCompletedSize(incompleteFile));
            downloader = new ResumeDownloader(this.incompleteFileManager, incompleteFile, name, size);
        }
        catch (IllegalArgumentException e) {
            throw new CantResumeException(incompleteFile.getName());
        }
        catch (IOException ioe) {
            throw new CantResumeException(incompleteFile.getName());
        }
        this.initializeDownload(downloader);
        return downloader;
    }

    private synchronized void initializeDownload(ManagedDownloader md) {
        md.initialize(this, this.fileManager, this.callback);
        this.waiting.add(md);
        this.callback.addDownload(md);
        this.writeSnapshot();
    }

    public synchronized String conflicts(RemoteFileDesc[] files, ManagedDownloader dloader) {
        for (int i = 0; i < files.length; ++i) {
            ManagedDownloader md;
            Iterator iter = this.active.iterator();
            while (iter.hasNext()) {
                md = (ManagedDownloader)iter.next();
                if (dloader != null && md == dloader || !md.conflicts(files[i])) continue;
                return files[i].getFileName();
            }
            iter = this.waiting.iterator();
            while (iter.hasNext()) {
                md = (ManagedDownloader)iter.next();
                if (dloader != null && md == dloader || !md.conflicts(files[i])) continue;
                return files[i].getFileName();
            }
        }
        return null;
    }

    private synchronized boolean conflicts(URN urn) {
        ManagedDownloader md;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            md = (ManagedDownloader)iter.next();
            if (!md.conflicts(urn)) continue;
            return true;
        }
        iter = this.waiting.iterator();
        while (iter.hasNext()) {
            md = (ManagedDownloader)iter.next();
            if (!md.conflicts(urn)) continue;
            return true;
        }
        return false;
    }

    public void handleQueryReply(QueryReply qr) {
        HostData data;
        List responses;
        if (qr.calculateQualityOfService(!RouterService.acceptedIncomingConnection()) < 1) {
            return;
        }
        try {
            responses = qr.getResultsAsList();
            data = qr.getHostData();
        }
        catch (BadPacketException bpe) {
            return;
        }
        this.addDownloadWithResponses(responses, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownloadWithResponses(List responses, HostData data) {
        if (responses == null) {
            throw new NullPointerException("null responses");
        }
        if (data == null) {
            throw new NullPointerException("null hostdata");
        }
        ArrayList downloaders = new ArrayList(this.active.size() + this.waiting.size());
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            downloaders.addAll(this.active);
            downloaders.addAll(this.waiting);
        }
        if (downloaders.isEmpty()) {
            return;
        }
        Iterator i = responses.iterator();
        block3: while (i.hasNext()) {
            Response r = (Response)i.next();
            RemoteFileDesc rfd = r.toRemoteFileDesc(data);
            Iterator j = downloaders.iterator();
            while (j.hasNext()) {
                ManagedDownloader currD = (ManagedDownloader)j.next();
                if (!currD.addDownload(rfd, true)) continue;
                Set alts = r.getLocations();
                Iterator k = alts.iterator();
                while (k.hasNext()) {
                    Endpoint ep = (Endpoint)k.next();
                    currD.addDownload(new RemoteFileDesc(rfd, ep), false);
                }
                continue block3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDownload(Socket socket) {
        Thread.currentThread().setName("PushDownloadThread");
        try {
            GIVLine line = DownloadManager.parseGIV(socket);
            String file = line.file;
            int index = line.index;
            byte[] clientGUID = line.clientGUID;
            Object object = this.UDP_FAILOVER;
            synchronized (object) {
                byte[] key = clientGUID;
                Set files = (Set)this.UDP_FAILOVER.get(key);
                if (files != null) {
                    files.remove(file);
                    if (files.isEmpty()) {
                        this.UDP_FAILOVER.remove(key);
                    }
                }
            }
            object = this;
            synchronized (object) {
                ManagedDownloader md;
                if (BrowseHostHandler.handlePush(index, new GUID(clientGUID), socket)) {
                    return;
                }
                Iterator iter = this.active.iterator();
                while (iter.hasNext()) {
                    md = (ManagedDownloader)iter.next();
                    if (!md.acceptDownload(file, socket, index, clientGUID)) continue;
                    return;
                }
                iter = this.waiting.iterator();
                while (iter.hasNext()) {
                    md = (ManagedDownloader)iter.next();
                    if (!md.acceptDownload(file, socket, index, clientGUID)) continue;
                    return;
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean hasFreeSlot() {
        return this.active.size() < DownloadSettings.MAX_SIM_DOWNLOAD.getValue();
    }

    public synchronized void remove(ManagedDownloader downloader, boolean completed) {
        this.active.remove(downloader);
        this.waiting.remove(downloader);
        if (completed) {
            this.cleanupCompletedDownload(downloader, true);
        } else {
            this.waiting.add(downloader);
        }
    }

    public synchronized void bumpPriority(Downloader downloader, boolean up) {
        int idx = this.waiting.indexOf(downloader);
        if (idx == -1) {
            return;
        }
        if (up && idx != 0) {
            this.waiting.remove(idx);
            this.waiting.add(idx - 1, downloader);
        } else if (!up && idx != this.waiting.size() - 1) {
            this.waiting.remove(idx);
            this.waiting.add(idx + 1, downloader);
        }
    }

    private void cleanupCompletedDownload(ManagedDownloader dl, boolean ser) {
        this.querySentMDs.remove(dl);
        dl.finish();
        if (dl.getQueryGUID() != null) {
            this.router.downloadFinished(dl.getQueryGUID());
        }
        this.callback.removeDownload(dl);
        if (ser) {
            this.writeSnapshot();
        }
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback.downloadsComplete();
        }
    }

    public synchronized boolean sendQuery(ManagedDownloader requerier, QueryRequest query) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("DM.sendQuery():" + query.getQuery());
        }
        Assert.that(this.waiting.contains(requerier), "Unknown or non-waiting MD trying to send requery.");
        boolean isRequery = GUID.isLimeRequeryGUID(query.getGUID());
        long elapsed = System.currentTimeMillis() - this.lastRequeryTime;
        if (isRequery && elapsed <= TIME_BETWEEN_REQUERIES) {
            return false;
        }
        if (this.querySentMDs.size() >= this.waiting.size()) {
            LOG.trace("DM.sendQuery(): reseting query sent queue");
            this.querySentMDs.clear();
        }
        if (this.querySentMDs.contains(requerier)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("DM.sendQuery(): out of turn:" + query.getQuery());
            }
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("DM.sendQuery(): requery allowed:" + query.getQuery());
        }
        this.querySentMDs.add(requerier);
        this.lastRequeryTime = System.currentTimeMillis();
        this.router.sendDynamicQuery(query);
        return true;
    }

    private boolean sendPushMulticast(RemoteFileDesc file, byte[] guid) {
        if (file.isReplyToMulticast()) {
            byte[] addr = RouterService.getNonForcedAddress();
            int port = RouterService.getNonForcedPort();
            if (NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port)) {
                PushRequest pr = new PushRequest(guid, 1, file.getClientGUID(), file.getIndex(), addr, port, 3);
                this.router.sendMulticastPushRequest(pr);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Sending push request through multicast " + pr);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendPushUDP(RemoteFileDesc file, byte[] guid) {
        PushRequest pr = new PushRequest(guid, 2, file.getClientGUID(), file.getIndex(), RouterService.getAddress(), RouterService.getPort(), 2);
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending push request through udp " + pr);
        }
        UDPService udpService = UDPService.instance();
        try {
            block9: {
                try {
                    InetAddress address = InetAddress.getByName(file.getHost());
                    if (!NetworkUtils.isValidAddress(address) || !NetworkUtils.isValidPort(file.getPort())) break block9;
                    udpService.send(pr, address, file.getPort());
                }
                catch (UnknownHostException notCritical) {
                    Object var7_8 = null;
                    IPFilter filter = IPFilter.instance();
                    Set proxies = file.getPushProxies();
                    Iterator iter = proxies.iterator();
                    while (iter.hasNext()) {
                        PushProxyInterface ppi = (PushProxyInterface)iter.next();
                        if (!filter.allow(ppi.getPushProxyAddress().getAddress())) continue;
                        udpService.send(pr, ppi.getPushProxyAddress(), ppi.getPushProxyPort());
                    }
                    return true;
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            IPFilter filter = IPFilter.instance();
            Set proxies = file.getPushProxies();
            Iterator iter = proxies.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    throw throwable;
                }
                PushProxyInterface ppi = (PushProxyInterface)iter.next();
                if (!filter.allow(ppi.getPushProxyAddress().getAddress())) continue;
                udpService.send(pr, ppi.getPushProxyAddress(), ppi.getPushProxyPort());
            }
        }
        IPFilter filter = IPFilter.instance();
        Set proxies = file.getPushProxies();
        Iterator iter = proxies.iterator();
        while (iter.hasNext()) {
            PushProxyInterface ppi = (PushProxyInterface)iter.next();
            if (!filter.allow(ppi.getPushProxyAddress().getAddress())) continue;
            udpService.send(pr, ppi.getPushProxyAddress(), ppi.getPushProxyPort());
        }
        return true;
    }

    private boolean sendPushTCP(RemoteFileDesc file, byte[] guid) {
        int port;
        boolean shouldDoFWTransfer;
        boolean bl = shouldDoFWTransfer = file.supportsFWTransfer() && UDPService.instance().canDoFWT() && !RouterService.acceptedIncomingConnection();
        if (this.sendPushThroughProxies(file, guid, shouldDoFWTransfer)) {
            return true;
        }
        if (shouldDoFWTransfer && !RouterService.acceptedIncomingConnection()) {
            return false;
        }
        byte[] addr = RouterService.getAddress();
        if (!NetworkUtils.isValidAddressAndPort(addr, port = RouterService.getPort())) {
            return false;
        }
        PushRequest pr = new PushRequest(guid, ConnectionSettings.TTL.getValue(), file.getClientGUID(), file.getIndex(), addr, port);
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending push request through Gnutella: " + pr);
        }
        try {
            this.router.sendPushRequest(pr);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPushThroughProxies(RemoteFileDesc file, byte[] guid, boolean shouldDoFWTransfer) {
        Set proxies = file.getPushProxies();
        if (proxies.isEmpty()) {
            return false;
        }
        byte[] externalAddr = RouterService.getExternalAddress();
        if (shouldDoFWTransfer && !NetworkUtils.isValidAddress(externalAddr)) {
            return false;
        }
        byte[] addr = RouterService.getAddress();
        int port = RouterService.getPort();
        String request = "/gnutella/push-proxy?ServerID=" + Base32.encode(file.getClientGUID()) + (shouldDoFWTransfer ? "&file=2147483645" : "");
        String nodeString = "X-Node";
        String nodeValue = NetworkUtils.ip2string(shouldDoFWTransfer ? externalAddr : addr) + ":" + port;
        IPFilter filter = IPFilter.instance();
        Iterator iter = proxies.iterator();
        while (iter.hasNext()) {
            PushProxyInterface ppi = (PushProxyInterface)iter.next();
            if (!filter.allow(ppi.getPushProxyAddress().getAddress())) continue;
            String ppIp = ppi.getPushProxyAddress().getHostAddress();
            int ppPort = ppi.getPushProxyPort();
            String connectTo = "http://" + ppIp + ":" + ppPort + request;
            HeadMethod head = new HeadMethod(connectTo);
            head.addRequestHeader("X-Node", nodeValue);
            head.addRequestHeader("Cache-Control", "no-cache");
            HttpClient client = HttpClientManager.getNewClient();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Push Proxy Requesting with: " + connectTo);
            }
            try {
                client.executeMethod(head);
                if (head.getStatusCode() == 202) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Succesful push proxy: " + connectTo);
                    }
                    if (shouldDoFWTransfer) {
                        this.startFWIncomingThread(file);
                    }
                    boolean bl = true;
                    return bl;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Invalid push proxy: " + connectTo + ", response: " + head.getStatusCode());
            }
            catch (IOException ioe) {
                LOG.warn("PushProxy request exception", ioe);
            }
            finally {
                if (head == null) continue;
                head.releaseConnection();
            }
        }
        return false;
    }

    private void startFWIncomingThread(final RemoteFileDesc file) {
        ManagedThread startPushThread = new ManagedThread("FWIncoming"){

            public void managedRun() {
                UDPConnection fwTrans = null;
                try {
                    fwTrans = new UDPConnection(file.getHost(), file.getPort());
                    DownloadStat.FW_FW_SUCCESS.incrementStat();
                    InputStream is = ((Socket)fwTrans).getInputStream();
                    String word = IOUtils.readWord(is, 4);
                    if (word.equals("GIV")) {
                        DownloadManager.this.acceptDownload(fwTrans);
                    } else {
                        ((Socket)fwTrans).close();
                    }
                }
                catch (IOException crap) {
                    LOG.debug("failed to establish UDP connection", crap);
                    if (fwTrans != null) {
                        try {
                            ((Socket)fwTrans).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    DownloadStat.FW_FW_FAILURE.incrementStat();
                }
            }
        };
        startPushThread.setDaemon(true);
        startPushThread.start();
    }

    public void sendPush(RemoteFileDesc file) {
        this.sendPush(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPush(final RemoteFileDesc file, final Object toNotify) {
        byte[] addr = RouterService.getAddress();
        int port = RouterService.getPort();
        if (!NetworkUtils.isValidAddress(addr) || !NetworkUtils.isValidPort(port)) {
            this.notify(toNotify);
            return;
        }
        final byte[] guid = GUID.makeGuid();
        if (this.sendPushMulticast(file, guid)) {
            return;
        }
        if (!RouterService.acceptedIncomingConnection()) {
            if (!UDPService.instance().canDoFWT() || !this.sendPushTCP(file, guid)) {
                this.notify(toNotify);
            }
            return;
        }
        if (!file.isFromAlternateLocation()) {
            Map map = this.UDP_FAILOVER;
            synchronized (map) {
                byte[] key = file.getClientGUID();
                HashSet<String> files = (HashSet<String>)this.UDP_FAILOVER.get(key);
                if (files == null) {
                    files = new HashSet<String>();
                }
                files.add(file.getFileName());
                this.UDP_FAILOVER.put(key, files);
            }
            RouterService.schedule(new Runnable(){

                public void run() {
                    DownloadManager.this.FAILOVERS.add(new PushFailoverRequestor(file, guid, toNotify));
                }
            }, UDP_PUSH_FAILTIME, 0L);
        }
        this.sendPushUDP(file, guid);
    }

    private static GIVLine parseGIV(Socket s) throws IOException {
        InputStream istream = null;
        try {
            istream = s.getInputStream();
        }
        catch (Exception e) {
            throw new IOException();
        }
        ByteReader br = new ByteReader(istream);
        String command = br.readLine();
        if (command == null) {
            throw new IOException();
        }
        String next = br.readLine();
        if (next == null || !next.equals("")) {
            throw new IOException();
        }
        try {
            int i = command.indexOf(":");
            int index = Integer.parseInt(command.substring(0, i));
            int j = command.indexOf("/", i);
            byte[] guid = GUID.fromHexString(command.substring(i + 1, j));
            String filename = URLDecoder.decode(command.substring(j + 1));
            return new GIVLine(filename, index, guid);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
        catch (IllegalArgumentException e) {
            throw new IOException();
        }
    }

    public synchronized void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            c = true;
            BandwidthTracker bt = (BandwidthTracker)iter.next();
            bt.measureBandwidth();
            currentTotal += bt.getAverageBandwidth();
        }
        if (c) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float sum = 0.0f;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            BandwidthTracker bt = (BandwidthTracker)iter.next();
            float curr = 0.0f;
            try {
                curr = bt.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            sum += curr;
        }
        return sum;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(Object o) {
        if (o == null) {
            return;
        }
        Object object = o;
        synchronized (object) {
            o.notify();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PushFailoverRequestor
    implements Runnable {
        final RemoteFileDesc _file;
        final byte[] _guid;
        final Object _toNotify;

        public PushFailoverRequestor(RemoteFileDesc file, byte[] guid, Object toNotify) {
            this._file = file;
            this._guid = guid;
            this._toNotify = toNotify;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean proceed = false;
            byte[] key = this._file.getClientGUID();
            Map map = DownloadManager.this.UDP_FAILOVER;
            synchronized (map) {
                Set files = (Set)DownloadManager.this.UDP_FAILOVER.get(key);
                if (files != null && files.contains(this._file.getFileName())) {
                    proceed = true;
                    files.remove(this._file.getFileName());
                    if (files.isEmpty()) {
                        DownloadManager.this.UDP_FAILOVER.remove(key);
                    }
                }
            }
            if (proceed && !DownloadManager.this.sendPushTCP(this._file, this._guid)) {
                DownloadManager.this.notify(this._toNotify);
            }
        }
    }

    private static final class GIVLine {
        final String file;
        final int index;
        final byte[] clientGUID;

        GIVLine(String file, int index, byte[] clientGUID) {
            this.file = file;
            this.index = index;
            this.clientGUID = clientGUID;
        }
    }
}

