/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.chat;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;

public class InstantMessenger
implements Chatter {
    private Socket _socket;
    private BufferedReader _reader;
    private BufferedWriter _out;
    private String _host;
    private int _port;
    private String _message = "";
    private ActivityCallback _activityCallback;
    private ChatManager _manager;
    private boolean _outgoing = false;

    public InstantMessenger(Socket socket, ChatManager manager, ActivityCallback callback) throws IOException {
        this._manager = manager;
        this._socket = socket;
        this._port = socket.getPort();
        this._host = this._socket.getInetAddress().getHostAddress();
        this._activityCallback = callback;
        OutputStream os = this._socket.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        this._out = new BufferedWriter(osw);
        InputStream istream = this._socket.getInputStream();
        this._reader = new BufferedReader(new InputStreamReader(istream, "UTF-8"));
        this.readHeader();
    }

    public InstantMessenger(String host, int port, ChatManager manager, ActivityCallback callback) throws IOException {
        this._host = host;
        this._port = port;
        this._manager = manager;
        this._activityCallback = callback;
        this._outgoing = true;
    }

    private void OutgoingInitializer() throws IOException {
        String str;
        this._socket = new Socket(this._host, this._port);
        this._socket.setSoTimeout(8000);
        OutputStream os = this._socket.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        this._out = new BufferedWriter(osw);
        this._out.write("CHAT CONNECT/0.1\r\n");
        this._out.write("User-Agent: " + CommonUtils.getVendor() + "\r\n");
        this._out.write("\r\n");
        this._out.flush();
        InputStream istream = this._socket.getInputStream();
        this._reader = new BufferedReader(new InputStreamReader(istream, "UTF-8"));
        do {
            if ((str = this._reader.readLine()) != null) continue;
            return;
        } while (!str.equals(""));
        this._out.write("CHAT/0.1 200 OK\r\n");
        this._out.write("\r\n");
        this._out.flush();
        this._socket.setSoTimeout(0);
        this._activityCallback.acceptChat(this);
    }

    public void start() {
        MessageReader messageReader = new MessageReader(this);
        ManagedThread upThread = new ManagedThread(messageReader, "MessageReader");
        upThread.setDaemon(true);
        upThread.start();
    }

    public void stop() {
        this._manager.removeChat(this);
        try {
            this._out.close();
            this._socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void send(String message) {
        try {
            this._out.write(message + "\n");
            this._out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public synchronized String getMessage() {
        String str = this._message;
        this._message = "";
        return str;
    }

    public void blockHost(String host) {
        this._manager.blockHost(host);
    }

    public void readHeader() throws IOException {
        String str;
        this._socket.setSoTimeout(8000);
        do {
            if ((str = this._reader.readLine()) != null) continue;
            return;
        } while (!str.equals(""));
        this._out.write("CHAT/0.1 200 OK\r\n");
        this._out.write("\r\n");
        this._out.flush();
        do {
            if ((str = this._reader.readLine()) != null) continue;
            return;
        } while (!str.equals(""));
        this._socket.setSoTimeout(0);
    }

    private class MessageReader
    implements Runnable {
        Chatter _chatter;

        public MessageReader(Chatter chatter) {
            this._chatter = chatter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block11: {
                try {
                    if (InstantMessenger.this._outgoing) {
                        try {
                            InstantMessenger.this.OutgoingInitializer();
                        }
                        catch (IOException e) {
                            InstantMessenger.this._activityCallback.chatUnavailable(this._chatter);
                            return;
                        }
                    }
                    try {}
                    catch (IOException e) {
                        InstantMessenger.this._activityCallback.chatUnavailable(this._chatter);
                        return;
                    }
                    break block11;
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
                return;
            }
            while (true) {
                String str = InstantMessenger.this._reader.readLine();
                InstantMessenger instantMessenger = InstantMessenger.this;
                synchronized (instantMessenger) {
                    if (str == null) throw new IOException();
                    if (str == "") {
                        throw new IOException();
                    }
                    InstantMessenger.this._message = InstantMessenger.this._message + str;
                    InstantMessenger.this._activityCallback.receiveMessage(this._chatter);
                }
            }
        }
    }
}

