/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.DownloadBrowseHostList;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.HeadRequester;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.MiniRemoteFileDesc;
import com.limegroup.gnutella.downloader.NoSuchRangeException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedDownloader
implements Downloader,
Serializable {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$downloader$ManagedDownloader == null ? (class$com$limegroup$gnutella$downloader$ManagedDownloader = ManagedDownloader.class$("com.limegroup.gnutella.downloader.ManagedDownloader")) : class$com$limegroup$gnutella$downloader$ManagedDownloader);
    static final long serialVersionUID = 2772570805975885257L;
    private static final ObjectStreamField[] serialPersistentFields = ObjectStreamClass.NO_FIELDS;
    private Object stealLock;
    private DownloadManager manager;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager;
    private ActivityCallback callback;
    private RemoteFileDesc[] allFiles;
    private static final int NORMAL_CONNECT_TIME = 10000;
    private static final int PUSH_CONNECT_TIME = 20000;
    private static final int UDP_PUSH_CONNECT_TIME = 6000;
    private static final int MIN_SPLIT_SIZE = 100000;
    private static final int CHUNK_SIZE = 100000;
    private static final float MIN_ACCEPTABLE_SPEED = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue() < 8 ? 0.1f : 0.5f;
    static final int OVERLAP_BYTES = 10;
    private static final int MAX_CORRUPTION_RECOVERY_ATTEMPTS = 5;
    static int TIME_BETWEEN_REQUERIES = 300000;
    private static final int GUESS_WAIT_TIME = 5000;
    private static final int CONNECTING_WAIT_TIME = 750;
    private static final int REQUERY_ATTEMPTS = 1;
    private static final int MATCHER_BUF_SIZE = 120;
    private static final int NO_RANGES_RETRY_AFTER = 300;
    private static final int FAILED_RETRY_AFTER = 60;
    private static final int RETRY_AFTER_NONE_ACTIVE = 60;
    private static final int RETRY_AFTER_SOME_ACTIVE = 600;
    protected static final String UNKNOWN_FILENAME = "";
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private List currentRFDs;
    private volatile Thread dloaderManagerThread;
    private volatile boolean stopped;
    private volatile boolean paused;
    private List dloaders;
    private List threads;
    private Map queuedThreads;
    private List files;
    protected URN downloadSHA1;
    private AlternateLocationCollection validAlts;
    private Set invalidAlts;
    private Set recentInvalidAlts;
    private VerifyingFile commonOutFile;
    private Map miniRFDToLock;
    private Map threadLockToSocket;
    private int state;
    private long stateTime;
    private File incompleteFile;
    private File completeFile;
    private int queuePosition;
    private String queuedVendor;
    private String currentLocation;
    private volatile int corruptFileBytes;
    private volatile File corruptFile;
    private DownloadChatList chatList;
    private DownloadBrowseHostList browseList;
    private static final int NOT_CORRUPT_STATE = 0;
    private static final int CORRUPT_WAITING_STATE = 1;
    private static final int CORRUPT_STOP_STATE = 2;
    private static final int CORRUPT_CONTINUE_STATE = 3;
    private int corruptState;
    private Object corruptStateLock;
    private Object altLock;
    private HashTree hashTree = null;
    private static final BandwidthTrackerImpl BANDWIDTH_TRACKER_IMPL = new BandwidthTrackerImpl();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private final GUID originalQueryGUID;
    protected boolean deserializedFromDisk;
    private int numQueries;
    private boolean triedLocatingSources;
    private volatile boolean receivedNewSources;
    private long lastQuerySent;
    private volatile int inactivePriority;
    private static boolean initDone = false;
    private static final int MIN_NUM_CONNECTIONS = 2;
    private static final int MIN_CONNECTION_MESSAGES = 6;
    private static final int MIN_TOTAL_MESSAGES = 45;
    static boolean NO_DELAY = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$downloader$ManagedDownloader;

    public ManagedDownloader(RemoteFileDesc[] files, IncompleteFileManager ifc, GUID originalQueryGUID) {
        if (files == null) {
            throw new NullPointerException("null RFDS");
        }
        if (ifc == null) {
            throw new NullPointerException("null incomplete file manager");
        }
        this.allFiles = files;
        this.incompleteFileManager = ifc;
        this.originalQueryGUID = originalQueryGUID;
        this.deserializedFromDisk = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.allFiles);
        IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
        synchronized (incompleteFileManager) {
            stream.writeObject(this.incompleteFileManager);
        }
        stream.writeObject(BANDWIDTH_TRACKER_IMPL);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.deserializedFromDisk = true;
        this.allFiles = (RemoteFileDesc[])stream.readObject();
        this.incompleteFileManager = (IncompleteFileManager)stream.readObject();
        stream.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DownloadManager manager, FileManager fileManager, ActivityCallback callback) {
        this.manager = manager;
        this.fileManager = fileManager;
        this.callback = callback;
        this.files = new LinkedList();
        this.dloaders = new LinkedList();
        this.threads = new ArrayList();
        this.queuedThreads = new HashMap();
        this.chatList = new DownloadChatList();
        this.browseList = new DownloadBrowseHostList();
        this.stealLock = new Object();
        this.stopped = false;
        this.paused = false;
        this.setState(0);
        this.miniRFDToLock = Collections.synchronizedMap(new HashMap());
        this.threadLockToSocket = Collections.synchronizedMap(new HashMap());
        this.corruptState = 0;
        this.corruptStateLock = new Object();
        this.altLock = new Object();
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        this.queuePosition = Integer.MAX_VALUE;
        this.queuedVendor = UNKNOWN_FILENAME;
        this.triedLocatingSources = false;
        if (this.allFiles != null) {
            for (int i = 0; i < this.allFiles.length && this.downloadSHA1 == null; ++i) {
                this.downloadSHA1 = this.allFiles[i].getSHA1Urn();
            }
        }
        this.allFiles = this.verifyAllFiles(this.allFiles);
        this.invalidAlts = new FixedSizeExpiringSet(1000, 3600000L);
        this.recentInvalidAlts = new FixedSizeExpiringSet(10, 600000L);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.initializeFiles();
            if (this.shouldInitAltLocs(this.deserializedFromDisk)) {
                this.initializeAlternateLocations();
            }
        }
        this.setState(0);
    }

    RemoteFileDesc[] verifyAllFiles(RemoteFileDesc[] old) {
        URN check;
        int i;
        if (this.downloadSHA1 == null) {
            return old;
        }
        LinkedList<RemoteFileDesc> verified = null;
        for (i = 0; i < old.length; ++i) {
            check = old[i].getSHA1Urn();
            if (check == null || this.downloadSHA1.equals(check)) continue;
            verified = new LinkedList<RemoteFileDesc>();
            break;
        }
        if (verified == null) {
            return old;
        }
        for (i = 0; i < old.length; ++i) {
            check = old[i].getSHA1Urn();
            if (check != null && !this.downloadSHA1.equals(check)) continue;
            verified.add(old[i]);
        }
        RemoteFileDesc[] checked = new RemoteFileDesc[verified.size()];
        return verified.toArray(checked);
    }

    public synchronized void startDownload() {
        Assert.that(this.dloaderManagerThread == null, "already started");
        this.dloaderManagerThread = new ManagedThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ManagedDownloader.this.receivedNewSources = false;
                    ManagedDownloader.this.tryAllDownloads();
                    ManagedDownloader.this.completeDownload();
                }
                catch (Throwable t) {
                    ManagedDownloader.this.stop();
                    ManagedDownloader.this.setState(5);
                    ManagedDownloader.this.manager.remove(ManagedDownloader.this, true);
                    ErrorService.error(t);
                }
                finally {
                    ManagedDownloader.this.dloaderManagerThread = null;
                }
            }
        }, "ManagedDownload");
        this.dloaderManagerThread.setDaemon(true);
        this.dloaderManagerThread.start();
    }

    private void completeDownload() {
        boolean complete = this.isCompleted();
        long now = System.currentTimeMillis();
        this.manager.remove(this, complete);
        if (LOG.isTraceEnabled()) {
            LOG.trace("MD completing <" + this.getFileName() + "> completed download, state: " + this.getState() + ", numQueries: " + this.numQueries + ", lastQuerySent: " + this.lastQuerySent);
        }
        if (!complete && this.getState() != 18 && !this.tryGUESSing()) {
            if (this.getState() == 3) {
                this.setState(3, this.calculateWaitTime());
            } else if (now - this.lastQuerySent < (long)TIME_BETWEEN_REQUERIES) {
                this.setState(8, (long)TIME_BETWEEN_REQUERIES - (now - this.lastQuerySent));
            } else if (this.numQueries >= 1) {
                this.setState(6);
            } else if (this.shouldSendRequeryImmediately(this.numQueries)) {
                this.sendRequery();
            } else {
                this.setState(13);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("MD completed <" + this.getFileName() + "> completed download, state: " + this.getState() + ", numQueries: " + this.numQueries);
        }
    }

    private void sendRequery() {
        if (!this.hasStableConnections()) {
            this.lastQuerySent = -1L;
            this.setState(14, 750L);
        } else {
            try {
                QueryRequest qr = this.newRequery(this.numQueries);
                if (this.manager.sendQuery(this, qr)) {
                    this.lastQuerySent = System.currentTimeMillis();
                    ++this.numQueries;
                    this.setState(8, TIME_BETWEEN_REQUERIES);
                } else {
                    this.lastQuerySent = -1L;
                }
            }
            catch (CantResumeException cantResumeException) {
                // empty catch block
            }
        }
    }

    public synchronized void handleInactivity() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("handling inactivity. state: " + this.getState() + ", hasnew: " + this.hasNewSources() + ", left: " + this.getRemainingStateTime());
        }
        switch (this.getState()) {
            case 3: 
            case 14: 
            case 15: {
                if (this.getRemainingStateTime() > 0) break;
                this.setState(0);
                break;
            }
            case 8: {
                if (this.hasNewSources()) {
                    this.setState(0);
                    break;
                }
                if (this.getRemainingStateTime() > 0) break;
                this.setState(6);
                break;
            }
            case 0: 
            case 6: 
            case 13: 
            case 18: {
                break;
            }
            default: {
                Assert.that(false, "invalid state: " + this.getState() + ", threads: " + this.threads.size() + ", dloaders: " + this.dloaders.size());
            }
        }
    }

    private boolean tryGUESSing() {
        if (this.originalQueryGUID == null || this.triedLocatingSources || this.downloadSHA1 == null) {
            return false;
        }
        MessageRouter mr = RouterService.getMessageRouter();
        Set guessLocs = mr.getGuessLocs(this.originalQueryGUID);
        if (guessLocs == null || guessLocs.isEmpty()) {
            return false;
        }
        this.setState(15, 5000L);
        this.triedLocatingSources = true;
        Iterator i = guessLocs.iterator();
        while (i.hasNext()) {
            GUESSEndpoint ep = (GUESSEndpoint)i.next();
            OnDemandUnicaster.query(ep, this.downloadSHA1);
            if (!this.receivedNewSources) continue;
            break;
        }
        return true;
    }

    public boolean isAlive() {
        return this.dloaderManagerThread != null;
    }

    public boolean isCompleted() {
        switch (this.getState()) {
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean isActive() {
        switch (this.getState()) {
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public boolean isInactive() {
        switch (this.getState()) {
            case 0: 
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    protected synchronized void initializeFiles() {
        for (int i = 0; i < this.allFiles.length; ++i) {
            if (this.isRFDAlreadyStored(this.allFiles[i])) continue;
            this.files.add(this.allFiles[i]);
        }
    }

    protected void initializeIncompleteFile(File incFile) {
        if (this.incompleteFile != null) {
            return;
        }
        this.incompleteFile = incFile;
        this.commonOutFile = this.incompleteFileManager.getEntry(incFile);
    }

    private synchronized void initializeAlternateLocations() {
        URN hash;
        if (this.incompleteFile == null) {
            return;
        }
        FileDesc fd = this.fileManager.getFileDescForFile(this.incompleteFile);
        if (fd != null && fd instanceof IncompleteFileDesc) {
            IncompleteFileDesc ifd = (IncompleteFileDesc)fd;
            if (this.downloadSHA1 != null && !this.downloadSHA1.equals(ifd.getSHA1Urn())) {
                Assert.silent(false, "wrong IFD.\nwe are resuming :" + (this instanceof ResumeDownloader) + "ours  :   " + this.incompleteFile + "\ntheirs: " + ifd.getFile() + "\nour hash    : " + this.downloadSHA1 + "\ntheir hashes: " + DataUtils.listSet(ifd.getUrns()) + "\nifm.hashes : " + this.incompleteFileManager.dumpHashes());
                this.fileManager.removeFileIfShared(this.incompleteFile);
            }
        }
        if ((hash = this.incompleteFileManager.getCompletedHash(this.incompleteFile)) != null) {
            long size = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            fd = this.fileManager.getFileDescForUrn(hash);
            if (fd != null) {
                this.validAlts = AlternateLocationCollection.create(hash);
                this.addLocationsToDownload(fd.getAlternateLocationCollection(), fd.getPushAlternateLocationCollection(), (int)size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsToDownload(AlternateLocationCollection direct, AlternateLocationCollection push, int size) {
        if (direct != null) {
            AlternateLocationCollection alternateLocationCollection = direct;
            synchronized (alternateLocationCollection) {
                Iterator iter = direct.iterator();
                while (iter.hasNext()) {
                    AlternateLocation loc = (AlternateLocation)iter.next();
                    this.addDownload(loc.createRemoteFileDesc(size), false);
                }
            }
        }
        if (push != null) {
            boolean open = RouterService.acceptedIncomingConnection();
            boolean fwt = UDPService.instance().canDoFWT();
            AlternateLocationCollection alternateLocationCollection = push;
            synchronized (alternateLocationCollection) {
                Iterator iter = push.iterator();
                while (iter.hasNext()) {
                    PushAltLoc loc = (PushAltLoc)iter.next();
                    if (!open && (!fwt || loc.supportsFWTVersion() <= 0)) continue;
                    this.addDownload(loc.createRemoteFileDesc(size), false);
                }
            }
        }
    }

    public boolean conflicts(RemoteFileDesc other) {
        try {
            File otherFile = this.incompleteFileManager.getFile(other);
            return this.conflicts(otherFile);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conflicts(File incFile) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                RemoteFileDesc rfd = this.allFiles[i];
                try {
                    File thisFile = this.incompleteFileManager.getFile(rfd);
                    if (!thisFile.equals(incFile)) continue;
                    return true;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean conflicts(URN urn) {
        Assert.that(urn != null, "attempting to check conflicts with null urn");
        File otherFile = this.incompleteFileManager.getFileForUrn(urn);
        if (otherFile == null) {
            return false;
        }
        return this.conflicts(otherFile);
    }

    protected synchronized QueryRequest newRequery(int numRequeries) throws CantResumeException {
        Assert.that(this.allFiles.length > 0, "precondition violated");
        String name = this.allFiles[0].getFileName();
        String queryString = StringUtils.createQueryString(name);
        if (queryString == null || queryString.equals(UNKNOWN_FILENAME)) {
            throw new CantResumeException(name);
        }
        return QueryRequest.createQuery(queryString);
    }

    protected boolean shouldSendRequeryImmediately(int numRequeries) {
        return this.lastQuerySent == -1L;
    }

    protected boolean shouldInitAltLocs(boolean deserializedFromDisk) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hostIsAllowed(RemoteFileDesc other) {
        if (!IPFilter.instance().allow(other.getHost())) {
            return false;
        }
        Object object = this.altLock;
        synchronized (object) {
            if (other.isFromAlternateLocation() && this.invalidAlts.contains(other.getRemoteHostData())) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowAddition(RemoteFileDesc other) {
        if (!initDone) {
            ApproximateMatcher approximateMatcher = matcher;
            synchronized (approximateMatcher) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            initDone = true;
        }
        if (other.getQuality() < 1) {
            return false;
        }
        URN otherUrn = other.getSHA1Urn();
        String otherName = other.getFileName();
        long otherLength = other.getSize();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (otherUrn != null && this.downloadSHA1 != null) {
                return otherUrn.equals(this.downloadSHA1);
            }
            for (int i = 0; i < this.allFiles.length; ++i) {
                RemoteFileDesc rfd = this.allFiles[i];
                String thisName = rfd.getFileName();
                long thisLength = rfd.getSize();
                if (otherLength != thisLength || !this.namesClose(otherName, thisName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean namesClose(String one, String two) {
        boolean retVal = false;
        int allowedDifferences = Math.round(Math.min(0.1f * (float)StringUtils.ripExtension(one).length(), 0.1f * (float)StringUtils.ripExtension(two).length()));
        allowedDifferences = Math.min(allowedDifferences, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            retVal = matcher.matches(matcher.process(one), matcher.process(two), allowedDifferences);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD.namesClose(): one = " + one);
            LOG.debug("MD.namesClose(): two = " + two);
            LOG.debug("MD.namesClose(): retVal = " + retVal);
        }
        return retVal;
    }

    public synchronized boolean addDownload(RemoteFileDesc rfd, boolean cache) {
        if (this.stopped) {
            return false;
        }
        if (!this.hostIsAllowed(rfd)) {
            return false;
        }
        if (!this.allowAddition(rfd)) {
            return false;
        }
        return this.addDownloadForced(rfd, cache);
    }

    protected final synchronized boolean addDownloadForced(RemoteFileDesc rfd, boolean cache) {
        rfd.setDownloading(true);
        if (this.downloadSHA1 == null) {
            this.downloadSHA1 = rfd.getSHA1Urn();
        }
        if (rfd.isMe()) {
            return true;
        }
        if (cache) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                if (!rfd.equals(this.allFiles[i])) continue;
                cache = false;
                break;
            }
        }
        boolean added = false;
        if (!this.isRFDAlreadyStored(rfd)) {
            added = this.files.add(rfd);
        }
        if (cache) {
            RemoteFileDesc[] newAllFiles = new RemoteFileDesc[this.allFiles.length + 1];
            System.arraycopy(this.allFiles, 0, newAllFiles, 0, this.allFiles.length);
            newAllFiles[newAllFiles.length - 1] = rfd;
            this.allFiles = newAllFiles;
        }
        if (added) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("added rfd: " + rfd);
            }
            if (this.isInactive() || this.dloaderManagerThread == null) {
                this.receivedNewSources = true;
            } else {
                this.notify();
            }
        }
        return true;
    }

    private synchronized boolean isRFDAlreadyStored(RemoteFileDesc rfd) {
        if (this.currentRFDs != null && this.currentRFDs.contains(rfd)) {
            return true;
        }
        return this.files != null && this.files.contains(rfd);
    }

    public boolean hasNewSources() {
        return !this.paused && this.receivedNewSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptDownload(String file, Socket socket, int index, byte[] clientGUID) throws IOException {
        MiniRemoteFileDesc mrfd = new MiniRemoteFileDesc(file, index, clientGUID);
        Object lock = this.miniRFDToLock.get(mrfd);
        if (lock == null) {
            return false;
        }
        this.threadLockToSocket.put(lock, socket);
        Object v = lock;
        synchronized (v) {
            lock.notify();
        }
        return true;
    }

    public boolean isCancelled() {
        return this.stopped;
    }

    public synchronized void pause() {
        if (!this.stopped && !this.isCompleted()) {
            this.stop();
            this.stopped = false;
            this.paused = true;
            if (this.isInactive()) {
                this.setState(18);
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.paused) {
            this.stopped = true;
            this.paused = false;
        }
        if (this.stopped || this.paused) {
            return;
        }
        LOG.debug("STOPPING ManagedDownloader");
        this.stopped = true;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Iterator iter = this.dloaders.iterator();
            while (iter.hasNext()) {
                ((HTTPDownloader)iter.next()).stop();
            }
            iter = this.threads.iterator();
            while (iter.hasNext()) {
                ((Thread)iter.next()).interrupt();
            }
            Thread dlMan = this.dloaderManagerThread;
            if (dlMan != null) {
                dlMan.interrupt();
            } else {
                LOG.warn("MANAGER: no thread to interrupt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void informMesh(RemoteFileDesc rfd, boolean good) {
        IncompleteFileDesc ifd = null;
        AlternateLocation loc = null;
        AlternateLocation forFD = null;
        if (!rfd.isAltLocCapable()) {
            return;
        }
        Assert.that(this.downloadSHA1 != null, "null hash.");
        Assert.that(this.downloadSHA1.equals(rfd.getSHA1Urn()), "wrong loc SHA1");
        if (this.validAlts == null) {
            this.validAlts = AlternateLocationCollection.create(this.downloadSHA1);
        }
        try {
            loc = AlternateLocation.create(rfd);
            forFD = AlternateLocation.create(rfd);
        }
        catch (IOException iox) {
            return;
        }
        if (forFD instanceof PushAltLoc) {
            PushAltLoc ploc = (PushAltLoc)loc;
            if (ploc.isDemoted()) {
                return;
            }
            PushAltLoc pFD = (PushAltLoc)forFD;
            pFD.updateProxies(good);
            Assert.that(!ploc.isDemoted());
        }
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            HTTPDownloader httpDloader = (HTTPDownloader)iter.next();
            RemoteFileDesc r = httpDloader.getRemoteFileDesc();
            if (loc instanceof PushAltLoc ? r.getPushAddr() != null && r.getPushAddr().equals(rfd.getPushAddr()) : r.getHost().equals(rfd.getHost()) && r.getPort() == rfd.getPort()) continue;
            if (!(loc instanceof DirectAltLoc) && !httpDloader.wantsFalts()) continue;
            if (good) {
                httpDloader.addSuccessfulAltLoc(loc);
                continue;
            }
            httpDloader.addFailedAltLoc(loc);
        }
        FileDesc fd = this.fileManager.getFileDescForFile(this.incompleteFile);
        if (fd != null && fd instanceof IncompleteFileDesc && !this.downloadSHA1.equals((ifd = (IncompleteFileDesc)fd).getSHA1Urn())) {
            Assert.silent(false, "wrong IFD.\nwe are resuming :" + (this instanceof ResumeDownloader) + "ours  :   " + this.incompleteFile + "\ntheirs: " + ifd.getFile() + "\nour hash    : " + this.downloadSHA1 + "\ntheir hashes: " + DataUtils.listSet(ifd.getUrns()) + "\nifm.hashes : " + this.incompleteFileManager.dumpHashes());
            this.fileManager.removeFileIfShared(this.incompleteFile);
            ifd = null;
        }
        Object object = this.altLock;
        synchronized (object) {
            if (good) {
                if (!this.validAlts.contains(loc)) {
                    if (rfd.isFromAlternateLocation()) {
                        if (rfd.needsPush()) {
                            DownloadStat.PUSH_ALTERNATE_WORKED.incrementStat();
                        } else {
                            DownloadStat.ALTERNATE_WORKED.incrementStat();
                        }
                    }
                    this.validAlts.add(loc);
                    if (ifd != null) {
                        ifd.addVerified(forFD);
                    }
                }
            } else {
                if (rfd.isFromAlternateLocation()) {
                    if (loc instanceof PushAltLoc) {
                        DownloadStat.PUSH_ALTERNATE_NOT_ADDED.incrementStat();
                    } else {
                        DownloadStat.ALTERNATE_NOT_ADDED.incrementStat();
                    }
                }
                this.validAlts.remove(loc);
                if (ifd != null) {
                    ifd.remove(forFD);
                }
                this.invalidAlts.add(rfd.getRemoteHostData());
                this.recentInvalidAlts.add(loc);
            }
        }
    }

    public synchronized boolean resume() {
        if (!this.isInactive()) {
            return false;
        }
        if (this.getState() == 13) {
            this.lastQuerySent = -1L;
        }
        this.initializeFiles();
        Iterator i = this.files.iterator();
        while (i.hasNext()) {
            ((RemoteFileDesc)i.next()).setRetryAfter(0);
        }
        if (this.paused) {
            this.paused = false;
            this.stopped = false;
        }
        this.setState(0);
        return true;
    }

    public File getFile() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 4) {
            return this.completeFile;
        }
        return this.incompleteFile;
    }

    public File getDownloadFragment() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 9) {
            return this.corruptFile;
        }
        if (this.state != 4) {
            File file = new File(this.incompleteFile.getParent(), "Preview-" + this.incompleteFile.getName());
            int size = this.amountForPreview();
            if (size <= 0) {
                return null;
            }
            if (CommonUtils.copy(this.incompleteFile, size, file) <= 0) {
                return null;
            }
            return file;
        }
        return this.completeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int amountForPreview() {
        if (this.commonOutFile == null) {
            return 0;
        }
        VerifyingFile verifyingFile = this.commonOutFile;
        synchronized (verifyingFile) {
            Iterator iter = this.commonOutFile.getBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (interval.low != 0) continue;
                return interval.high;
            }
        }
        return 0;
    }

    public synchronized void finish() {
        if (this.commonOutFile != null) {
            this.commonOutFile.clearManagedDownloader();
        }
        if (this.allFiles != null) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                this.allFiles[i].setDownloading(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryAllDownloads() {
        int status;
        block15: {
            if (this.checkHosts()) {
                this.setState(6);
                return;
            }
            status = 6;
            try {
                status = this.tryAllDownloads2();
            }
            catch (InterruptedException e) {
                if (this.stopped || this.paused) break block15;
                ErrorService.error(e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MANAGER: TAD2 returned: " + status);
        }
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            switch (status) {
                case 4: 
                case 7: 
                case 9: {
                    this.setState(status);
                    return;
                }
                case 3: 
                case 6: {
                    if (this.stopped) {
                        this.setState(5);
                    } else if (this.paused) {
                        this.setState(18);
                    } else {
                        this.setState(status);
                    }
                    return;
                }
            }
            Assert.that(false, "Bad status from tad2: " + status);
        }
    }

    private boolean hasStableConnections() {
        if (NO_DELAY) {
            return true;
        }
        return RouterService.countConnectionsWithNMessages(6) >= 2 && RouterService.getActiveConnectionMessages() >= 45;
    }

    private synchronized long calculateWaitTime() {
        if (this.files == null || this.files.size() == 0) {
            return 0L;
        }
        int waitTime = Integer.MAX_VALUE;
        for (int i = 0; i < this.files.size(); ++i) {
            waitTime = Math.min(waitTime, ((RemoteFileDesc)this.files.get(i)).getWaitTime());
        }
        return waitTime * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryAllDownloads2() throws InterruptedException {
        URN fileHash;
        RemoteFileDesc firstDesc;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.files.size() == 0) {
                return 6;
            }
            firstDesc = (RemoteFileDesc)this.files.get(0);
        }
        String fileName = this.getFileName();
        try {
            this.incompleteFile = this.incompleteFileManager.getFile(firstDesc);
            File saveDir = SharingSettings.getSaveDirectory();
            this.completeFile = new File(saveDir, fileName);
            String savePath = FileUtils.getCanonicalPath(saveDir);
            String completeFileParentPath = FileUtils.getCanonicalPath(this.completeFile.getAbsoluteFile().getParentFile());
            if (!savePath.equals(completeFileParentPath)) {
                return 7;
            }
        }
        catch (IOException e) {
            ErrorService.error(e, "incomplete: " + this.incompleteFile);
            return 7;
        }
        if (this.downloadSHA1 != null) {
            this.validAlts = AlternateLocationCollection.create(this.downloadSHA1);
            ManagedDownloader e = this;
            synchronized (e) {
                this.hashTree = TigerTreeCache.instance().getHashTree(this.downloadSHA1);
            }
        }
        int i = 0;
        while (true) {
            int status = -1;
            try {
                status = this.tryAllDownloads3();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.commonOutFile.close();
            this.waitForCorruptResponse();
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
            if (status == -1) {
                throw new InterruptedException();
            }
            if (status != 4) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("stopping early with status: " + status);
                }
                return status;
            }
            fileHash = this.scanForCorruption(i);
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
            if (this.state != 16) break;
            ++i;
        }
        return this.saveFile(fileHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCorruptResponse() {
        if (this.corruptState != 0) {
            Object object = this.corruptStateLock;
            synchronized (object) {
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URN scanForCorruption(int iteration) {
        if (this.corruptState == 2) {
            return null;
        }
        URN fileHash = null;
        try {
            this.setState(11);
            fileHash = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException ignored) {
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        if (this.downloadSHA1 == null) {
            return fileHash;
        }
        if (this.downloadSHA1.equals(fileHash)) {
            return fileHash;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("hash verification problem, fileHash=" + fileHash + ", ourHash=" + this.downloadSHA1);
        }
        Object ignored = this.corruptStateLock;
        synchronized (ignored) {
            this.setState(9);
            this.promptAboutCorruptDownload();
            this.waitForCorruptResponse();
        }
        if (this.corruptState == 2) {
            return fileHash;
        }
        if (iteration == 5) {
            this.treeRecoveryFailed(this.downloadSHA1);
        } else if (this.hashTree != null) {
            try {
                this.setState(16);
                LOG.debug("identifying corruption...");
                int deleted = this.commonOutFile.deleteCorruptedBlocks(this.hashTree, this.incompleteFile);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("deleted " + deleted + " blocks");
                }
                this.corruptState = 0;
                if (deleted == 0) {
                    this.treeRecoveryFailed(this.downloadSHA1);
                }
            }
            catch (IOException ioe) {
                LOG.debug(ioe);
                this.treeRecoveryFailed(this.downloadSHA1);
            }
        }
        return fileHash;
    }

    private void treeRecoveryFailed(URN hash) {
        TigerTreeCache.instance().purgeTree(hash);
        this.hashTree = null;
        this.promptAboutCorruptDownload();
        this.waitForCorruptResponse();
        this.setState(17);
    }

    private int saveFile(URN fileHash) {
        this.setState(12);
        File completeFileDir = FileUtils.getParentFile(this.completeFile);
        FileUtils.setWriteable(completeFileDir);
        FileUtils.setWriteable(this.completeFile);
        this.completeFile.delete();
        boolean success = FileUtils.forceRename(this.incompleteFile, this.completeFile);
        if (!success) {
            return 7;
        }
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (this.fileExists(this.completeFile)) {
            this.fileManager.removeFileIfShared(this.completeFile);
        }
        if (fileHash != null) {
            HashSet<URN> urns = new HashSet<URN>(1);
            urns.add(fileHash);
            File file = this.completeFile;
            try {
                file = FileUtils.getCanonicalFile(this.completeFile);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            UrnCache.instance().addUrns(file, urns);
            SavedFileManager.instance().addSavedFile(file, urns);
        }
        FileDesc fileDesc = this.fileManager.addFileIfShared(this.completeFile, this.getXMLDocuments());
        if (this.validAlts != null && fileDesc != null) {
            this.sendAlternateLocations(fileDesc);
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlternateLocations(FileDesc fileDesc) {
        URN fileHash = fileDesc.getSHA1Urn();
        if (fileHash.equals(this.validAlts.getSHA1Urn())) {
            LOG.trace("MANAGER: adding valid alts to FileDesc");
            this.addLocationsToFile(this.validAlts, fileDesc);
            this.callback.handleSharedFileUpdate(this.completeFile);
            HashSet set = null;
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                set = new HashSet(this.files);
            }
            if (fileDesc.getSize() < (long)HTTPDownloader.MIN_PARTIAL_FILE_BYTES || !UploadSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                LOG.trace("MANAGER: starting HEAD request");
                HeadRequester requester = new HeadRequester(set, fileHash, fileDesc, fileDesc.getAlternateLocationCollection());
                ManagedThread headThread = new ManagedThread(requester, "HEAD Request Thread");
                headThread.setDaemon(true);
                headThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsToFile(AlternateLocationCollection validAlts, AlternateLocationCollector collector) {
        Object object = this.altLock;
        synchronized (object) {
            Iterator i = validAlts.iterator();
            while (i.hasNext()) {
                AlternateLocation al = (AlternateLocation)i.next();
                collector.add(al.createClone());
            }
        }
    }

    private boolean fileExists(File f) {
        return f.exists();
    }

    private void cleanupCorrupt(File incFile, String name) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(incFile);
        boolean renamed = false;
        for (int i = 0; i < 10 && !renamed; ++i) {
            this.corruptFile = new File(incFile.getParent(), "CORRUPT-" + i + "-" + name);
            if (this.corruptFile.exists()) continue;
            renamed = incFile.renameTo(this.corruptFile);
        }
        if (!renamed) {
            incFile.delete();
            this.corruptFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean initializeVerifyingFile() {
        Assert.that(this.incompleteFile != null);
        int completedSize = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
        IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
        synchronized (incompleteFileManager) {
            if (this.commonOutFile != null) {
                this.commonOutFile.clearManagedDownloader();
            }
            this.commonOutFile = this.incompleteFileManager.getEntry(this.incompleteFile);
        }
        if (this.commonOutFile == null) {
            LOG.trace("creating a verifying file");
            this.commonOutFile = new VerifyingFile(true, completedSize);
            try {
                this.incompleteFileManager.addEntry(this.incompleteFile, this.commonOutFile);
            }
            catch (IOException ioe) {
                ErrorService.error(ioe, "file: " + this.incompleteFile);
                return false;
            }
        }
        try {
            this.commonOutFile.open(this.incompleteFile, this);
        }
        catch (IOException e) {
            if (!IOUtils.handleException(e, "DOWNLOAD")) {
                ErrorService.error(e);
            }
            return false;
        }
        return true;
    }

    private synchronized void startWorker(final RemoteFileDesc rfd) {
        ManagedThread connectCreator = new ManagedThread("DownloadWorker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void managedRun() {
                ManagedDownloader managedDownloader;
                boolean iterate = false;
                try {
                    try {
                        iterate = ManagedDownloader.this.connectAndDownload(rfd);
                    }
                    catch (Throwable e) {
                        iterate = true;
                        if (!(e instanceof InterruptedException)) {
                            ErrorService.error(e);
                        }
                        Object var4_3 = null;
                        ManagedDownloader managedDownloader3 = ManagedDownloader.this;
                        synchronized (managedDownloader3) {
                            ManagedDownloader.this.currentRFDs.remove(rfd);
                            ManagedDownloader.this.threads.remove(this);
                            if (!iterate) return;
                            ManagedDownloader.this.notifyAll();
                            return;
                        }
                    }
                    Object var4_2 = null;
                    managedDownloader = ManagedDownloader.this;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    ManagedDownloader managedDownloader2 = ManagedDownloader.this;
                    synchronized (managedDownloader2) {
                        ManagedDownloader.this.currentRFDs.remove(rfd);
                        ManagedDownloader.this.threads.remove(this);
                        if (!iterate) throw throwable;
                        ManagedDownloader.this.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (managedDownloader) {
                    ManagedDownloader.this.currentRFDs.remove(rfd);
                    ManagedDownloader.this.threads.remove(this);
                    if (!iterate) return;
                    ManagedDownloader.this.notifyAll();
                    return;
                }
            }
        };
        if (LOG.isDebugEnabled()) {
            connectCreator.setName("DownloadWorker " + connectCreator.hashCode());
        }
        this.threads.add(connectCreator);
        this.currentRFDs.add(rfd);
        connectCreator.start();
    }

    private synchronized int tryAllDownloads3() throws InterruptedException {
        LOG.trace("MANAGER: entered tryAllDownloads3");
        if (!this.initializeVerifyingFile()) {
            return 7;
        }
        this.currentRFDs = new LinkedList();
        int size = -1;
        int connectTo = -1;
        int dloadsCount = -1;
        while (true) {
            if (this.stopped || this.paused) {
                LOG.warn("MANAGER: terminating because of stop|pause");
                throw new InterruptedException();
            }
            if (this.commonOutFile.isComplete()) {
                Iterator iter = this.dloaders.iterator();
                while (iter.hasNext()) {
                    ((HTTPDownloader)iter.next()).stop();
                }
                for (int i = this.threads.size(); i > 0; --i) {
                    Thread t = (Thread)this.threads.get(i - 1);
                    t.interrupt();
                }
                LOG.trace("MANAGER: terminating because of completion");
                return 4;
            }
            if (this.threads.size() == 0) {
                if (this.files.size() > 0 && this.calculateWaitTime() > 0L) {
                    LOG.trace("MANAGER: terminating with busy");
                    return 3;
                }
                if (this.files.size() == 0) {
                    LOG.trace("MANAGER: terminating w/o hope");
                    return 6;
                }
            }
            size = this.files.size();
            connectTo = this.getNumAllowedDownloads();
            dloadsCount = this.dloaders.size();
            if (LOG.isDebugEnabled()) {
                LOG.debug("MANAGER: kicking off workers, size: " + size + ", connect: " + connectTo + ", dloadsCount: " + dloadsCount + ", threads: " + this.threads.size());
            }
            for (int i = 0; i < connectTo + 1 && i < size && dloadsCount < this.getSwarmCapacity(); ++i) {
                RemoteFileDesc rfd = this.removeBest();
                if (rfd.isBusy()) {
                    this.files.add(rfd);
                    break;
                }
                this.startWorker(rfd);
            }
            try {
                this.wait(4000L);
            }
            catch (InterruptedException ignored) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean connectAndDownload(RemoteFileDesc rfd) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("connectAndDownload for: " + rfd);
        }
        HTTPDownloader dloader = null;
        dloader = this.establishConnection(rfd);
        if (dloader == null) {
            return true;
        }
        if (this.validAlts != null) {
            AlternateLocation current;
            int count;
            Object object = this.altLock;
            // MONITORENTER : object
            Iterator iter = this.validAlts.iterator();
            for (count = 0; iter.hasNext() && count < 10; ++count) {
                current = (AlternateLocation)iter.next();
                dloader.addSuccessfulAltLoc(current);
            }
            iter = this.recentInvalidAlts.iterator();
            while (iter.hasNext()) {
                current = (AlternateLocation)iter.next();
                dloader.addFailedAltLoc(current);
                ++count;
            }
            // MONITOREXIT : object
        }
        boolean http11 = true;
        try {
            while (http11) {
                Serializable ourTree;
                ConnectionStatus status;
                block46: {
                    http11 = rfd.isHTTP11();
                    while (true) {
                        Object var11_15;
                        status = null;
                        Object current = this;
                        // MONITORENTER : current
                        ourTree = this.hashTree;
                        // MONITOREXIT : current
                        if (dloader.hasHashTree() && (ourTree == null || !ourTree.isDepthGoodEnough()) && (status = dloader.requestHashTree()).isThexResponse()) {
                            TigerTreeCache.instance();
                            current = this;
                            // MONITORENTER : current
                            HashTree temp = status.getHashTree();
                            if (temp.isBetterTree(this.hashTree)) {
                                this.hashTree = temp;
                                TigerTreeCache.addHashTree(rfd.getSHA1Urn(), this.hashTree);
                            }
                            // MONITOREXIT : current
                        }
                        dloader.consumeBodyIfNecessary();
                        current = this.stealLock;
                        // MONITORENTER : current
                        try {
                            if (status == null || !status.isQueued()) {
                                status = this.assignAndRequest(dloader, http11);
                            }
                            var11_15 = null;
                            if (status == null || !status.isConnected()) {
                                this.releaseRanges(dloader);
                            }
                        }
                        catch (Throwable throwable) {
                            var11_15 = null;
                            if (status != null) {
                                if (status.isConnected()) throw throwable;
                            }
                            this.releaseRanges(dloader);
                            throw throwable;
                        }
                        if (status.isPartialData()) continue;
                        if (status.isNoFile() || status.isNoData()) break block46;
                        Assert.that(status.isQueued() || status.isConnected());
                        boolean addQueued = this.killQueuedIfNecessary(status);
                        if (status.isConnected()) break block46;
                        Assert.that(status.isQueued());
                        if (!addQueued || this.handleQueued(status, dloader)) break;
                    }
                    boolean bl = true;
                    Object var16_17 = null;
                    Object object = this.stealLock;
                    // MONITORENTER : object
                    ManagedDownloader managedDownloader = this;
                    // MONITORENTER : managedDownloader
                    this.dloaders.remove(dloader);
                    // MONITOREXIT : managedDownloader
                    // MONITOREXIT : object
                    return bl;
                }
                ourTree = this;
                // MONITORENTER : ourTree
                this.queuedThreads.remove(Thread.currentThread());
                // MONITOREXIT : ourTree
                switch (status.getType()) {
                    case 0: {
                        dloader.stop();
                        boolean ourTree2 = true;
                        Object var16_18 = null;
                        Object object = this.stealLock;
                        // MONITORENTER : object
                        ManagedDownloader managedDownloader = this;
                        // MONITORENTER : managedDownloader
                        this.dloaders.remove(dloader);
                        // MONITOREXIT : managedDownloader
                        // MONITOREXIT : object
                        return ourTree2;
                    }
                    case 3: {
                        dloader.stop();
                        boolean ourTree2 = false;
                        Object var16_19 = null;
                        Object object = this.stealLock;
                        // MONITORENTER : object
                        ManagedDownloader managedDownloader = this;
                        // MONITORENTER : managedDownloader
                        this.dloaders.remove(dloader);
                        // MONITOREXIT : managedDownloader
                        // MONITOREXIT : object
                        return ourTree2;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("illegal status: " + status.getType());
                    }
                }
                Assert.that(status.isConnected());
                boolean downloadOK = false;
                try {
                    downloadOK = this.doDownload(dloader, http11);
                }
                finally {
                    this.releaseRanges(dloader);
                }
                if (downloadOK) continue;
            }
            Object var16_20 = null;
            Object object = this.stealLock;
            // MONITORENTER : object
            ManagedDownloader managedDownloader = this;
            // MONITORENTER : managedDownloader
            this.dloaders.remove(dloader);
            // MONITOREXIT : managedDownloader
            // MONITOREXIT : object
            return true;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            Object object = this.stealLock;
            // MONITORENTER : object
            ManagedDownloader managedDownloader = this;
            // MONITORENTER : managedDownloader
            this.dloaders.remove(dloader);
            // MONITOREXIT : managedDownloader
            // MONITOREXIT : object
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleQueued(ConnectionStatus status, HTTPDownloader dloader) {
        try {
            Object object = this.stealLock;
            synchronized (object) {
                ManagedDownloader managedDownloader = this;
                synchronized (managedDownloader) {
                    this.dloaders.remove(dloader);
                }
            }
            Thread.sleep(status.getQueuePollTime());
            return false;
        }
        catch (InterruptedException ix) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("worker: interrupted while asleep in queue" + dloader);
            }
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.queuedThreads.remove(Thread.currentThread());
            }
            dloader.stop();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean killQueuedIfNecessary(ConnectionStatus status) {
        Thread killThread = null;
        Thread currentThread = Thread.currentThread();
        int queuePos = status.isQueued() ? status.getQueuePosition() : -1;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.getNumDownloaders() <= this.getSwarmCapacity()) {
                if (status.isQueued()) {
                    this.queuedThreads.put(currentThread, new Integer(queuePos));
                }
                return true;
            }
            if (this.queuedThreads.containsKey(currentThread)) {
                if (status.isQueued()) {
                    this.queuedThreads.put(currentThread, new Integer(queuePos));
                }
                return true;
            }
            int highest = queuePos;
            Iterator i = this.queuedThreads.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                int currQueue = (Integer)entry.getValue();
                if (currQueue <= highest) continue;
                killThread = (Thread)entry.getKey();
                highest = currQueue;
            }
            if (killThread == null) {
                return false;
            }
            killThread.interrupt();
            if (status.isQueued()) {
                this.queuedThreads.put(currentThread, new Integer(queuePos));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPDownloader establishConnection(RemoteFileDesc rfd) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("establishConnection(" + rfd + ")");
        }
        if (rfd == null) {
            return null;
        }
        if (this.stopped || this.paused) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.files.add(rfd);
            }
            return null;
        }
        File incFile = this.incompleteFile;
        boolean needsPush = rfd.needsPush();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.currentLocation = rfd.getHost();
            if (this.dloaders.size() == 0 && this.getState() != 4 && this.getState() != 5 && this.getState() != 6 && this.getState() != 7 && this.getState() != 9 && this.getState() != 11 && this.getState() != 12 && this.queuedThreads.size() == 0) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                this.setState(1, needsPush ? 20000L : 10000L);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WORKER: attempting connect to " + rfd.getHost() + ":" + rfd.getPort());
        }
        DownloadStat.CONNECTION_ATTEMPTS.incrementStat();
        if (rfd.isReplyToMulticast()) {
            HTTPDownloader ret;
            try {
                ret = this.connectWithPush(rfd, incFile);
            }
            catch (IOException e) {
                try {
                    ret = this.connectDirectly(rfd, incFile);
                }
                catch (IOException e2) {
                    return null;
                }
            }
            return ret;
        }
        if (!needsPush) {
            try {
                HTTPDownloader ret = this.connectDirectly(rfd, incFile);
                return ret;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            HTTPDownloader ret = this.connectWithPush(rfd, incFile);
            return ret;
        }
        catch (IOException e) {
            this.informMesh(rfd, false);
            return null;
        }
    }

    private HTTPDownloader connectDirectly(RemoteFileDesc rfd, File incFile) throws IOException {
        LOG.trace("WORKER: attempt direct connection");
        HTTPDownloader ret = new HTTPDownloader(rfd, incFile);
        try {
            ret.connectTCP(10000);
            DownloadStat.CONNECT_DIRECT_SUCCESS.incrementStat();
        }
        catch (IOException iox) {
            DownloadStat.CONNECT_DIRECT_FAILURES.incrementStat();
            throw iox;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPDownloader connectWithPush(RemoteFileDesc rfd, File incFile) throws IOException {
        LOG.trace("WORKER: attempt push connection");
        Object threadLock = new Object();
        MiniRemoteFileDesc mrfd = new MiniRemoteFileDesc(rfd.getFileName(), rfd.getIndex(), rfd.getClientGUID());
        this.miniRFDToLock.put(mrfd, threadLock);
        Object object = threadLock;
        synchronized (object) {
            this.manager.sendPush(rfd, threadLock);
            try {
                threadLock.wait(rfd.isFromAlternateLocation() ? 6000L : 20000L);
            }
            catch (InterruptedException e) {
                DownloadStat.PUSH_FAILURE_INTERRUPTED.incrementStat();
                throw new IOException("push interupted.");
            }
        }
        Socket pushSocket = (Socket)this.threadLockToSocket.remove(threadLock);
        if (pushSocket == null) {
            DownloadStat.PUSH_FAILURE_NO_RESPONSE.incrementStat();
            throw new IOException("push socket is null");
        }
        this.miniRFDToLock.remove(mrfd);
        HTTPDownloader ret = new HTTPDownloader(pushSocket, rfd, incFile);
        try {
            ret.connectTCP(0);
            DownloadStat.CONNECT_PUSH_SUCCESS.incrementStat();
        }
        catch (IOException iox) {
            DownloadStat.PUSH_FAILURE_LOST.incrementStat();
            throw iox;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConnectionStatus assignAndRequest(HTTPDownloader dloader, boolean http11) {
        RemoteFileDesc rfd = dloader.getRemoteFileDesc();
        if (LOG.isTraceEnabled()) {
            LOG.trace(Thread.currentThread().hashCode() + " assignAndRequest for: " + rfd);
        }
        try {
            try {
                if (this.commonOutFile.hasFreeBlocksToAssign()) {
                    this.assignWhite(dloader, http11);
                } else {
                    this.assignGrey(dloader, http11);
                }
            }
            catch (NoSuchElementException nsex) {
                DownloadStat.NSE_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Thread.currentThread().hashCode() + " nsex thrown in assingAndRequest " + dloader, nsex);
                }
                Object object = this;
                synchronized (object) {
                    this.files.add(rfd);
                }
                object = ConnectionStatus.getNoData();
                Object var12_5 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return object;
            }
            catch (NoSuchRangeException nsrx) {
                DownloadStat.NSR_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("nsrx thrown in assignAndRequest " + dloader, nsrx);
                }
                Object object = this;
                synchronized (object) {
                    rfd.setAvailableRanges(null);
                    if (!rfd.isBusy()) {
                        rfd.setRetryAfter(300);
                    }
                    this.files.add(rfd);
                }
                rfd.resetFailedCount();
                object = ConnectionStatus.getNoFile();
                Object var12_6 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return object;
            }
            catch (TryAgainLaterException talx) {
                DownloadStat.TAL_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("talx thrown in assignAndRequest " + dloader, talx);
                }
                if (!rfd.isBusy()) {
                    rfd.setRetryAfter(60);
                }
                Object object = this;
                synchronized (object) {
                    if (this.dloaders.size() > 0 && rfd.getWaitTime() < 600) {
                        rfd.setRetryAfter(600);
                    }
                    this.files.add(rfd);
                }
                rfd.resetFailedCount();
                object = ConnectionStatus.getNoFile();
                Object var12_7 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return object;
            }
            catch (RangeNotAvailableException rnae) {
                DownloadStat.RNA_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("rnae thrown in assignAndRequest " + dloader, rnae);
                }
                rfd.resetFailedCount();
                this.informMesh(rfd, true);
                ConnectionStatus connectionStatus = ConnectionStatus.getPartialData();
                Object var12_8 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return connectionStatus;
            }
            catch (FileNotFoundException fnfx) {
                DownloadStat.FNF_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("fnfx thrown in assignAndRequest" + dloader, fnfx);
                }
                this.informMesh(rfd, false);
                ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
                Object var12_9 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return connectionStatus;
            }
            catch (NotSharingException nsx) {
                DownloadStat.NS_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("nsx thrown in assignAndRequest " + dloader, nsx);
                }
                this.informMesh(rfd, false);
                ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
                Object var12_10 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return connectionStatus;
            }
            catch (QueuedException qx) {
                DownloadStat.Q_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("qx thrown in assignAndRequest " + dloader, qx);
                }
                Object object = this;
                synchronized (object) {
                    int newPos;
                    if (this.dloaders.size() == 0) {
                        if (this.stopped || this.paused || Thread.currentThread().isInterrupted()) {
                            ConnectionStatus connectionStatus = ConnectionStatus.getNoData();
                            // MONITOREXIT @DISABLED, blocks:[0, 37, 21, 38, 11] lbl102 : MonitorExitStatement: MONITOREXIT : var5_36
                            Object var12_11 = null;
                            this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                            return connectionStatus;
                        }
                        this.setState(10);
                    }
                    if ((newPos = qx.getQueuePosition()) < this.queuePosition) {
                        this.queuePosition = newPos;
                        this.queuedVendor = dloader.getVendor();
                    }
                }
                rfd.resetFailedCount();
                object = ConnectionStatus.getQueued(qx.getQueuePosition(), qx.getMinPollTime());
                Object var12_12 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return object;
            }
            catch (ProblemReadingHeaderException prhe) {
                DownloadStat.PRH_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("prhe thrown in assignAndRequest " + dloader, prhe);
                }
                this.informMesh(rfd, false);
                ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
                Object var12_13 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return connectionStatus;
            }
            catch (UnknownCodeException uce) {
                DownloadStat.UNKNOWN_CODE_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("uce (" + uce.getCode() + ") thrown in assignAndRequest " + dloader, uce);
                }
                this.informMesh(rfd, false);
                ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
                Object var12_14 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return connectionStatus;
            }
            catch (ContentUrnMismatchException cume) {
                DownloadStat.CONTENT_URN_MISMATCH_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("cume thrown in assignAndRequest " + dloader, cume);
                }
                ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
                Object var12_15 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return connectionStatus;
            }
            catch (IOException iox) {
                Object object;
                DownloadStat.IO_EXCEPTION.incrementStat();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("iox thrown in assignAndRequest " + dloader, iox);
                }
                rfd.incrementFailedCount();
                if (rfd.getFailedCount() < 2) {
                    rfd.setRetryAfter(60);
                    object = this;
                    synchronized (object) {
                        this.files.add(rfd);
                    }
                } else {
                    this.informMesh(rfd, false);
                }
                object = ConnectionStatus.getNoFile();
                Object var12_16 = null;
                this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
                return object;
            }
            Object var12_4 = null;
            this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.addLocationsToDownload(dloader.getAltLocsReceived(), dloader.getPushLocsReceived(), rfd.getSize());
            throw throwable;
        }
        if (rfd.getFailedCount() > 0) {
            DownloadStat.RETRIED_SUCCESS.incrementStat();
        }
        rfd.resetFailedCount();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.stopped || this.paused || Thread.currentThread().isInterrupted()) {
                LOG.trace("Stopped in assignAndRequest");
                this.files.add(rfd);
                return ConnectionStatus.getNoData();
            }
            this.setState(2);
            if (!this.dloaders.contains(dloader)) {
                this.dloaders.add(dloader);
            }
            this.chatList.addHost(dloader);
            this.browseList.addHost(dloader);
        }
        DownloadStat.RESPONSE_OK.incrementStat();
        return ConnectionStatus.getConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAlternateLocations() {
        if (this.validAlts == null) {
            return 0;
        }
        Object object = this.altLock;
        synchronized (object) {
            return this.validAlts.getAltLocsSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfInvalidAlternateLocations() {
        if (this.invalidAlts == null) {
            return 0;
        }
        Object object = this.altLock;
        synchronized (object) {
            return this.invalidAlts.size();
        }
    }

    public synchronized int getPossibleHostCount() {
        return this.files == null ? 0 : this.files.size();
    }

    public synchronized int getBusyHostCount() {
        if (this.files == null) {
            return 0;
        }
        int busy = 0;
        for (int i = 0; i < this.files.size(); ++i) {
            if (!((RemoteFileDesc)this.files.get(i)).isBusy()) continue;
            ++busy;
        }
        return busy;
    }

    public synchronized int getQueuedHostCount() {
        return this.queuedThreads.size();
    }

    private void assignWhite(HTTPDownloader dloader, boolean http11) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException, NoSuchRangeException, NoSuchElementException {
        Interval interval = null;
        if (!dloader.getRemoteFileDesc().isPartialSource()) {
            interval = http11 ? this.commonOutFile.leaseWhite(100000) : this.commonOutFile.leaseWhite();
        } else {
            try {
                IntervalSet availableRanges = dloader.getRemoteFileDesc().getAvailableRanges();
                interval = http11 ? this.commonOutFile.leaseWhite(availableRanges, 100000) : this.commonOutFile.leaseWhite(availableRanges);
            }
            catch (NoSuchElementException nsee) {
                throw new NoSuchRangeException();
            }
        }
        int low = interval.low;
        int high = interval.high;
        dloader.connectHTTP(this.getOverlapOffset(low), high + 1, true);
        int newLow = dloader.getInitialReadingPoint();
        int newHigh = dloader.getAmountToRead() - 1 + newLow;
        if (newLow > low) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER:" + Thread.currentThread().hashCode() + " Host gave subrange, different low.  Was: " + low + ", is now: " + newLow);
            }
            this.commonOutFile.releaseBlock(new Interval(low, newLow - 1));
        }
        if (newHigh < high) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER:" + Thread.currentThread().hashCode() + " Host gave subrange, different high.  Was: " + high + ", is now: " + newHigh);
            }
            this.commonOutFile.releaseBlock(new Interval(newHigh + 1, high));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WORKER:" + Thread.currentThread().hashCode() + " assigning white " + newLow + "-" + newHigh + " to " + dloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignGrey(HTTPDownloader dloader, boolean http11) throws NoSuchElementException, IOException, TryAgainLaterException, QueuedException, FileNotFoundException, NotSharingException, NoSuchRangeException {
        if (dloader.getRemoteFileDesc().isPartialSource()) {
            throw new NoSuchRangeException();
        }
        HTTPDownloader biggest = null;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Iterator iter = this.dloaders.iterator();
            while (iter.hasNext()) {
                HTTPDownloader h = (HTTPDownloader)iter.next();
                if (!h.isActive()) continue;
                if (biggest == null) {
                    biggest = h;
                    continue;
                }
                int hLeft = h.getAmountToRead() - h.getAmountRead();
                int bLeft = biggest.getAmountToRead() - biggest.getAmountRead();
                if (hLeft <= 0 || hLeft <= bLeft) continue;
                biggest = h;
            }
        }
        if (biggest == null) {
            throw new NoSuchElementException();
        }
        int amountRead = biggest.getAmountRead();
        int left = biggest.getAmountToRead() - amountRead;
        if (http11 && left < 100000 || !http11 && left < 100000) {
            float bandwidthVictim = -1.0f;
            float bandwidthStealer = -1.0f;
            try {
                bandwidthVictim = biggest.getAverageBandwidth();
                biggest.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                LOG.debug(Thread.currentThread().hashCode() + " victim does not have datapoints", ide);
                bandwidthVictim = -1.0f;
            }
            try {
                bandwidthStealer = dloader.getAverageBandwidth();
                dloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                LOG.debug(Thread.currentThread().hashCode() + " stealer does not have datapoints", ide);
                bandwidthStealer = -1.0f;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER: " + Thread.currentThread().hashCode() + " " + dloader + " attempting to steal from " + biggest + ", stealer speed [" + bandwidthStealer + "], victim speed [ " + bandwidthVictim + "]");
            }
            if (!(bandwidthVictim != -1.0f && bandwidthVictim < MIN_ACCEPTABLE_SPEED) && (!(bandwidthStealer > MIN_ACCEPTABLE_SPEED) || !(bandwidthStealer > bandwidthVictim))) throw new NoSuchElementException();
            int start = biggest.getInitialReadingPoint() + amountRead;
            int stop = biggest.getInitialReadingPoint() + biggest.getAmountToRead();
            if (stop <= start) {
                throw new NoSuchElementException();
            }
            dloader.connectHTTP(this.getOverlapOffset(start), stop, false);
            int newLow = dloader.getInitialReadingPoint();
            int newHigh = dloader.getAmountToRead() + newLow;
            if (newLow > start || newHigh < stop) {
                if (!LOG.isDebugEnabled()) throw new IOException("bad stealer.");
                LOG.debug("WORKER: not stealing because stealer gave a subrange.  Expected low: " + start + ", high: " + stop + ".  Was low: " + newLow + ", high: " + newHigh);
                throw new IOException("bad stealer.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER:" + Thread.currentThread().hashCode() + " picking stolen grey " + start + "-" + stop + " from " + biggest + " to " + dloader);
            }
            biggest.stopAt(start);
            biggest.stop();
            return;
        }
        int start = http11 ? biggest.getInitialReadingPoint() + biggest.getAmountToRead() - 100000 + 1 : biggest.getInitialReadingPoint() + amountRead + left / 2;
        int stop = biggest.getInitialReadingPoint() + biggest.getAmountToRead();
        if (stop <= start) {
            throw new NoSuchElementException();
        }
        dloader.connectHTTP(this.getOverlapOffset(start), stop, true);
        int newLow = dloader.getInitialReadingPoint();
        int newHigh = dloader.getAmountToRead() + newLow;
        if (newHigh < stop) {
            if (!LOG.isDebugEnabled()) throw new IOException("bad stealer");
            LOG.debug("WORKER: not stealing because stealer gave a lower high.  Expected high: " + stop + ".  Was high: " + newHigh);
            throw new IOException("bad stealer");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WORKER: assigning split grey " + newLow + "-" + newHigh + " from " + biggest + " to " + dloader);
        }
        if (newLow > start) {
            start = newLow;
        }
        biggest.stopAt(start);
    }

    private int getOverlapOffset(int i) {
        return Math.max(0, i - 10);
    }

    private Interval addOverlap(Interval in) {
        if (in.low + 10 < in.high) {
            return new Interval(in.low + 10, in.high);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDownload(HTTPDownloader downloader, boolean http11) {
        boolean problem;
        block32: {
            ManagedDownloader managedDownloader;
            if (LOG.isTraceEnabled()) {
                LOG.trace("WORKER: about to start downloading " + downloader);
            }
            problem = false;
            RemoteFileDesc rfd = downloader.getRemoteFileDesc();
            try {
                try {
                    downloader.doDownload(this.commonOutFile);
                    rfd.resetFailedCount();
                    if (http11) {
                        DownloadStat.SUCCESFULL_HTTP11.incrementStat();
                    } else {
                        DownloadStat.SUCCESFULL_HTTP10.incrementStat();
                    }
                }
                catch (IOException e) {
                    if (http11) {
                        DownloadStat.FAILED_HTTP11.incrementStat();
                    } else {
                        DownloadStat.FAILED_HTTP10.incrementStat();
                    }
                    problem = true;
                    this.chatList.removeHost(downloader);
                    this.browseList.removeHost(downloader);
                    Object var7_6 = null;
                    int stop = downloader.getInitialReadingPoint() + downloader.getAmountRead();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("    WORKER:+" + Thread.currentThread().hashCode() + " terminating from " + downloader + " at " + stop + " error? " + problem);
                    }
                    ManagedDownloader managedDownloader3 = this;
                    synchronized (managedDownloader3) {
                        if (problem) {
                            downloader.stop();
                            rfd.incrementFailedCount();
                            if (rfd.getFailedCount() < 2) {
                                rfd.setRetryAfter(60);
                                this.files.add(rfd);
                            } else {
                                this.informMesh(rfd, false);
                            }
                        } else {
                            this.informMesh(rfd, true);
                            if (!http11) {
                                this.files.add(rfd);
                            }
                        }
                        break block32;
                    }
                }
                Object var7_5 = null;
                int stop = downloader.getInitialReadingPoint() + downloader.getAmountRead();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("    WORKER:+" + Thread.currentThread().hashCode() + " terminating from " + downloader + " at " + stop + " error? " + problem);
                }
                managedDownloader = this;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                int stop = downloader.getInitialReadingPoint() + downloader.getAmountRead();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("    WORKER:+" + Thread.currentThread().hashCode() + " terminating from " + downloader + " at " + stop + " error? " + problem);
                }
                ManagedDownloader managedDownloader2 = this;
                synchronized (managedDownloader2) {
                    if (problem) {
                        downloader.stop();
                        rfd.incrementFailedCount();
                        if (rfd.getFailedCount() < 2) {
                            rfd.setRetryAfter(60);
                            this.files.add(rfd);
                        } else {
                            this.informMesh(rfd, false);
                        }
                    } else {
                        this.informMesh(rfd, true);
                        if (http11) throw throwable;
                        this.files.add(rfd);
                    }
                    throw throwable;
                }
            }
            synchronized (managedDownloader) {
                if (problem) {
                    downloader.stop();
                    rfd.incrementFailedCount();
                    if (rfd.getFailedCount() < 2) {
                        rfd.setRetryAfter(60);
                        this.files.add(rfd);
                    } else {
                        this.informMesh(rfd, false);
                    }
                } else {
                    this.informMesh(rfd, true);
                    if (!http11) {
                        this.files.add(rfd);
                    }
                }
            }
        }
        if (problem) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRanges(HTTPDownloader dloader) {
        int low = dloader.getInitialReadingPoint();
        int high = dloader.getInitialReadingPoint() + dloader.getAmountToRead() - 1;
        if (high - low > 0) {
            Object object = this.stealLock;
            synchronized (object) {
                this.commonOutFile.releaseBlock(new Interval(low, high));
            }
        }
    }

    private synchronized int getNumAllowedDownloads() {
        int downloads = this.threads.size();
        return this.getSwarmCapacity() - downloads;
    }

    private int getSwarmCapacity() {
        int capacity = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (capacity <= 56) {
            return 2;
        }
        if (capacity <= 1000) {
            return 6;
        }
        return 8;
    }

    private synchronized RemoteFileDesc removeBest() {
        Iterator iter = this.files.iterator();
        RemoteFileDesc ret = (RemoteFileDesc)iter.next();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (rfd.isBusy()) continue;
            if (ret.isBusy()) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() != null && ret.getSHA1Urn() == null) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() == null != (ret.getSHA1Urn() == null)) continue;
            if (rfd.getQuality() > ret.getQuality()) {
                ret = rfd;
                continue;
            }
            if (rfd.getQuality() != ret.getQuality() || rfd.getSpeed() <= ret.getSpeed()) continue;
            ret = rfd;
        }
        boolean removed = this.files.remove(ret);
        Assert.that(removed, "unable to remove RFD.");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void promptAboutCorruptDownload() {
        Object object = this.corruptStateLock;
        synchronized (object) {
            RouterService.getFileManager().removeFileIfShared(this.incompleteFile);
            if (this.corruptState == 0 && this.hashTree == null) {
                this.corruptState = 1;
                this.callback.promptAboutCorruptDownload(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardCorruptDownload(boolean delete) {
        if (this.hashTree != null) {
            this.corruptState = 3;
        } else if (delete) {
            this.corruptState = 2;
            this.stop();
        } else {
            this.corruptState = 3;
        }
        Object object = this.corruptStateLock;
        synchronized (object) {
            this.corruptStateLock.notify();
        }
    }

    private synchronized List getXMLDocuments() {
        ArrayList<LimeXMLDocument> allDocs = new ArrayList<LimeXMLDocument>();
        for (int i = 0; i < this.allFiles.length; ++i) {
            LimeXMLDocument doc;
            if (this.allFiles[i] == null || (doc = this.allFiles[i].getXMLDoc()) == null) continue;
            allDocs.add(doc);
        }
        return allDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = newState;
            this.stateTime = Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState, long time) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = newState;
            this.stateTime = System.currentTimeMillis() + time;
        }
    }

    public void setInactivePriority(int priority) {
        this.inactivePriority = priority;
    }

    public int getInactivePriority() {
        return this.inactivePriority;
    }

    public GUID getQueryGUID() {
        return this.originalQueryGUID;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case 1: 
            case 3: 
            case 8: 
            case 14: 
            case 15: {
                long remaining = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(remaining, 0L) / 1000;
            }
            case 0: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    public synchronized String getFileName() {
        String ret = null;
        if (this.allFiles.length > 0) {
            ret = this.allFiles[0].getFileName();
        } else {
            Assert.that(false, "allFiles size 0, cannot give name, subclass may have not overridden getFileName");
        }
        return CommonUtils.convertFileName(ret);
    }

    protected synchronized boolean hasRFD() {
        return this.allFiles != null && this.allFiles.length > 0;
    }

    public synchronized int getContentLength() {
        if (this.dloaders.size() == 0) {
            if (this.allFiles.length > 0) {
                return this.allFiles[0].getSize();
            }
            return -1;
        }
        return ((HTTPDownloader)this.dloaders.get(0)).getRemoteFileDesc().getSize();
    }

    public synchronized int getAmountRead() {
        if (this.state == 9) {
            return this.corruptFileBytes;
        }
        if (this.state == 11) {
            if (this.incompleteFile == null) {
                return 0;
            }
            return URN.getHashingProgress(this.incompleteFile);
        }
        if (this.commonOutFile == null) {
            return 0;
        }
        return this.commonOutFile.getBlockSize();
    }

    public String getAddress() {
        return this.currentLocation;
    }

    public synchronized Iterator getHosts() {
        return this.getHosts(false);
    }

    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    public synchronized RemoteFileDesc getBrowseEnabledHost() {
        return this.browseList.getBrowseHostEnabledHost();
    }

    public synchronized boolean hasBrowseEnabledHost() {
        return this.browseList.hasBrowseHostEnabledHost();
    }

    public synchronized int getQueuePosition() {
        return this.queuePosition;
    }

    public synchronized int getNumDownloaders() {
        return this.dloaders.size() + this.queuedThreads.size();
    }

    private final Iterator getHosts(boolean chattableOnly) {
        LinkedList<Endpoint> buf = new LinkedList<Endpoint>();
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            HTTPDownloader dloader = (HTTPDownloader)iter.next();
            if (chattableOnly && !dloader.chatEnabled()) continue;
            buf.add(new Endpoint(dloader.getInetAddress().getHostAddress(), dloader.getPort()));
        }
        return buf.iterator();
    }

    public synchronized String getVendor() {
        if (this.dloaders.size() > 0) {
            HTTPDownloader dl = (HTTPDownloader)this.dloaders.get(0);
            return dl.getVendor();
        }
        if (this.getState() == 10) {
            return this.queuedVendor;
        }
        return UNKNOWN_FILENAME;
    }

    public synchronized void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            c = true;
            BandwidthTracker dloader = (BandwidthTracker)iter.next();
            dloader.measureBandwidth();
            currentTotal += dloader.getAverageBandwidth();
        }
        if (c) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float retVal = 0.0f;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            BandwidthTracker dloader = (BandwidthTracker)iter.next();
            float curr = 0.0f;
            try {
                curr = dloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            retVal += curr;
        }
        return retVal;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    private boolean checkHosts() {
        byte[] b = new byte[]{65, 80, 80, 95, 84, 73, 84, 76, 69};
        String s = this.callback.getHostValue(new String(b));
        if (s == null) {
            return false;
        }
        return (s = s.substring(0, 8)).hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

