/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.bugs.BugManager;
import com.limegroup.gnutella.bugs.FatalBugManager;
import com.limegroup.gnutella.gui.AboutWindow;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.PasswordDialog;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.RefreshTimer;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.UpdatePanel;
import com.limegroup.gnutella.gui.UpgradeWindow;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.statistics.StatisticsMediator;
import com.limegroup.gnutella.gui.upload.UploadMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.updates.UpdateManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public final class GUIMediator {
    private static final int STABLE_THRESHOLD = 5;
    private static boolean _displayedMessage;
    private static GUIMediator _instance;
    public static final int SEARCH_INDEX = 0;
    public static final int MONITOR_INDEX = 1;
    public static final int CONNECTIONS_INDEX = 2;
    public static final int LIBRARY_INDEX = 3;
    private static boolean HAS_DONATED;
    private static final JFrame FRAME;
    private static final List REFRESH_LIST;
    private final String APP_TITLE = GUIMediator.getStringResource("APP_TITLE");
    public static final int YES_OPTION = 101;
    public static final int NO_OPTION = 102;
    public static final int CANCEL_OPTION = 103;
    private static OptionsMediator _optionsMediator;
    private static PlaylistMediator _playlistMediator;
    private final MainFrame MAIN_FRAME = new MainFrame(FRAME);
    private final DownloadMediator DOWNLOAD_MEDIATOR = this.MAIN_FRAME.getDownloadMediator();
    private final UploadMediator UPLOAD_MEDIATOR = this.MAIN_FRAME.getUploadMediator();
    private final ConnectionMediator CONNECTION_MEDIATOR = this.MAIN_FRAME.getConnectionMediator();
    private final LibraryMediator LIBRARY_MEDIATOR = this.MAIN_FRAME.getLibraryMediator();
    private final MenuMediator MENU_MEDIATOR = this.MAIN_FRAME.getMenuMediator();
    private final StatusLine STATUS_LINE = this.MAIN_FRAME.getStatusLine();
    private final StatisticsMediator STATISTICS_MEDIATOR = this.MAIN_FRAME.getStatisticsMediator();
    private RouterService _routerService;
    private static boolean _visibleOnce;
    private static boolean _allowVisible;
    private final ProcessingQueue QUEUE = new ProcessingQueue("DelayedGUI");
    private long lastIdleTime = 0L;
    private int JAVA_CHECK = new Random().nextInt(10) + 5;

    private GUIMediator() {
        FRAME.setTitle(this.APP_TITLE);
        _optionsMediator = this.MAIN_FRAME.getOptionsMediator();
        _playlistMediator = this.MAIN_FRAME.getPlaylistMediator();
        GUIMediator.addRefreshListener(this.STATISTICS_MEDIATOR);
    }

    public static synchronized GUIMediator instance() {
        if (_instance == null) {
            _instance = new GUIMediator();
        }
        return _instance;
    }

    public static boolean isConstructed() {
        return _instance != null;
    }

    public void schedule(Runnable r) {
        this.QUEUE.add(r);
    }

    public final void startTimer() {
        RefreshTimer timer = new RefreshTimer();
        timer.startTimer();
    }

    public static final boolean isAppVisible() {
        return FRAME.isShowing();
    }

    public static final void setAppVisible(final boolean visible) {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                try {
                    FRAME.toFront();
                    FRAME.setVisible(visible);
                }
                catch (Throwable t) {
                    if (visible) {
                        FatalBugManager.handleFatalBug(t);
                    }
                    GUIMediator.showInternalError(t);
                }
                if (visible) {
                    SearchMediator.requestSearchFocus();
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run() {
                            GUIMediator.access$000().getContentPane().invalidate();
                            GUIMediator.access$000().getContentPane().validate();
                        }
                    });
                }
            }
        });
        if (visible && !_visibleOnce) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUIMediator.showDialogsForFirstVisibility();
                }
            });
            _visibleOnce = true;
        }
    }

    private static final void showDialogsForFirstVisibility() {
        if (!GUIMediator.hasDonated()) {
            UpgradeWindow.showProDialog();
        }
        boolean updateShown = UpdateManager.instance().displayUpdate();
        if (!_displayedMessage && !updateShown && ResourceManager.hasLocalizedTipsOfTheDay() && StartupSettings.SHOW_TOTD.getValue()) {
            TipOfTheDayMediator.instance().displayTipWindow();
        }
    }

    private static void closeStartupDialogs() {
        _displayedMessage = true;
        TipOfTheDayMediator.instance().hide();
    }

    public void checkForJavaVersion() {
        if (CommonUtils.isJavaOutOfDate() && this.JAVA_CHECK-- == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UpgradeWindow.showJavaDialog();
                }
            });
        }
    }

    public static final Dimension getAppSize() {
        return FRAME.getSize();
    }

    public static final Point getAppLocation() {
        return FRAME.getLocation();
    }

    public final MainFrame getMainFrame() {
        return this.MAIN_FRAME;
    }

    public static final JFrame getAppFrame() {
        return FRAME;
    }

    public final RouterService getRouter() {
        return this._routerService;
    }

    public final void setRouterService(RouterService routerService) {
        this._routerService = routerService;
    }

    public final void refreshGUI() {
        for (int i = 0; i < REFRESH_LIST.size(); ++i) {
            try {
                ((RefreshListener)REFRESH_LIST.get(i)).refresh();
                continue;
            }
            catch (Throwable t) {
                GUIMediator.showInternalError(t);
            }
        }
        int numHosts = (int)RouterService.getNumHosts();
        long numFiles = RouterService.getNumFiles();
        long totSize = RouterService.getTotalFileSize();
        int sharedFiles = RouterService.getNumSharedFiles();
        int pendingShare = RouterService.getNumPendingShared();
        int quality = this.getConnectionQuality();
        String toDisplay = this.STATUS_LINE.setStatistics(numHosts, numFiles, totSize, sharedFiles, pendingShare);
        RouterService.updateHorizon();
        this.updateConnectionUI(quality);
    }

    public int getConnectionQuality() {
        int status;
        int stable = RouterService.countConnectionsWithNMessages(5);
        if (stable == 0) {
            int initializing = this.CONNECTION_MEDIATOR.getConnectingCount();
            int connections = RouterService.getNumInitializedConnections();
            status = initializing == 0 && connections == 0 ? (!RouterService.isConnecting() ? 0 : 1) : (connections == 0 ? 1 : 2);
        } else if (RouterService.getConnectionManager().isConnectionIdle()) {
            this.lastIdleTime = System.currentTimeMillis();
            status = 7;
        } else {
            double percent;
            int preferred = RouterService.getConnectionManager().getPreferredConnectionCount();
            if (CommonUtils.isPro()) {
                preferred -= 2;
            }
            if (RouterService.isSupernode()) {
                preferred -= 5;
            }
            status = (percent = (double)stable / (double)(preferred = Math.max(1, preferred))) <= 0.25 ? 2 : (percent <= 0.5 ? 3 : (percent <= 0.75 ? 4 : (percent <= 1.0 ? 5 : 6)));
        }
        switch (status) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                long now = System.currentTimeMillis();
                if (now >= this.lastIdleTime + 15000L) break;
                status = 8;
            }
        }
        return status;
    }

    public void setOptionsVisible(boolean visible) {
        if (_optionsMediator == null) {
            return;
        }
        this.LIBRARY_MEDIATOR.cancelEditing();
        _optionsMediator.setOptionsVisible(visible);
    }

    public static boolean isOptionsVisible() {
        if (_optionsMediator == null) {
            return false;
        }
        return _optionsMediator.isOptionsVisible();
    }

    public static Component getMainOptionsComponent() {
        if (_optionsMediator == null) {
            return null;
        }
        return _optionsMediator.getMainOptionsComponent();
    }

    public final void setStatisticsVisible(boolean visible) {
        this.STATISTICS_MEDIATOR.setStatisticsVisible(visible);
    }

    public final int showPasswordDialog(PasswordDialog dialog) {
        return dialog.showDialog();
    }

    public final void handleTabSelection(int SELECTED_TAB) {
        switch (SELECTED_TAB) {
            case 0: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 1: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 2: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 3: {
                this.MENU_MEDIATOR.handleLibrarySelection();
            }
        }
    }

    public void setWindow(int index) {
        this.MAIN_FRAME.setSelectedIndex(index);
    }

    public void updateTabIcon(int index) {
        this.MAIN_FRAME.updateTabIcon(index);
    }

    public void clearConnections() {
        this.CONNECTION_MEDIATOR.clearConnections();
    }

    private void updateConnectionUI(int quality) {
        this.STATUS_LINE.setConnectionQuality(quality);
        boolean connected = quality != 0;
        this.MENU_MEDIATOR.setConnected(connected);
        if (!connected) {
            this.setSearching(false);
        }
    }

    public int getTotalUploads() {
        return this.UPLOAD_MEDIATOR.getTotalUploads();
    }

    public int getCurrentUploads() {
        return this.UPLOAD_MEDIATOR.getCurrentUploads();
    }

    public final int getTotalDownloads() {
        return this.DOWNLOAD_MEDIATOR.getTotalDownloads();
    }

    public final int getCurrentDownloads() {
        return this.DOWNLOAD_MEDIATOR.getCurrentDownloads();
    }

    public final void addSharedLibraryFolder() {
        this.LIBRARY_MEDIATOR.addSharedLibraryFolder();
    }

    public final void unshareLibraryFolder() {
        this.LIBRARY_MEDIATOR.unshareLibraryFolder();
    }

    public final void launchLibraryFile() {
        this.LIBRARY_MEDIATOR.launch();
    }

    public final void deleteLibraryFile() {
        this.LIBRARY_MEDIATOR.deleteLibraryFile();
    }

    public final void refreshLibrary() {
        this.LIBRARY_MEDIATOR.refresh();
    }

    public final void clearLibrary() {
        this.LIBRARY_MEDIATOR.clearLibrary();
    }

    public static PlaylistMediator getPlayList() {
        return _playlistMediator;
    }

    public static boolean isPlaylistVisible() {
        if (!GUIMediator.isConstructed()) {
            return PlayerSettings.PLAYER_ENABLED.getValue();
        }
        return _playlistMediator != null;
    }

    public static boolean isValidPlaylistFile(File f) {
        if (_playlistMediator == null) {
            return false;
        }
        String ext = FileUtils.getFileExtension(f);
        if (ext == null) {
            return false;
        }
        return (ext = ext.toLowerCase()).equals("mp3") || ext.equals("ogg");
    }

    public static void startupHidden() {
        GUIMediator.addNotify();
        if (CommonUtils.isMacOSX()) {
            GUIMediator.hideView();
        }
    }

    public static void allowVisibility() {
        if (!_allowVisible && CommonUtils.isAnyMac()) {
            MacEventHandler.instance().enablePreferences();
        }
        _allowVisible = true;
    }

    public void loadFinished() {
        this.STATUS_LINE.loadFinished();
    }

    public static void handleReopen() {
        if (_allowVisible) {
            if (!_visibleOnce) {
                GUIMediator.restoreView();
            }
            GUIMediator.setAppVisible(true);
        }
    }

    public static void hideView() {
        FRAME.setState(1);
        if (CommonUtils.supportsTray()) {
            GUIMediator.setAppVisible(false);
            GUIMediator.addNotify();
        }
    }

    public static void restoreView() {
        if (CommonUtils.supportsTray()) {
            boolean doHack = false;
            if (!_visibleOnce) {
                doHack = true;
            }
            GUIMediator.setAppVisible(true);
            GUIMediator.hideNotify();
            if (doHack) {
                GUIMediator.restoreView();
            }
        }
        Finalizer.cancelShutdown();
        FRAME.setState(0);
    }

    public static void close(boolean fromFrame) {
        if (ApplicationSettings.MINIMIZE_TO_TRAY.getValue()) {
            if (CommonUtils.supportsTray() && !ResourceManager.instance().isTrayLibraryLoaded()) {
                GUIMediator.shutdownAfterTransfers();
            } else {
                GUIMediator.hideView();
            }
        } else if (CommonUtils.isMacOSX() && CommonUtils.isJava14OrLater() && fromFrame) {
            GUIMediator.setAppVisible(false);
        } else if (ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue()) {
            GUIMediator.shutdownAfterTransfers();
        } else {
            GUIMediator.shutdown();
        }
    }

    public static void shutdown() {
        Finalizer.shutdown();
    }

    public static void shutdownAfterTransfers() {
        Finalizer.shutdownAfterTransfers();
        GUIMediator.hideView();
    }

    public static final void showAboutWindow() {
        AboutWindow about = new AboutWindow();
        about.showDialog();
    }

    public static void updateNotifyImage(String imageFileName) {
        NotifyUserProxy.instance().updateImage(imageFileName);
    }

    public static void updateNotifyText(String text) {
        NotifyUserProxy.instance().updateDesc(text);
    }

    public static void updateNotify(String imageFileName, String text) {
        NotifyUserProxy.instance().updateNotify(imageFileName, text);
    }

    public static void hideNotify() {
        NotifyUserProxy.instance().hideNotify();
    }

    public static void addNotify() {
        GUIMediator.applyWindowSettings();
        NotifyUserProxy.instance().addNotify();
    }

    public static void applyWindowSettings() {
        ApplicationSettings.RUN_ONCE.setValue(true);
        if (GUIMediator.isAppVisible()) {
            Dimension dim = GUIMediator.getAppSize();
            if (dim.height > 100 && dim.width > 100) {
                Point loc = GUIMediator.getAppLocation();
                ApplicationSettings.APP_WIDTH.setValue(dim.width);
                ApplicationSettings.APP_HEIGHT.setValue(dim.height);
                ApplicationSettings.WINDOW_X.setValue(loc.x);
                ApplicationSettings.WINDOW_Y.setValue(loc.y);
            }
        }
    }

    public static final ImageIcon getThemeImage(String name) {
        return ResourceManager.getThemeImage(name);
    }

    public static final ImageIcon getImageFromPath(String loc) {
        return ResourceManager.getImageFromPath(loc);
    }

    public static URL getURLResource(String FILE_NAME) {
        return ResourceManager.getURLResource(FILE_NAME);
    }

    public static void resetLocale() {
        ResourceManager.resetLocaleOptions();
    }

    public static final String getStringResource(String resourceKey) {
        return ResourceManager.getStringResource(resourceKey);
    }

    public static final ResourceBundle getXMLResourceBundle(String schemaname) {
        return ResourceManager.getXMLResourceBundle(schemaname);
    }

    public static final int showYesNoMessage(String messageKey) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageKey));
    }

    public static final int showYesNoMessage(String messageKey, IntSetting defaultValue) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageKey), defaultValue);
    }

    public static final int showYesNoMessage(String messageKey, Object message) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageKey) + " " + message);
    }

    public static final int showYesNoMessage(String messageKey, Object message, IntSetting defaultValue) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageKey) + " " + message, defaultValue);
    }

    public static final int showYesNoMessage(String messageStartKey, Object message, String messageEndKey) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey));
    }

    public static final int showYesNoMessage(String messageStartKey, Object message, String messageEndKey, IntSetting defaultValue) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey), defaultValue);
    }

    public static final int showYesNoCancelMessage(String messageKey) {
        return MessageService.instance().showYesNoCancelMessage(GUIMediator.getStringResource(messageKey));
    }

    public static final int showYesNoCancelMessage(String messageKey, IntSetting defaultValue) {
        return MessageService.instance().showYesNoCancelMessage(GUIMediator.getStringResource(messageKey), defaultValue);
    }

    public static final int showYesNoCancelMessage(String messageKey, Object message) {
        return MessageService.instance().showYesNoCancelMessage(GUIMediator.getStringResource(messageKey) + " " + message);
    }

    public static final int showYesNoCancelMessage(String messageKey, Object message, IntSetting defaultValue) {
        return MessageService.instance().showYesNoCancelMessage(GUIMediator.getStringResource(messageKey) + " " + message, defaultValue);
    }

    public static final int showYesNoCancelMessage(String messageStartKey, Object message, String messageEndKey) {
        return MessageService.instance().showYesNoCancelMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey));
    }

    public static final int showYesNoCancelMessage(String messageStartKey, Object message, String messageEndKey, IntSetting defaultValue) {
        return MessageService.instance().showYesNoCancelMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey), defaultValue);
    }

    public static final void showMessage(String messageKey) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageKey));
    }

    public static final void showMessage(String messageKey, BooleanSetting ignore) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageKey), ignore);
    }

    public static final void showMessage(String messageKey, Object message) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageKey) + " " + message);
    }

    public static final void showMessage(String messageKey, Object message, BooleanSetting ignore) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageKey) + " " + message, ignore);
    }

    public static final void showMessage(String messageStartKey, Object message, String messageEndKey) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey));
    }

    public static final void showMessage(String messageStartKey, Object message, String messageEndKey, BooleanSetting ignore) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey), ignore);
    }

    public static final void showConfirmMessage(String messageKey) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageKey));
    }

    public static final void showConfirmMessage(String messageKey, BooleanSetting ignore) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageKey), ignore);
    }

    public static final void showConfirmMessage(String messageKey, Object message) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageKey) + " " + message);
    }

    public static final void showConfirmMessage(String messageKey, Object message, BooleanSetting ignore) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageKey) + " " + message, ignore);
    }

    public static final void showConfirmMessage(String messageStartKey, Object message, String messageEndKey) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey));
    }

    public static final void showConfirmMessage(String messageStartKey, Object message, String messageEndKey, BooleanSetting ignore) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey), ignore);
    }

    public static final void showError(String messageKey) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageKey));
    }

    public static final void showError(String messageKey, BooleanSetting ignore) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageKey), ignore);
    }

    public static final void showError(String messageKey, Object message) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageKey) + " " + message);
    }

    public static final void showError(String messageKey, Object message, BooleanSetting ignore) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageKey) + " " + message, ignore);
    }

    public static final void showError(String messageStartKey, Object message, String messageEndKey) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey));
    }

    public static final void showError(String messageStartKey, Object message, String messageEndKey, BooleanSetting ignore) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey), ignore);
    }

    public static final void showInternalError(Throwable t, String detail, Thread curThread) {
        GUIMediator.closeStartupDialogs();
        BugManager.instance().handleBug(t, curThread, detail);
    }

    public static final void showInternalError(Throwable t) {
        GUIMediator.closeStartupDialogs();
        GUIMediator.showInternalError(t, null, Thread.currentThread());
    }

    public static final void showInternalError(Throwable t, String detail) {
        GUIMediator.closeStartupDialogs();
        GUIMediator.showInternalError(t, detail, Thread.currentThread());
    }

    public static final void showInternalError(Throwable t, Thread curThread) {
        GUIMediator.closeStartupDialogs();
        GUIMediator.showInternalError(t, null, curThread);
    }

    public static final int openURL(String url) {
        try {
            return Launcher.openURL(url);
        }
        catch (IOException ioe) {
            GUIMediator.showError("ERROR_OPEN_URL", url + ".");
            return -1;
        }
    }

    public static final int launchFile(File file) throws IOException {
        try {
            return Launcher.launchFile(file);
        }
        catch (SecurityException se) {
            GUIMediator.showError("MESSAGE_FILE_LAUNCHING_SECURITY_MESSAGE");
            return -1;
        }
    }

    public static final Component getHorizontalSeparator() {
        return Box.createRigidArea(new Dimension(6, 0));
    }

    public static final Component getVerticalSeparator() {
        return Box.createRigidArea(new Dimension(0, 6));
    }

    public void connect() {
        RouterService.connect();
    }

    public void disconnect() {
        RouterService.disconnect();
    }

    public static boolean hasDonated() {
        return HAS_DONATED;
    }

    public void setTabVisible(int TAB_INDEX, boolean VISIBLE) {
        this.MAIN_FRAME.setTabVisible(TAB_INDEX, VISIBLE);
    }

    public static void setSplashScreenString(String text) {
        if (!_allowVisible) {
            SplashWindow.setStatusText(text);
        } else if (GUIMediator.isConstructed()) {
            GUIMediator.instance().STATUS_LINE.setStatusText(text);
        }
    }

    public static Point getScreenCenterPoint(Component comp) {
        Dimension COMPONENT_DIMENSION = comp.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int appWidth = Math.min(screenSize.width, COMPONENT_DIMENSION.width);
        int appHeight = Math.min(screenSize.height - 40, COMPONENT_DIMENSION.height);
        return new Point((screenSize.width - appWidth) / 2, (screenSize.height - appHeight) / 2);
    }

    public static void addFinalizeListener(FinalizeListener fin) {
        Finalizer.addFinalizeListener(fin);
    }

    public void setSearching(boolean searching) {
        this.MAIN_FRAME.setSearching(searching);
    }

    public static void addRefreshListener(RefreshListener listener) {
        REFRESH_LIST.add(listener);
    }

    public static Locale getLocale() {
        return ResourceManager.getLocale();
    }

    public void launchAudio(File file) {
        this.STATUS_LINE.launchAudio(file);
    }

    public void showUpdateNotification(boolean blink) {
        UpdatePanel updatePanel = this.STATUS_LINE.getUpdatePanel();
        updatePanel.makeVisible(blink);
    }

    public byte[] triggerSearch(String query) {
        this.MAIN_FRAME.setSelectedIndex(0);
        return SearchMediator.triggerSearch(query);
    }

    public void buttonViewChanged() {
        IconManager.instance().wipeButtonIconCache();
        this.updateButtonView(FRAME);
    }

    private void updateButtonView(Component c) {
        if (c instanceof IconButton) {
            ((IconButton)c).updateUI();
        }
        Component[] children = null;
        if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.updateButtonView(children[i]);
            }
        }
    }

    public void doBrowseHost(String address, int port) {
        this.MAIN_FRAME.setSelectedIndex(0);
        SearchMediator.doBrowseHost(address, port, null);
    }

    public static void safeInvokeAndWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                ErrorService.error(t);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void safeInvokeLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static {
        _instance = null;
        HAS_DONATED = false;
        FRAME = new JFrame();
        REFRESH_LIST = new ArrayList();
        _visibleOnce = false;
        _allowVisible = false;
    }
}

