/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.plaf.IconUIResource;

public class ImageManipulator
extends RGBImageFilter {
    private boolean brighter;
    private int percent;

    private ImageManipulator(boolean b, int p) {
        this.brighter = b;
        this.percent = p;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        return rgb & 0xFF000000 | this.filter(rgb >> 16) << 16 | this.filter(rgb >> 8) << 8 | this.filter(rgb);
    }

    private int filter(int color) {
        color &= 0xFF;
        color = this.brighter ? 255 - (255 - color) * (100 - this.percent) / 100 : color * (100 - this.percent) / 100;
        if (color < 0) {
            color = 0;
        }
        if (color > 255) {
            color = 255;
        }
        return color;
    }

    public static Icon brighten(Icon icon) {
        Image img = ImageManipulator.getImage(icon);
        if (img == null) {
            return icon;
        }
        img = ImageManipulator.brighten(img);
        return new IconUIResource(new ImageIcon(img));
    }

    public static Icon darken(Icon icon) {
        Image img = ImageManipulator.getImage(icon);
        if (img == null) {
            return icon;
        }
        img = ImageManipulator.darken(img);
        return new IconUIResource(new ImageIcon(img));
    }

    public static Icon gray(Icon icon) {
        Image img = ImageManipulator.getImage(icon);
        if (img == null) {
            return icon;
        }
        img = ImageManipulator.gray(img);
        return new IconUIResource(new ImageIcon(img));
    }

    public static Icon manipulate(Icon icon, boolean brighten, int percent) {
        Image img = ImageManipulator.getImage(icon);
        if (img == null) {
            return icon;
        }
        img = ImageManipulator.manipulate(img, brighten, percent);
        return new IconUIResource(new ImageIcon(img));
    }

    public static Image brighten(Image img) {
        return ImageManipulator.manipulate(img, true, 20);
    }

    public static Image darken(Image img) {
        return ImageManipulator.manipulate(img, false, 10);
    }

    public static Image gray(Image img) {
        return GrayFilter.createDisabledImage(img);
    }

    public static Image manipulate(Image img, boolean brighten, int percent) {
        ImageManipulator filter = new ImageManipulator(brighten, percent);
        FilteredImageSource prod = new FilteredImageSource(img.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public static Icon resize(Icon icon, int width, int height) {
        Image image = ImageManipulator.getImage(icon);
        if (image == null) {
            return icon;
        }
        image = image.getScaledInstance(width, height, 4);
        return new ImageIcon(image);
    }

    private static Image getImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage buffer = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = buffer.getGraphics();
        icon.paintIcon(new JLabel(), g, 0, 0);
        g.dispose();
        return buffer;
    }
}

