/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class LimeTextField
extends JTextField {
    private static Action UNDO_ACTION = new FieldAction("UNDO"){

        public void actionPerformed(ActionEvent e) {
            this.getField(e).undo();
        }
    };
    private static Action CUT_ACTION = new FieldAction("CUT"){

        public void actionPerformed(ActionEvent e) {
            this.getField(e).cut();
        }
    };
    private static Action COPY_ACTION = new FieldAction("COPY"){

        public void actionPerformed(ActionEvent e) {
            this.getField(e).copy();
        }
    };
    private static Action PASTE_ACTION = new FieldAction("PASTE"){

        public void actionPerformed(ActionEvent e) {
            this.getField(e).paste();
        }
    };
    private static Action DELETE_ACTION = new FieldAction("DELETE"){

        public void actionPerformed(ActionEvent e) {
            this.getField(e).replaceSelection("");
        }
    };
    private static Action SELECT_ALL_ACTION = new FieldAction("SELECT_ALL"){

        public void actionPerformed(ActionEvent e) {
            this.getField(e).selectAll();
        }
    };
    private static final JPopupMenu POPUP = LimeTextField.createPopup();
    private UndoManager undoManager;

    public LimeTextField() {
        this.init();
    }

    public LimeTextField(String text) {
        super(text);
        this.init();
    }

    public LimeTextField(int columns) {
        super(columns);
        this.init();
    }

    public LimeTextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public LimeTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    public void undo() {
        try {
            if (this.undoManager != null) {
                this.undoManager.undoOrRedo();
            }
        }
        catch (CannotUndoException ignored) {
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public void setUndoManager(UndoManager undoer) {
        this.undoManager = undoer;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setDocument(Document doc) {
        if (doc != this.getDocument()) {
            this.undoManager = null;
        }
        super.setDocument(doc);
    }

    private void init() {
        this.enableEvents(16L);
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1);
        this.getDocument().addUndoableEditListener(this.undoManager);
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (!e.isConsumed() && POPUP.isPopupTrigger(e)) {
            e.consume();
            POPUP.show(this, e.getX(), e.getY());
        }
    }

    private static JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu(){

            public void show(Component invoker, int x, int y) {
                ((LimeTextField)invoker).updateActions();
                super.show(invoker, x, y);
            }
        };
        popup.add(new JMenuItem(UNDO_ACTION));
        popup.addSeparator();
        popup.add(new JMenuItem(CUT_ACTION));
        popup.add(new JMenuItem(COPY_ACTION));
        popup.add(new JMenuItem(PASTE_ACTION));
        popup.add(new JMenuItem(DELETE_ACTION));
        popup.addSeparator();
        popup.add(new JMenuItem(SELECT_ALL_ACTION));
        return popup;
    }

    private void updateActions() {
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            selectedText = "";
        }
        boolean stuffSelected = !selectedText.equals("");
        boolean allSelected = selectedText.equals(this.getText());
        UNDO_ACTION.setEnabled(this.isEnabled() && this.isEditable() && this.isUndoAvailable());
        CUT_ACTION.setEnabled(this.isEnabled() && this.isEditable() && stuffSelected);
        COPY_ACTION.setEnabled(this.isEnabled() && stuffSelected);
        PASTE_ACTION.setEnabled(this.isEnabled() && this.isEditable() && this.isPasteAvailable());
        DELETE_ACTION.setEnabled(this.isEnabled() && stuffSelected);
        SELECT_ALL_ACTION.setEnabled(this.isEnabled() && !allSelected);
    }

    private boolean isUndoAvailable() {
        return this.getUndoManager() != null && this.getUndoManager().canUndoOrRedo();
    }

    private boolean isPasteAvailable() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(this);
            return contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
        catch (UnsupportedOperationException he) {
            return false;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    private static abstract class FieldAction
    extends AbstractAction {
        public FieldAction(String name) {
            super(GUIMediator.getStringResource("CONTEXT_MENU_" + name));
        }

        protected LimeTextField getField(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            JPopupMenu menu = (JPopupMenu)source.getParent();
            return (LimeTextField)menu.getInvoker();
        }
    }
}

