/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;

final class UpdateDialog {
    private final JDialog DIALOG;
    private int _responseCode;
    private static final int UPDATE_LATER = 10;
    private static final int UPDATE_NOW = 11;

    public UpdateDialog(String msg) {
        int WIDTH = 360;
        this.DIALOG = new JDialog(GUIMediator.getAppFrame());
        this.DIALOG.setModal(true);
        this.DIALOG.setTitle(GUIMediator.getStringResource("UPDATE_DIALOG_CAPTION"));
        MultiLineLabel label = new MultiLineLabel(msg, 320);
        String[] buttonLabels = new String[]{"YES", "NO"};
        String[] buttonTips = new String[]{"UPDATE_NOW_TIP", "UPDATE_LATER_TIP"};
        ActionListener[] buttonListeners = new ActionListener[]{new UpdateNowListener(), new UpdateLaterListener()};
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        mainPanel.add(label);
        ButtonRow buttonRow = new ButtonRow(buttonLabels, buttonTips, buttonListeners);
        Container contentPane = this.DIALOG.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(mainPanel);
        contentPane.add(Box.createVerticalGlue());
        contentPane.add(buttonRow);
        this.DIALOG.pack();
        this.DIALOG.setLocation(GUIMediator.getScreenCenterPoint(this.DIALOG));
        this.DIALOG.setVisible(true);
    }

    boolean isUpdating() {
        return this._responseCode == 11;
    }

    private final class UpdateLaterListener
    implements ActionListener {
        private UpdateLaterListener() {
        }

        public void actionPerformed(ActionEvent e) {
            UpdateDialog.this._responseCode = 10;
            UpdateDialog.this.DIALOG.setVisible(false);
            UpdateDialog.this.DIALOG.dispose();
        }
    }

    private final class UpdateNowListener
    implements ActionListener {
        private UpdateNowListener() {
        }

        public void actionPerformed(ActionEvent e) {
            UpdateDialog.this._responseCode = 11;
            UpdateDialog.this.DIALOG.setVisible(false);
            UpdateDialog.this.DIALOG.dispose();
        }
    }
}

