/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.LimitedList;
import com.limegroup.gnutella.util.Pair;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public class FileScan {
    private int MEM_WEIGHT = 1;
    private int NUM_WEIGHT = 1;
    private int MAX_DEPTH = 3;
    private String[] _extensions;
    private String[] _filters;
    private LimitedList _list = new LimitedList();

    public FileScan() {
        this._filters = new String[0];
        String exts = SharingSettings.EXTENSIONS_TO_SHARE.getValue();
        this._extensions = StringUtils.split(exts, ";");
    }

    public void setExtensions(String[] e) {
        this._extensions = e;
    }

    public void setFilters(String[] f) {
        this._filters = f;
    }

    public String[] getListAsArray() {
        Object[] objs = this._list.getAllElements();
        int len = objs.length;
        String[] files = new String[len];
        for (int i = 0; i < len; ++i) {
            if (objs[i] == null) continue;
            Pair p = (Pair)objs[i];
            File f = (File)p.getElement();
            try {
                files[i] = f.getCanonicalPath();
                continue;
            }
            catch (IOException ioe) {
                files[i] = "";
            }
        }
        return files;
    }

    public String getListAsString() {
        Object[] objs = this._list.getAllElements();
        int len = objs.length;
        String files = "";
        for (int i = 0; i < len; ++i) {
            if (objs[i] == null) continue;
            Pair p = (Pair)objs[i];
            File f = (File)p.getElement();
            try {
                files = files + f.getCanonicalPath();
                files = files + ";";
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return files;
    }

    public void scan(String pathname) {
        this.scan(pathname, this.MAX_DEPTH);
    }

    private void scan(String pathname, int depth) {
        if (depth == 0) {
            return;
        }
        --depth;
        File file = new File(pathname);
        if (!file.isDirectory()) {
            return;
        }
        File[] files = this.listFiles(file);
        int num_files = files.length;
        for (int i = 0; i < num_files; ++i) {
            File f = files[i];
            if (!f.isDirectory()) continue;
            try {
                String path = f.getCanonicalPath();
                this.addDirectory(path);
                this.scan(path, depth);
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public void scan(String[] pathnames) {
        this.scan(pathnames, this.MAX_DEPTH);
    }

    public void scan(String[] pathnames, int depth) {
        if (depth == 0) {
            return;
        }
        --depth;
        for (int j = 0; j < pathnames.length; ++j) {
            String pathname = pathnames[j];
            File file = new File(pathname);
            if (!file.isDirectory()) continue;
            File[] files = this.listFiles(file);
            int num_files = files.length;
            for (int i = 0; i < num_files; ++i) {
                File f = files[i];
                if (!f.isDirectory()) continue;
                try {
                    String subDirPath = f.getCanonicalPath();
                    this.addDirectory(subDirPath);
                    this.scan(subDirPath);
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    private void addDirectory(String pathname) {
        File dir = new File(pathname);
        if (!dir.isDirectory()) {
            return;
        }
        int mem = 0;
        int num = 0;
        if (!this.hasFilter(pathname)) {
            File[] files = this.listFiles(dir);
            int num_files = files.length;
            for (int i = 0; i < num_files; ++i) {
                File f = files[i];
                String name = f.getName();
                if (!this.hasExtension(name)) continue;
                mem = (int)((long)mem + f.length());
                ++num;
            }
        }
        int key = this.calculateKey(num, mem);
        this._list.add(new Pair(key, dir), key);
    }

    private int calculateKey(int num_files, int size_files) {
        int key = num_files * this.NUM_WEIGHT + size_files * this.MEM_WEIGHT;
        return key;
    }

    private boolean hasFilter(String pathname) {
        pathname = pathname.toLowerCase(Locale.US);
        int length = this._filters.length;
        for (int i = 0; i < length; ++i) {
            String curFilter = this._filters[i].toLowerCase(Locale.US);
            if (pathname.indexOf(curFilter) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean hasExtension(String filename) {
        int begin = filename.lastIndexOf(".") + 1;
        if (begin == 0) {
            return false;
        }
        int end = filename.length();
        String ext = filename.substring(begin, end);
        int length = this._extensions.length;
        for (int i = 0; i < length; ++i) {
            if (!ext.equalsIgnoreCase(this._extensions[i])) continue;
            return true;
        }
        return false;
    }

    private File[] listFiles(File dir) {
        String[] fnames = dir.list();
        if (fnames == null) {
            return new File[0];
        }
        File[] theFiles = new File[fnames.length];
        for (int i = 0; i < fnames.length; ++i) {
            theFiles[i] = new File(dir, fnames[i]);
        }
        return theFiles;
    }
}

