/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupLabel;
import com.limegroup.gnutella.gui.init.SetupManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;

abstract class SetupWindow
extends JPanel {
    public static final int SETUP_WIDTH = 500;
    public static final int SETUP_HEIGHT = 300;
    public static final int MARGIN = 10;
    private final int SETUP_LEFT_MARGIN = 20;
    private final JPanel INNER_PANEL = new BoxPanel(1);
    private String _key;
    private String _labelKey;
    private String _name;
    private SetupWindow _next;
    private SetupWindow _previous;
    protected final SetupManager _manager;

    SetupWindow(SetupManager manager, String key, String labelKey) {
        this._manager = manager;
        this._key = key;
        this._labelKey = labelKey;
    }

    protected void createWindow() {
        this.removeAll();
        this.INNER_PANEL.removeAll();
        this._name = GUIMediator.getStringResource(this._key);
        BoxLayout layout = new BoxLayout(this, 1);
        this.setLayout(layout);
        Border border = BorderFactory.createEmptyBorder(20, 10, 10, 10);
        Border innerBorder = BorderFactory.createEmptyBorder(0, 20, 0, 0);
        this.setBorder(border);
        this.INNER_PANEL.setBorder(innerBorder);
        int totalMargin = 20;
        Dimension size = new Dimension(500 - totalMargin, 300 - totalMargin);
        this.setPreferredSize(size);
        SetupLabel setupLabel = new SetupLabel(this._labelKey);
        this.add(setupLabel);
        this.add(this.INNER_PANEL);
    }

    public String getName() {
        return this._name;
    }

    public String getKey() {
        return this._key;
    }

    protected void setLabelKey(String newKey) {
        this._labelKey = newKey;
    }

    public SetupWindow getNext() {
        return this._next;
    }

    public SetupWindow getPrevious() {
        return this._previous;
    }

    public void setNext(SetupWindow next) {
        this._next = next;
    }

    public void setPrevious(SetupWindow previous) {
        this._previous = previous;
    }

    public void handleWindowOpeningEvent() {
        this.createWindow();
        if (this._next == this) {
            this._manager.goToFinishButtons();
        } else if (this._previous == this) {
            this._manager.goToNextButtons();
        } else {
            this._manager.goToStandardButtons();
        }
    }

    public void applySettings() throws ApplySettingsException {
    }

    protected void addSetupComponent(Component setupComponent) {
        this.INNER_PANEL.add(setupComponent);
    }
}

