/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

final class HelpMenu
extends AbstractMenu {
    HelpMenu(String key) {
        super(key);
        this.addMenuItem("HELP_USING_LIMEWIRE", new LinkListener("http://www.limewire.com/support.htm"));
        this.addMenuItem("HELP_TOTD", new TOTDListener());
        this.addMenuItem("HELP_FAQ", new LinkListener("http://www.limewire.com/support/faq.htm"));
        this.addMenuItem("HELP_FORUM", new LinkListener("http://www.limewire.com/forum.htm"));
        if (!CommonUtils.isMacOSX()) {
            this.addSeparator();
            this.addMenuItem("HELP_ABOUT", new AboutListener());
        }
        if (CommonUtils.isTestingVersion()) {
            this.addSeparator();
            this.addMenuItem("HELP_ERROR", new ErrorListener());
        }
    }

    private static class AboutListener
    implements ActionListener {
        private AboutListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GUIMediator.showAboutWindow();
        }
    }

    private static class LinkListener
    implements ActionListener {
        private final String link;

        private LinkListener(String link) {
            this.link = link;
        }

        public void actionPerformed(ActionEvent e) {
            GUIMediator.openURL(this.link);
        }
    }

    private static class ErrorListener
    implements ActionListener {
        private ErrorListener() {
        }

        public void actionPerformed(ActionEvent e) {
            throw new RuntimeException("Generated Error");
        }
    }

    private static class TOTDListener
    implements ActionListener {
        private TOTDListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TipOfTheDayMediator.instance().displayTipWindow();
        }
    }
}

