/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

final class ThemeMenu
extends AbstractMenu {
    private static final String THEME_PROPERTY = "THEME_NAME";
    private static final ActionListener THEME_CHANGER = new ThemeChangeListener();
    private static final ButtonGroup GROUP = new ButtonGroup();

    ThemeMenu(String key) {
        super(key);
        this.addMenuItem("VIEW_THEMES_GET_MORE", new GetThemesListener());
        this.addMenuItem("VIEW_THEMES_REFRESH", new RefreshThemesListener());
        JMenuItem def = this.addMenuItem("VIEW_THEMES_USE_DEFAULT", THEME_CHANGER);
        final String defaultVal = ThemeSettings.THEME_DEFAULT.getAbsolutePath();
        def.putClientProperty(THEME_PROPERTY, defaultVal);
        def.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ThemeMenu.setSelection(defaultVal);
            }
        });
        this.addSeparator();
        this.addThemeItems();
    }

    private static void setSelection(Object value) {
        Enumeration<AbstractButton> items = GROUP.getElements();
        while (items.hasMoreElements()) {
            JMenuItem item = (JMenuItem)items.nextElement();
            if (!value.equals(item.getClientProperty(THEME_PROPERTY))) continue;
            item.setSelected(true);
            break;
        }
    }

    private void addThemeItems() {
        File themeDir = ThemeSettings.THEME_DIR_FILE;
        if (!themeDir.exists()) {
            return;
        }
        String[] allThemes = themeDir.list(new ThemeFileFilter());
        if (allThemes == null) {
            return;
        }
        for (int i = 0; i < allThemes.length; ++i) {
            File themeFile = new File(themeDir, allThemes[i]);
            JRadioButtonMenuItem theme = new JRadioButtonMenuItem(ThemeSettings.formatName(themeFile.getName()));
            theme.setFont(AbstractMenu.FONT);
            GROUP.add(theme);
            if (themeFile.equals(ThemeSettings.THEME_FILE.getValue())) {
                theme.setSelected(true);
            }
            theme.addActionListener(THEME_CHANGER);
            theme.putClientProperty(THEME_PROPERTY, themeFile.getAbsolutePath());
            this.MENU.add(theme);
        }
    }

    private void removeThemeItems() {
        Enumeration<AbstractButton> items = GROUP.getElements();
        LinkedList<JMenuItem> removed = new LinkedList<JMenuItem>();
        while (items.hasMoreElements()) {
            JMenuItem item = (JMenuItem)items.nextElement();
            this.MENU.remove(item);
            removed.add(item);
        }
        Iterator itr = removed.iterator();
        while (itr.hasNext()) {
            GROUP.remove((JMenuItem)itr.next());
        }
    }

    public static class ThemeFileFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            if (!name.endsWith("lwtp")) {
                return false;
            }
            if (name.startsWith("default_")) {
                return false;
            }
            if (!CommonUtils.isMacOSX() && name.equals("pinstripes_theme_osx.lwtp")) {
                return false;
            }
            if (!(!name.equals("brushed_metal_theme_osx.lwtp") || CommonUtils.isPantherOrAbove() && CommonUtils.isJava14OrLater())) {
                return false;
            }
            if (!CommonUtils.isWindows() && name.equals("windows_theme.lwtp")) {
                return false;
            }
            if (!CommonUtils.isPro() && name.equals("limewirePro_theme.lwtp")) {
                return false;
            }
            return !name.equals("GTK_theme.lwtp") || CommonUtils.isLinux() && CommonUtils.isJava15OrLater();
        }
    }

    protected static class ThemeChangeListener
    implements ActionListener {
        protected ThemeChangeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            String themePath = (String)item.getClientProperty(ThemeMenu.THEME_PROPERTY);
            File themeFile = new File(themePath);
            File oldTheme = ThemeSettings.THEME_FILE.getValue();
            ThemeMediator.changeTheme(themeFile);
        }
    }

    private class RefreshThemesListener
    implements ActionListener {
        private RefreshThemesListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ThemeMenu.this.removeThemeItems();
            ThemeMenu.this.addThemeItems();
        }
    }

    private static class GetThemesListener
    implements ActionListener {
        private GetThemesListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String url = "http://www.limewire.com/skins2";
            GUIMediator.openURL(url);
        }
    }
}

