/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.settings.SearchSettings;
import java.awt.Toolkit;
import java.util.Arrays;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class SearchField
extends AutoCompleteTextField {
    private static final char[] ILLEGAL_CHARS = SearchSettings.ILLEGAL_CHARS.getValue();
    private static final int MAX_QUERY_LENGTH = SearchSettings.MAX_QUERY_LENGTH.getValue();
    private static final Toolkit TOOLKIT;

    public SearchField() {
    }

    public SearchField(int columns) {
        super(columns);
    }

    protected Document createDefaultModel() {
        return new SearchFieldDocument();
    }

    static {
        Arrays.sort(ILLEGAL_CHARS);
        TOOLKIT = Toolkit.getDefaultToolkit();
    }

    private static class SearchFieldDocument
    extends PlainDocument {
        private SearchFieldDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                super.insertString(offs, str, a);
                return;
            }
            if (offs >= MAX_QUERY_LENGTH) {
                TOOLKIT.beep();
                return;
            }
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Arrays.binarySearch(ILLEGAL_CHARS, source[i]) < 0) {
                    result[j++] = source[i];
                    continue;
                }
                TOOLKIT.beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

