/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.I18NConvert;
import java.util.Collections;
import java.util.Set;

final class SearchResult {
    private final RemoteFileDesc RFD;
    private final HostData DATA;
    private Set _alts;
    private String processedFilename = null;

    SearchResult(RemoteFileDesc rfd, HostData data, Set alts) {
        this.RFD = rfd;
        this.DATA = data;
        this._alts = UISettings.UI_ADD_REPLY_ALT_LOCS.getValue() ? alts : Collections.EMPTY_SET;
    }

    RemoteFileDesc getRemoteFileDesc() {
        return this.RFD;
    }

    HostData getHostData() {
        return this.DATA;
    }

    Set getAlts() {
        return this._alts;
    }

    void clearAlts() {
        this._alts = null;
    }

    void setAlts(Set alts) {
        this._alts = alts;
    }

    int getSize() {
        return this.RFD.getSize();
    }

    String getFilenameNoExtension() {
        String fullname = this.RFD.getFileName();
        int i = fullname.lastIndexOf(".");
        if (i < 0) {
            return fullname;
        }
        return I18NConvert.instance().compose(fullname.substring(0, i));
    }

    String getExtension() {
        String fullname = this.RFD.getFileName();
        int i = fullname.lastIndexOf(".");
        if (i < 0) {
            return "";
        }
        return fullname.substring(i + 1);
    }

    private String getProcessedFilename(ApproximateMatcher matcher) {
        if (this.processedFilename != null) {
            return this.processedFilename;
        }
        this.processedFilename = matcher.process(this.getFilenameNoExtension());
        return this.processedFilename;
    }

    int match(SearchResult o, ApproximateMatcher matcher) {
        long thatSize;
        if (!this.getExtension().equals(o.getExtension())) {
            return 1;
        }
        long thisSize = this.getSize();
        if (thisSize != (thatSize = (long)o.getSize())) {
            return 2;
        }
        this.getProcessedFilename(matcher);
        o.getProcessedFilename(matcher);
        int allowedDifferences = Math.round(Math.min(0.1f * (float)this.getFilenameNoExtension().length(), 0.1f * (float)o.getFilenameNoExtension().length()));
        allowedDifferences = Math.min(allowedDifferences, 4);
        if (!matcher.matches(this.getProcessedFilename(matcher), o.getProcessedFilename(matcher), allowedDifferences)) {
            return 3;
        }
        return 0;
    }
}

