/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.gui.search.EndpointHolder;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameHolderImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public final class TableLine
extends AbstractDataLine {
    private final SearchTableColumns COLUMNS;
    private SearchResult RESULT;
    private List _otherResults;
    private URN _sha1;
    private NamedMediaType _mediaType;
    private Set _alts;
    private boolean _savedFile;
    private boolean _incompleteFile;
    private boolean _downloading;
    private ResultSpeed _speed = null;
    private int _quality;
    private boolean _chatEnabled;
    private boolean _browseHostEnabled;
    private LimeXMLDocument _doc;
    private EndpointHolder _location = null;
    private long _addedOn;
    private int _licenseState = -1;

    public TableLine(SearchTableColumns stc) {
        this.COLUMNS = stc;
    }

    public void initialize(Object init) {
        super.initialize(init);
        SearchResult sr = (SearchResult)init;
        RemoteFileDesc rfd = sr.getRemoteFileDesc();
        HostData data = sr.getHostData();
        Set alts = sr.getAlts();
        this.RESULT = sr;
        this._doc = rfd.getXMLDoc();
        this._sha1 = rfd.getSHA1Urn();
        this._mediaType = this._doc != null ? NamedMediaType.getFromDescription(this._doc.getSchemaDescription()) : NamedMediaType.getFromExtension(this.getExtension());
        this._speed = new ResultSpeed(rfd.getSpeed(), data.isMeasuredSpeed());
        this._quality = rfd.getQuality();
        this._chatEnabled = rfd.chatEnabled();
        this._browseHostEnabled = rfd.browseHostEnabled();
        this._location = new EndpointHolder(rfd.getHost(), rfd.getPort(), rfd.isReplyToMulticast());
        this._addedOn = rfd.getCreationTime();
        if (alts != null && !alts.isEmpty()) {
            if (this._alts == null) {
                this._alts = new HashSet();
            }
            this._alts.addAll(alts);
            sr.clearAlts();
            this._location.addHosts(alts);
        }
        this.updateLicense();
        this.updateFileStatus();
    }

    void addNewResult(SearchResult sr, MetadataModel mm) {
        RemoteFileDesc rfd = sr.getRemoteFileDesc();
        HostData data = sr.getHostData();
        Set alts = sr.getAlts();
        URN resultSHA1 = this.RESULT.getRemoteFileDesc().getSHA1Urn();
        URN thisSHA1 = rfd.getSHA1Urn();
        if (resultSHA1 == null) {
            Assert.that(thisSHA1 == null);
        } else {
            Assert.that(resultSHA1.equals(thisSHA1));
        }
        if (this._otherResults == null) {
            this._otherResults = new LinkedList();
        }
        this._otherResults.add(sr);
        if (alts != null && !alts.isEmpty()) {
            if (this._alts == null) {
                this._alts = new HashSet();
            }
            this._alts.addAll(alts);
            sr.clearAlts();
            this._location.addHosts(alts);
        }
        this._location.addHost(rfd.getHost(), rfd.getPort());
        ResultSpeed newSpeed = new ResultSpeed(rfd.getSpeed(), data.isMeasuredSpeed());
        if (this._speed.compareTo(newSpeed) < 0) {
            if (mm != null) {
                mm.updateProperty("RESULT_PANEL_SPEED", this._speed, newSpeed, this);
            }
            this._speed = newSpeed;
        }
        this._quality = Math.max(rfd.getQuality(), this._quality);
        if (rfd.getCreationTime() > 0L) {
            this._addedOn = Math.min(this._addedOn, rfd.getCreationTime());
        }
        this._chatEnabled |= rfd.chatEnabled();
        this._browseHostEnabled |= rfd.browseHostEnabled();
        this.updateXMLDocument(rfd.getXMLDoc(), mm);
    }

    private void updateXMLDocument(LimeXMLDocument newDoc, MetadataModel mm) {
        HashSet newKeys;
        if (newDoc == null) {
            return;
        }
        if (this._doc == null) {
            this._doc = newDoc;
            this.updateLicense();
            if (mm != null) {
                this._mediaType = NamedMediaType.getFromDescription(this._doc.getSchemaDescription());
                mm.addNewDocument(this._doc, this);
            }
            return;
        }
        if (!this._doc.getSchemaURI().equals(newDoc.getSchemaURI())) {
            return;
        }
        Set oldKeys = this._doc.getNameSet();
        if (oldKeys.containsAll(newKeys = newDoc.getNameSet())) {
            return;
        }
        newKeys = new HashSet(newKeys);
        newKeys.removeAll(oldKeys);
        HashMap newMap = new HashMap(oldKeys.size() + newKeys.size());
        Iterator i = this._doc.getNameValueSet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            newMap.put(entry.getKey(), entry.getValue());
        }
        i = newKeys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = newDoc.getValue(key);
            newMap.put(key, value);
            if (mm == null) continue;
            mm.addField(key, value, this);
        }
        this._doc = new LimeXMLDocument(newMap.entrySet(), this._doc.getSchemaURI());
        this.updateLicense();
    }

    private void updateFileStatus() {
        if (this._sha1 != null) {
            this._savedFile = RouterService.getFileManager().isUrnShared(this._sha1);
            this._incompleteFile = RouterService.getDownloadManager().isIncomplete(this._sha1);
        } else {
            this._savedFile = false;
            this._incompleteFile = false;
        }
        if (!this._savedFile) {
            this._savedFile = SavedFileManager.instance().isSaved(this._sha1, this.getFilename());
        }
    }

    public void update() {
        this.updateLicense();
    }

    private void updateLicense() {
        String licenseString;
        if (this._doc != null && this._sha1 != null && (licenseString = this._doc.getLicenseString()) != null) {
            this._licenseState = LicenseFactory.isVerifiedAndValid(this._sha1, licenseString) ? 2 : 0;
        }
    }

    boolean isLicenseAvailable() {
        return this._licenseState != -1;
    }

    License getLicense() {
        String licenseString;
        if (this._doc != null && this._sha1 != null && (licenseString = this._doc.getLicenseString()) != null) {
            return LicenseFactory.create(licenseString);
        }
        return null;
    }

    URN getSHA1Urn() {
        return this._sha1;
    }

    ResultSpeed getSpeed() {
        return this._speed;
    }

    Date getAddedOn() {
        if (this._addedOn > 0L) {
            return new Date(this._addedOn);
        }
        return null;
    }

    int getQuality() {
        RemoteFileDesc rfd = this.RESULT.getRemoteFileDesc();
        boolean downloading = rfd.isDownloading();
        if (downloading != this._downloading) {
            this.updateFileStatus();
        }
        this._downloading = downloading;
        if (this._savedFile) {
            return 1002;
        }
        if (downloading) {
            return 1001;
        }
        if (this._incompleteFile) {
            return 1000;
        }
        return this._quality;
    }

    NamedMediaType getNamedMediaType() {
        return this._mediaType;
    }

    LimeXMLDocument getXMLDocument() {
        return this._doc;
    }

    EndpointHolder getLocation() {
        return this._location;
    }

    List getOtherResults() {
        return this._otherResults == null ? Collections.EMPTY_LIST : this._otherResults;
    }

    Set getAlts() {
        return this._alts == null ? Collections.EMPTY_SET : this._alts;
    }

    int getLocationCount() {
        return this._location.numLocations();
    }

    boolean isChatEnabled() {
        return this._chatEnabled;
    }

    boolean isBrowseHostEnabled() {
        return this._browseHostEnabled;
    }

    boolean isLaunchable() {
        return this._doc != null && this._doc.getAction() != null && !"".equals(this._doc.getAction());
    }

    String getFilenameNoExtension() {
        return this.RESULT.getFilenameNoExtension();
    }

    IconAndNameHolder getIconAndExtension() {
        String ext = this.getExtension();
        return new IconAndNameHolderImpl(IconManager.instance().getIconForExtension(ext), ext);
    }

    Icon getIcon() {
        String ext = this.getExtension();
        return IconManager.instance().getIconForExtension(ext);
    }

    String getExtension() {
        return this.RESULT.getExtension();
    }

    String getFilename() {
        return this.RESULT.getRemoteFileDesc().getFileName();
    }

    int getSize() {
        return this.RESULT.getSize();
    }

    String getVendor() {
        return this.RESULT.getRemoteFileDesc().getVendor();
    }

    public LimeTableColumn getColumn(int idx) {
        return this.COLUMNS.getColumn(idx);
    }

    public int getColumnCount() {
        return SearchTableColumns.COLUMN_COUNT;
    }

    public boolean isDynamic(int idx) {
        return false;
    }

    public boolean isClippable(int idx) {
        switch (idx) {
            case 0: 
            case 1: 
            case 2: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    public int getTypeAheadColumn() {
        return 3;
    }

    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return new Integer(this.getQuality());
            }
            case 1: {
                int count = this._location.numLocations();
                if (count == 1) {
                    return null;
                }
                return new Integer(count);
            }
            case 2: {
                return this.getIcon();
            }
            case 3: {
                return this.getFilenameNoExtension();
            }
            case 4: {
                return this.getExtension();
            }
            case 5: {
                return new SizeHolder(this.getSize());
            }
            case 6: {
                return this.getSpeed();
            }
            case 7: {
                return this._chatEnabled ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.getLocation();
            }
            case 9: {
                return this.RESULT.getRemoteFileDesc().getVendor();
            }
            case 10: {
                return this.getAddedOn();
            }
            case 11: {
                return new Integer(this._licenseState);
            }
        }
        if (this._doc == null) {
            return null;
        }
        LimeTableColumn ltc = this.getColumn(index);
        return this._doc.getValue(ltc.getId());
    }

    public String[] getToolTipArray(int col) {
        if (col == 2 && CommonUtils.isWindows()) {
            Icon icon = this.getIcon();
            if (icon != null) {
                return new String[]{icon.toString()};
            }
            return null;
        }
        if (col == 8 && this.getLocationCount() > 1) {
            StringBuffer sb = new StringBuffer(69);
            LinkedList<String> retList = new LinkedList<String>();
            Iterator iter = this._location.getHosts().iterator();
            int i = 0;
            while (iter.hasNext()) {
                if (i == 3) {
                    i = 0;
                    retList.add(sb.toString());
                    sb = new StringBuffer(69);
                }
                sb.append(iter.next());
                if (iter.hasNext()) {
                    sb.append(", ");
                } else {
                    retList.add(sb.toString());
                }
                ++i;
            }
            return retList.toArray(new String[retList.size()]);
        }
        if (this._doc == null) {
            return null;
        }
        boolean found = true;
        LinkedList<String> data = new LinkedList<String>();
        String schemaDesc = this._doc.getSchemaDescription();
        List nameValues = this._doc.getOrderedNameValueList();
        Iterator j = nameValues.iterator();
        while (j.hasNext()) {
            found = true;
            NameValue nv = (NameValue)j.next();
            data.add(DisplayManager.instance().getDisplayName(nv.getName(), schemaDesc) + ": " + nv.getValue());
        }
        if (found) {
            data.add(0, this.getFilenameNoExtension());
            return data.toArray(new String[data.size()]);
        }
        return null;
    }

    String getHostname() {
        return this.RESULT.getRemoteFileDesc().getHost();
    }

    RemoteFileDesc[] getAllRemoteFileDescs() {
        int size = this.getOtherResults().size() + 1;
        RemoteFileDesc[] rfds = new RemoteFileDesc[size];
        rfds[0] = this.RESULT.getRemoteFileDesc();
        int j = 1;
        Iterator i = this.getOtherResults().iterator();
        while (i.hasNext()) {
            rfds[j] = ((SearchResult)i.next()).getRemoteFileDesc();
            ++j;
        }
        return rfds;
    }

    void doChat() {
        String host = null;
        int port = -1;
        RemoteFileDesc rfd = this.RESULT.getRemoteFileDesc();
        if (rfd.chatEnabled()) {
            host = rfd.getHost();
            port = rfd.getPort();
        } else {
            Iterator i = this.getOtherResults().iterator();
            while (i.hasNext()) {
                SearchResult next = (SearchResult)i.next();
                rfd = next.getRemoteFileDesc();
                if (!rfd.chatEnabled()) continue;
                host = rfd.getHost();
                port = rfd.getPort();
                break;
            }
        }
        if (host == null || port == -1) {
            return;
        }
        RouterService.createChat(host, port);
    }

    RemoteFileDesc getBrowseHostEnabledRFD() {
        RemoteFileDesc rfd = this.RESULT.getRemoteFileDesc();
        if (rfd.browseHostEnabled()) {
            return rfd;
        }
        Iterator i = this.getOtherResults().iterator();
        while (i.hasNext()) {
            SearchResult next = (SearchResult)i.next();
            rfd = next.getRemoteFileDesc();
            if (!rfd.browseHostEnabled()) continue;
            return rfd;
        }
        return null;
    }
}

