/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.gui.statistics.StatisticsPane;
import com.limegroup.gnutella.gui.statistics.StatisticsPaneParent;
import com.limegroup.gnutella.gui.statistics.StatisticsTreeNode;
import java.io.IOException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

final class StatisticsTreeModel {
    private DefaultTreeModel _treeModel;
    private final StatisticsTreeNode ROOT = new StatisticsTreeNode(new StatisticsPaneParent("STATISTICS_ROOT_NODE"), "");

    StatisticsTreeModel() {
        this._treeModel = new DefaultTreeModel(this.ROOT);
    }

    void addNode(String parentKey, StatisticsPane pane) {
        MutableTreeNode parentNode;
        StatisticsTreeNode newNode = new StatisticsTreeNode(pane);
        try {
            parentNode = this.getParentNode(this.ROOT, parentKey);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (parentNode == null) {
            return;
        }
        this._treeModel.insertNodeInto(newNode, parentNode, parentNode.getChildCount());
        this._treeModel.reload(parentNode);
    }

    void removeAllChildren(String parentKey) {
        try {
            MutableTreeNode parentNode = this.getParentNode(this.ROOT, parentKey);
            for (int i = this._treeModel.getChildCount(parentNode) - 1; i >= 0; --i) {
                MutableTreeNode child = (MutableTreeNode)this._treeModel.getChild(parentNode, i);
                this._treeModel.removeNodeFromParent(child);
            }
            this._treeModel.reload();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final MutableTreeNode getParentNode(MutableTreeNode node, String parentKey) throws IOException {
        if (parentKey == "STATISTICS_ROOT_NODE") {
            return this.ROOT;
        }
        int length = node.getChildCount();
        for (int i = 0; i < length; ++i) {
            StatisticsTreeNode curNode = (StatisticsTreeNode)node.getChildAt(i);
            if (curNode.getTitleKey().equals(parentKey)) {
                return curNode;
            }
            MutableTreeNode toReturn = this.getParentNode(curNode, parentKey);
            if (toReturn != null) {
                return toReturn;
            }
            if (!curNode.isRoot() || i != length - 1) continue;
            String msg = "Parent node not in statistics tree.";
            throw new IOException(msg);
        }
        return null;
    }

    final TreeModel getTreeModel() {
        return this._treeModel;
    }
}

