/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ColumnSelectionMenu {
    protected static final String COLUMN_ID = "columnId";
    protected static final String SETTING = "setting";
    protected static final ActionListener SETTING_LISTENER = new SettingListener();
    private static final String REVERT_DEFAULT = GUIMediator.getStringResource("GENERAL_REVERT_TO_DEFAULT");
    public static final String MORE_OPTIONS = GUIMediator.getStringResource("GENERAL_MORE_OPTIONS");
    public static final String ROWSTRIPE = GUIMediator.getStringResource("TABLES_USE_ROWSTRIPE");
    public static final String SORTING = GUIMediator.getStringResource("TABLES_REAL_TIME_SORTING");
    public static final String TOOLTIPS = GUIMediator.getStringResource("TABLES_DISPLAY_TOOLTIPS");
    protected final JPopupMenu _menu = new JPopupMenu();
    private final LimeJTable _table;

    public ColumnSelectionMenu(LimeJTable table) {
        this._table = table;
        DataLineModel model = (DataLineModel)this._table.getModel();
        ReverterListener reverter = new ReverterListener();
        JMenuItem revert = new JMenuItem(REVERT_DEFAULT);
        ColumnPreferenceHandler cph = this._table.getColumnPreferenceHandler();
        TableSettings settings = this._table.getTableSettings();
        if ((cph == null || cph.isDefault()) && (settings == null || settings.isDefault())) {
            revert.setEnabled(false);
        } else {
            revert.addActionListener(reverter);
        }
        this._menu.add(revert);
        if (settings != null) {
            JMenu options = ColumnSelectionMenu.createMoreOptions(settings);
            this._menu.add(options);
        }
        this._menu.addSeparator();
        this.addTableColumnChoices(new SelectionActionListener(), model, table);
    }

    protected void addTableColumnChoices(ActionListener listener, DataLineModel model, LimeJTable table) {
        for (int i = 0; i < model.getColumnCount(); ++i) {
            JMenuItem item = this.createColumnMenuItem(listener, model, table, i);
            this._menu.add(item);
        }
    }

    protected JMenuItem createColumnMenuItem(ActionListener listener, DataLineModel model, LimeJTable table, int i) {
        Object id = model.getColumnId(i);
        String name = model.getColumnName(i);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(name, table.isColumnVisible(id));
        item.putClientProperty(COLUMN_ID, id);
        item.addActionListener(listener);
        return item;
    }

    public static JMenu createMoreOptions(TableSettings settings) {
        JMenu options = new JMenu(MORE_OPTIONS);
        ColumnSelectionMenu.addSetting(options, ROWSTRIPE, settings.ROWSTRIPE);
        ColumnSelectionMenu.addSetting(options, SORTING, settings.REAL_TIME_SORT);
        ColumnSelectionMenu.addSetting(options, TOOLTIPS, settings.DISPLAY_TOOLTIPS);
        return options;
    }

    public static JMenuItem addSetting(JMenu parent, String name, BooleanSetting setting) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(name, setting.getValue());
        item.putClientProperty(SETTING, setting);
        item.addActionListener(SETTING_LISTENER);
        parent.add(item);
        return item;
    }

    public JPopupMenu getComponent() {
        return this._menu;
    }

    protected static class SettingListener
    implements ActionListener {
        protected SettingListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
            BooleanSetting setting = (BooleanSetting)item.getClientProperty(ColumnSelectionMenu.SETTING);
            setting.setValue(item.getState());
        }
    }

    protected class ReverterListener
    implements ActionListener {
        protected ReverterListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ColumnSelectionMenu.this._table.getColumnPreferenceHandler().revertToDefault();
            ColumnSelectionMenu.this._table.getTableSettings().revertToDefault();
        }
    }

    protected class SelectionActionListener
    implements ActionListener {
        protected SelectionActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
            try {
                ColumnSelectionMenu.this._table.setColumnVisible(item.getClientProperty(ColumnSelectionMenu.COLUMN_ID), item.getState());
                ColumnSelectionMenu.this._table.getTableHeader().setDraggedColumn(null);
            }
            catch (LastColumnException ee) {
                GUIMediator.showError("ERROR_REMOVE_LAST_COL", QuestionsHandler.REMOVE_LAST_COLUMN);
            }
        }
    }
}

