/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public final class ProgressBarRenderer
extends JProgressBar
implements TableCellRenderer,
ThemeObserver {
    private Border _selectedBorder;
    private Border _unselectedBorder;
    private Map borders = new HashMap();

    public ProgressBarRenderer() {
        ThemeMediator.addThemeObserver(this);
        this.setStringPainted(true);
        Font font = this.getFont();
        Font newFont = font == null || font.getName() == null ? new Font("Dialog", 1, 9) : new Font(font.getName(), 1, 9);
        this.setFont(newFont);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this._unselectedBorder = this.getCachedOrNewBorder(c);
        if (this._unselectedBorder != null) {
            this.setBorder(this._unselectedBorder);
        }
    }

    public void updateTheme() {
        this._selectedBorder = null;
        this._unselectedBorder = null;
        this.borders.clear();
    }

    public Border getCachedOrNewBorder(Color c) {
        if (c == null) {
            return null;
        }
        if (this.borders == null) {
            return null;
        }
        Border b = (Border)this.borders.get(c);
        if (b == null) {
            b = BorderFactory.createMatteBorder(2, 5, 2, 5, c);
            this.borders.put(c, b);
        }
        return b;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        int v = value == null ? 0 : (Integer)value;
        String s = Integer.toString(v) + "%";
        this.setValue(v);
        this.setString(s);
        if (this._selectedBorder == null && this._unselectedBorder == null) {
            Color sc = table.getSelectionBackground();
            Color uc = ((LimeJTable)table).getBackgroundForRow(row);
            this._selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, sc);
            this._unselectedBorder = this.getCachedOrNewBorder(uc);
        }
        if (isSel) {
            this.setBorder(this._selectedBorder);
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBorder(this._unselectedBorder);
        }
        return this;
    }

    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        JComponent jp = (JComponent)p;
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && jp.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

