/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;

public class HeaderUpdateVendorMessage
extends VendorMessage {
    public static final int VERSION = 1;
    private Properties _headers;

    protected HeaderUpdateVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 25, version, payload);
        if (this.getVersion() == 1 && (payload == null || payload.length == 0)) {
            throw new BadPacketException();
        }
        this._headers = new Properties();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(payload);
            this._headers.load(bais);
        }
        catch (IOException bad) {
            throw new BadPacketException(bad.getMessage());
        }
    }

    public HeaderUpdateVendorMessage(Properties props) {
        super(F_LIME_VENDOR_ID, 25, 1, HeaderUpdateVendorMessage.derivePayload(props));
        this._headers = props;
    }

    private static byte[] derivePayload(Properties props) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.save(baos, null);
        return baos.toByteArray();
    }

    public Properties getProperties() {
        return this._headers;
    }
}

