/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.JOrbisException;
import com.jcraft.jorbis.VorbisFile;
import com.limegroup.gnutella.metadata.AudioMetaData;
import java.io.File;
import java.io.IOException;

public class OGGMetaData
extends AudioMetaData {
    public static final String TITLE_TAG = "title";
    public static final String TRACK_TAG = "tracknumber";
    public static final String ALBUM_TAG = "album";
    public static final String GENRE_TAG = "genre";
    public static final String DATE_TAG = "date";
    public static final String COMMENT_TAG = "comment";
    public static final String ARTIST_TAG = "artist";
    public static final String LICENSE_TAG = "license";

    public OGGMetaData(File f) throws IOException {
        super(f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseFile(File file) throws IOException {
        VorbisFile vfile;
        block10: {
            vfile = null;
            try {
                try {
                    vfile = new VorbisFile(file.getAbsolutePath());
                }
                catch (JOrbisException failed) {
                    throw new IOException(failed.getMessage());
                }
                Object var6_3 = null;
                if (vfile == null) break block10;
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                if (vfile == null) throw throwable;
                try {
                    vfile.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignored) {}
            vfile.close();
        }
        this.setBitrate(vfile.bitrate(-1) / 1024);
        this.setLength((int)vfile.time_total(-1));
        Comment[] comments = vfile.getComment();
        if (comments.length <= 0) return;
        if (comments[0] == null) return;
        this.setTitle(this.safeQuery(TITLE_TAG, comments[0]));
        this.setArtist(this.safeQuery(ARTIST_TAG, comments[0]));
        this.setAlbum(this.safeQuery(ALBUM_TAG, comments[0]));
        this.setComment(this.safeQuery(COMMENT_TAG, comments[0]));
        this.setGenre(this.safeQuery(GENRE_TAG, comments[0]));
        this.setLicense(this.safeQuery(LICENSE_TAG, comments[0]));
        String year = this.safeQuery(DATE_TAG, comments[0]);
        if (year.length() > 4) {
            year = year.substring(4);
        }
        this.setYear(year);
        try {
            short track = Short.parseShort(this.safeQuery(TRACK_TAG, comments[0]));
            this.setTrack(track);
            return;
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
    }

    private String safeQuery(String tag, Comment comment) {
        String res = comment.query(tag);
        return res == null ? "" : res;
    }
}

