/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UserManager {
    private Map _userMap = new HashMap();
    private static UserManager _instance = new UserManager();

    public static UserManager instance() {
        return _instance;
    }

    private void initialize() {
        try {
            this._userMap = UserManager.readUserMap();
        }
        catch (Exception e) {
            this._userMap = new HashMap();
        }
    }

    private UserManager() {
        this.initialize();
    }

    private static void writeUserMap(Map userMap) throws IOException, ClassNotFoundException {
        FileUtils.writeMap(LimeXMLProperties.instance().getUserMapFile(), userMap);
    }

    private static Map readUserMap() throws IOException, ClassNotFoundException {
        return FileUtils.readMap(LimeXMLProperties.instance().getUserMapFile());
    }

    public synchronized User getUser(String username) {
        return (User)this._userMap.get(username);
    }

    public synchronized void putUser(User user) {
        this._userMap.put(user.getUsername(), user);
    }

    public synchronized String[] getAllUsers() {
        return this._userMap.keySet().toArray(new String[0]);
    }

    public synchronized void removeUser(String username) {
        this._userMap.remove(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            Map clone;
            UserManager userManager = this;
            synchronized (userManager) {
                clone = (Map)((HashMap)this._userMap).clone();
            }
            UserManager.writeUserMap(clone);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        return this._userMap.toString();
    }

    public static void main(String[] args) {
        System.out.println(UserManager.instance().toString());
    }
}

