/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.simpp.SimppManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimppSettingsManager {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$settings$SimppSettingsManager == null ? (class$com$limegroup$gnutella$settings$SimppSettingsManager = SimppSettingsManager.class$("com.limegroup.gnutella.settings.SimppSettingsManager")) : class$com$limegroup$gnutella$settings$SimppSettingsManager);
    private Properties _simppProps;
    private final HashMap _userPrefs;
    private final HashMap _remainderSimppSettings;
    private boolean _usingUserPrefs = true;
    private static SimppSettingsManager INSTANCE;
    static /* synthetic */ Class class$com$limegroup$gnutella$settings$SimppSettingsManager;

    private SimppSettingsManager() {
        String simppSettings = SimppManager.instance().getPropsString();
        if (simppSettings == null) {
            throw new IllegalArgumentException("SimppManager unexpected state");
        }
        this._userPrefs = new HashMap();
        this._remainderSimppSettings = new HashMap();
        this.updateSimppSettings(simppSettings);
    }

    public static synchronized SimppSettingsManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new SimppSettingsManager();
        }
        return INSTANCE;
    }

    public void updateSimppSettings(String simppSettings) {
        byte[] settings = null;
        try {
            settings = simppSettings.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            ErrorService.error(uex);
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(settings);
        this._simppProps = new Properties();
        try {
            this._simppProps.load(bais);
        }
        catch (IOException iox) {
            LOG.error("IOX reading simpp properties", iox);
            return;
        }
        this.activateSimppSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateSimppSettings() {
        LOG.debug("activating new settings");
        Properties properties = this._simppProps;
        synchronized (properties) {
            Set<Map.Entry<Object, Object>> set = this._simppProps.entrySet();
            Iterator<Map.Entry<Object, Object>> iter = set.iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> currEntry = iter.next();
                String settingKey = (String)currEntry.getKey();
                Setting simppSetting = this.getSimppSettingForKey(settingKey);
                String simppValue = (String)currEntry.getValue();
                if (simppSetting == null) {
                    this._remainderSimppSettings.put(settingKey, simppValue);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("setting:" + simppSetting);
                    LOG.debug("simpp value:" + simppValue);
                }
                if (!simppSetting.isSimppEnabled()) continue;
                String userSetValue = simppSetting.getValueAsString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("current value:" + userSetValue);
                }
                this._userPrefs.put(simppSetting, userSetValue);
                simppSetting.setValue(simppValue);
            }
        }
        this._usingUserPrefs = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revertToUserPrefs() {
        if (this._usingUserPrefs) {
            return;
        }
        Properties properties = this._simppProps;
        synchronized (properties) {
            Set<Object> set = this._simppProps.keySet();
            Iterator<Object> iter = set.iterator();
            while (iter.hasNext()) {
                Setting currSetting = (Setting)iter.next();
                String userSetValue = (String)this._userPrefs.get(currSetting);
                currSetting.loadValue(userSetValue);
            }
        }
        this._usingUserPrefs = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRemanentSimppValue(String simppKey) {
        Properties properties = this._simppProps;
        synchronized (properties) {
            return (String)this._remainderSimppSettings.remove(simppKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheUserPref(Setting setting, String userPref) {
        Properties properties = this._simppProps;
        synchronized (properties) {
            this._userPrefs.put(setting, userPref);
        }
    }

    private Setting getSimppSettingForKey(String simppKey) {
        LimeProps limeProps = LimeProps.instance();
        return limeProps.getSimppSetting(simppKey);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

