/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.security.SignatureVerifier;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimppDataVerifier {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$simpp$SimppDataVerifier == null ? (class$com$limegroup$gnutella$simpp$SimppDataVerifier = SimppDataVerifier.class$("com.limegroup.gnutella.simpp.SimppDataVerifier")) : class$com$limegroup$gnutella$simpp$SimppDataVerifier);
    private static final byte SEP = 124;
    public final String DSA_ALGORITHM = "DSA";
    private byte[] simppPayload;
    private byte[] verifiedData;
    static /* synthetic */ Class class$com$limegroup$gnutella$simpp$SimppDataVerifier;

    public SimppDataVerifier(byte[] payload) {
        this.simppPayload = payload;
    }

    public boolean verifySource() {
        int sepIndex = SimppDataVerifier.findSeperator(this.simppPayload);
        if (sepIndex < 0) {
            return false;
        }
        byte[] temp = new byte[sepIndex];
        System.arraycopy(this.simppPayload, 0, temp, 0, sepIndex);
        String base32 = null;
        try {
            base32 = new String(temp, "UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            return false;
        }
        byte[] signature = Base32.decode(base32);
        byte[] propsData = new byte[this.simppPayload.length - 1 - sepIndex];
        System.arraycopy(this.simppPayload, sepIndex + 1, propsData, 0, this.simppPayload.length - 1 - sepIndex);
        PublicKey pk = this.getPublicKey();
        if (pk == null) {
            return false;
        }
        String algo = "DSA";
        SignatureVerifier verifier = new SignatureVerifier(propsData, signature, pk, algo);
        boolean ret = verifier.verifySignature();
        if (ret) {
            this.verifiedData = propsData;
        }
        return ret;
    }

    public byte[] getVerifiedData() {
        return this.verifiedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private PublicKey getPublicKey() {
        String base32Enc;
        block14: {
            File pubKeyFile = new File(".", "pub1.key");
            base32Enc = null;
            RandomAccessFile raf = null;
            raf = new RandomAccessFile(pubKeyFile, "r");
            byte[] bytes = new byte[(int)raf.length()];
            raf.readFully(bytes);
            base32Enc = new String(bytes, "UTF-8");
            Object var7_6 = null;
            try {
                if (raf != null) {
                    raf.close();
                }
                break block14;
            }
            catch (IOException iox2) {}
            break block14;
            {
                catch (IOException iox) {
                    LOG.error("IOX reading file", iox);
                    PublicKey publicKey = null;
                    Object var7_7 = null;
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                    catch (IOException iox2) {
                        // empty catch block
                    }
                    return publicKey;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException iox2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        byte[] pubKeyBytes = Base32.decode(base32Enc);
        PublicKey ret = null;
        try {
            KeyFactory factory = KeyFactory.getInstance("DSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubKeyBytes);
            ret = factory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException nsax) {
            LOG.error("no algorithm", nsax);
        }
        catch (InvalidKeySpecException iksx) {
            LOG.error("invalid key", iksx);
        }
        return ret;
    }

    static int findSeperator(byte[] data) {
        int i;
        boolean found = false;
        for (i = 0; i < data.length; ++i) {
            if (data[i] != 124) continue;
            found = true;
            break;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

