/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.udpconnect.AckMessage;
import com.limegroup.gnutella.udpconnect.Chunk;
import com.limegroup.gnutella.udpconnect.DataMessage;
import com.limegroup.gnutella.udpconnect.DataRecord;
import com.limegroup.gnutella.udpconnect.DataWindow;
import com.limegroup.gnutella.udpconnect.FinMessage;
import com.limegroup.gnutella.udpconnect.KeepAliveMessage;
import com.limegroup.gnutella.udpconnect.SequenceNumberExtender;
import com.limegroup.gnutella.udpconnect.SynMessage;
import com.limegroup.gnutella.udpconnect.UDPBufferedInputStream;
import com.limegroup.gnutella.udpconnect.UDPBufferedOutputStream;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.udpconnect.UDPMultiplexor;
import com.limegroup.gnutella.udpconnect.UDPScheduler;
import com.limegroup.gnutella.udpconnect.UDPTimerEvent;
import com.limegroup.gnutella.udpconnect.WriteRegulator;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPConnectionProcessor {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$udpconnect$UDPConnectionProcessor == null ? (class$com$limegroup$gnutella$udpconnect$UDPConnectionProcessor = UDPConnectionProcessor.class$("com.limegroup.gnutella.udpconnect.UDPConnectionProcessor")) : class$com$limegroup$gnutella$udpconnect$UDPConnectionProcessor);
    public static final int DATA_CHUNK_SIZE = 512;
    public static final int MAX_DATA_SIZE = 4096;
    private UDPBufferedOutputStream _inputFromOutputStream;
    private UDPBufferedInputStream _outputToInputStream;
    private Chunk _trailingChunk;
    private volatile int _chunkLimit;
    private volatile int _receiverWindowSpace;
    private long _connectTimeOut = 20000L;
    private int _readTimeOut = 60000;
    private static final IOException CANT_RECEIVE_UDP = new IOException("Can't receive UDP");
    private static final IOException CONNECTION_TIMEOUT = new IOException("Connection timed out");
    private static final int DATA_WINDOW_SIZE = 20;
    private static final int DATA_WRITE_AHEAD_MAX = 25;
    private static final int MAX_SEND_TRIES = 8;
    private UDPService _udpService;
    private UDPMultiplexor _multiplexor;
    private UDPScheduler _scheduler;
    private Acceptor _acceptor;
    private static final long SYN_WAIT_TIME = 400L;
    private static final long MAX_CONNECT_WAIT_TIME = 20000L;
    private static final long KEEPALIVE_WAIT_TIME = 2500L;
    private static final long WRITE_STARTUP_WAIT_TIME = 400L;
    private static final long DEFAULT_RTO_WAIT_TIME = 400L;
    private static final long MAX_MESSAGE_WAIT_TIME = 20000L;
    private static final long MIN_ACK_WAIT_TIME = 5L;
    private static final long SMALL_SEND_WINDOW = 2L;
    private static final long MAX_WRITE_WITHOUT_SLEEP = 4L;
    private static final long WRITE_WAKEUP_DELAY_TIME = 10L;
    private static final long NOTHING_TO_DO_DELAY = 1000L;
    private static final long SHUTDOWN_DELAY_TIME = 400L;
    private static final int PRECONNECT_STATE = 0;
    private static final int CONNECT_STATE = 1;
    private static final int FIN_STATE = 2;
    private final InetAddress _ip;
    private final int _port;
    private DataWindow _sendWindow;
    private WriteRegulator _writeRegulator;
    private DataWindow _receiveWindow;
    private byte _myConnectionID;
    private volatile byte _theirConnectionID;
    private int _connectionState;
    private UDPTimerEvent _keepaliveEvent;
    private UDPTimerEvent _writeDataEvent;
    private UDPTimerEvent _closedCleanupEvent;
    private boolean _waitingForDataSpace;
    private volatile boolean _waitingForDataAvailable;
    private boolean _waitingForFinAck;
    private UDPTimerEvent _ackTimeoutEvent;
    private SafeWriteWakeupTimerEvent _safeWriteWakeup;
    private long _sequenceNumber;
    private long _finSeqNo;
    private SequenceNumberExtender _localExtender;
    private SequenceNumberExtender _extender;
    private long _lastSendTime;
    private long _lastDataSendTime;
    private long _lastReceivedTime;
    private int _ackResendCount;
    private boolean _skipADataWrite;
    private byte _closeReasonCode;
    private final boolean _skipAcks = DownloadSettings.SKIP_ACKS.getValue();
    private final int _period = DownloadSettings.PERIOD_LENGTH.getValue();
    private static final int _periodHistory = DownloadSettings.PERIOD_LENGTH.getValue();
    private final float _deviation = DownloadSettings.DEVIATION.getValue();
    private static final int _maxSkipAck = DownloadSettings.MAX_SKIP_ACKS.getValue();
    private final int[] _periods = new int[_periodHistory];
    private int _currentPeriodId;
    private int _packetsThisPeriod;
    private boolean _enoughData;
    private long _lastPeriod;
    private int _skippedAcks;
    private int _skippedAcksTotal;
    private int _totalDataPackets;
    private static UDPService _testingUDPService;
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$UDPConnectionProcessor;

    public static void setUDPServiceForTesting(UDPService udpService) {
        _testingUDPService = udpService;
    }

    public UDPConnectionProcessor(InetAddress ip, int port) throws IOException {
        this._ip = ip;
        this._port = port;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating UDPConn ip:" + ip + " port:" + port);
        }
        this._theirConnectionID = 0;
        this._connectionState = 0;
        this._lastSendTime = 0L;
        this._lastDataSendTime = 0L;
        this._chunkLimit = 20;
        this._receiverWindowSpace = 20;
        this._waitingForDataSpace = false;
        this._waitingForDataAvailable = false;
        this._waitingForFinAck = false;
        this._skipADataWrite = false;
        this._ackResendCount = 0;
        this._closeReasonCode = 0;
        this._udpService = _testingUDPService == null ? UDPService.instance() : _testingUDPService;
        if (!this._udpService.isListening() || !this._udpService.canDoFWT()) {
            throw CANT_RECEIVE_UDP;
        }
        this._multiplexor = UDPMultiplexor.instance();
        this._scheduler = UDPScheduler.instance();
        this._acceptor = RouterService.getAcceptor();
        this._receiveWindow = new DataWindow(20, 1L);
        this._localExtender = new SequenceNumberExtender();
        this._extender = new SequenceNumberExtender();
        this._myConnectionID = this._multiplexor.register(this);
        if (this._myConnectionID == 0) {
            throw new IOException("no room for connection");
        }
        this.tryToConnect();
    }

    public InputStream getInputStream() throws IOException {
        if (this._outputToInputStream == null) {
            this._outputToInputStream = new UDPBufferedInputStream(this);
        }
        return this._outputToInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this._inputFromOutputStream == null) {
            this.scheduleWriteDataEvent(400L);
            this._inputFromOutputStream = new UDPBufferedOutputStream(this);
        }
        return this._inputFromOutputStream;
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this._readTimeOut = timeout;
    }

    public synchronized void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("closing connection", new Exception());
        }
        if (this._connectionState == 2) {
            throw new IOException("already closed");
        }
        if (this._keepaliveEvent != null) {
            this._keepaliveEvent.unregister();
        }
        if (this._writeDataEvent != null) {
            this._writeDataEvent.unregister();
        }
        if (this._ackTimeoutEvent != null) {
            this._ackTimeoutEvent.unregister();
        }
        if (this._safeWriteWakeup != null) {
            this._safeWriteWakeup.unregister();
        }
        this._connectionState = 2;
        this._waitingForFinAck = true;
        this.safeSendFin();
        if (this._outputToInputStream != null) {
            this._outputToInputStream.wakeup();
        }
        if (this._inputFromOutputStream != null) {
            this._inputFromOutputStream.connectionClosed();
        }
        if (this._closedCleanupEvent == null) {
            this._closedCleanupEvent = new ClosedConnectionCleanupTimerEvent(System.currentTimeMillis() + 400L, this);
            LOG.debug("registering a closedCleanupEvent");
            this._scheduler.register(this._closedCleanupEvent);
        }
    }

    private synchronized void finalClose() {
        if (this._waitingForFinAck) {
            this.safeSendFin();
        }
        this._multiplexor.unregister(this);
        this._closedCleanupEvent.unregister();
    }

    public InetAddress getInetAddress() {
        return this._ip;
    }

    public InetAddress getLocalAddress() {
        InetAddress lip = null;
        try {
            lip = InetAddress.getByName(NetworkUtils.ip2string(this._acceptor.getAddress(false)));
        }
        catch (UnknownHostException uhe) {
            try {
                lip = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe2) {
                lip = null;
            }
        }
        return lip;
    }

    private void prepareOpenConnection() {
        this._connectionState = 1;
        this._sequenceNumber = 1L;
        this.scheduleKeepAlive();
        this._sendWindow = new DataWindow(20, 1L);
        this._writeRegulator = new WriteRegulator(this._sendWindow);
        this._safeWriteWakeup = new SafeWriteWakeupTimerEvent(Long.MAX_VALUE, this);
        this._scheduler.register(this._safeWriteWakeup);
        this._chunkLimit = this._sendWindow.getWindowSpace();
    }

    private synchronized void scheduleKeepAlive() {
        this._keepaliveEvent = new KeepAliveTimerEvent(this._lastSendTime + 2500L, this);
        this._scheduler.register(this._keepaliveEvent);
        this._scheduler.scheduleEvent(this._keepaliveEvent);
    }

    private synchronized void scheduleWriteDataEvent(long time) {
        if (this.isConnected()) {
            if (this._writeDataEvent == null) {
                this._writeDataEvent = new WriteDataTimerEvent(time, this);
                this._scheduler.register(this._writeDataEvent);
            } else {
                this._writeDataEvent.updateTime(time);
            }
            this._scheduler.scheduleEvent(this._writeDataEvent);
            if (LOG.isDebugEnabled()) {
                LOG.debug("scheduleWriteDataEvent :" + time);
            }
        }
    }

    private synchronized void writeSpaceActivation() {
        if (this._waitingForDataSpace) {
            this._waitingForDataSpace = false;
            this.scheduleWriteDataEvent(0L);
        }
    }

    public synchronized void writeDataActivation() {
        long rto = this._sendWindow.getRTO();
        this.scheduleWriteDataEvent(this._lastDataSendTime + rto / 4L);
    }

    public void wakeupWriteEvent() {
        if (this._waitingForDataAvailable) {
            LOG.debug("wakupWriteEvent");
            if (this._safeWriteWakeup.getEventTime() == Long.MAX_VALUE) {
                this._safeWriteWakeup.updateTime(System.currentTimeMillis() + 10L);
                this._scheduler.scheduleEvent(this._safeWriteWakeup);
            }
        }
    }

    private synchronized void scheduleAckTimeoutEvent(long time) {
        if (this.isConnected()) {
            if (this._ackTimeoutEvent == null) {
                this._ackTimeoutEvent = new AckTimeoutTimerEvent(time, this);
                this._scheduler.register(this._ackTimeoutEvent);
            } else {
                this._ackTimeoutEvent.updateTime(time);
            }
            this._scheduler.scheduleEvent(this._ackTimeoutEvent);
        }
    }

    private synchronized void unscheduleAckTimeoutEvent() {
        if (this._ackTimeoutEvent == null) {
            return;
        }
        this._ackTimeoutEvent.updateTime(Long.MAX_VALUE);
    }

    private synchronized boolean isAckTimeoutUpdateRequired() {
        if (this._ackTimeoutEvent == null) {
            return true;
        }
        return this._ackTimeoutEvent.getEventTime() == Long.MAX_VALUE;
    }

    public synchronized boolean isConnected() {
        return this._connectionState == 1 && this._theirConnectionID != 0;
    }

    public synchronized boolean isClosed() {
        return this._connectionState == 2;
    }

    public synchronized boolean isConnecting() {
        return !this.isClosed() && (this._connectionState == 0 || this._theirConnectionID == 0);
    }

    public boolean matchAddress(InetAddress ip, int port) {
        return this._ip.equals(ip) && this._port == port;
    }

    public byte getConnectionID() {
        return this._myConnectionID;
    }

    public int getChunkLimit() {
        return Math.min(this._chunkLimit, this._receiverWindowSpace);
    }

    public Chunk getIncomingChunk() {
        if (this._trailingChunk != null) {
            Chunk chunk = this._trailingChunk;
            this._trailingChunk = null;
            return chunk;
        }
        DataRecord drec = this._receiveWindow.getWritableBlock();
        if (drec == null) {
            return null;
        }
        drec.written = true;
        DataMessage dmsg = (DataMessage)drec.msg;
        this._trailingChunk = dmsg.getData2Chunk();
        int priorSpace = this._receiveWindow.getWindowSpace();
        this._receiveWindow.clearEarlyWrittenBlocks();
        if (priorSpace == 0 || (long)priorSpace <= 2L && (long)this._receiveWindow.getWindowSpace() > 2L) {
            this.sendKeepAlive();
        }
        return dmsg.getData1Chunk();
    }

    public int getReadTimeout() {
        return this._readTimeOut;
    }

    private void sendKeepAlive() {
        KeepAliveMessage keepalive = null;
        try {
            keepalive = new KeepAliveMessage(this._theirConnectionID, this._receiveWindow.getWindowStart(), this._receiveWindow.getWindowSpace());
            this.send(keepalive);
        }
        catch (IllegalArgumentException iae) {
            ErrorService.error(iae);
            this.closeAndCleanup((byte)5);
        }
    }

    private synchronized void sendData(Chunk chunk) {
        try {
            DataMessage dm = new DataMessage(this._theirConnectionID, this._sequenceNumber, chunk.data, chunk.length);
            this.send(dm);
            DataRecord drec = this._sendWindow.addData(dm);
            drec.sentTime = this._lastSendTime;
            ++drec.sends;
            if (LOG.isDebugEnabled() && this._lastSendTime - this._lastDataSendTime > 2000L) {
                LOG.debug("SendData lag = " + (this._lastSendTime - this._lastDataSendTime));
            }
            this._lastDataSendTime = this._lastSendTime;
            this._chunkLimit = this._sendWindow.getWindowSpace();
            ++this._sequenceNumber;
            if (this.isAckTimeoutUpdateRequired()) {
                this.scheduleAckIfNeeded();
            }
            if (this._receiverWindowSpace > 0) {
                --this._receiverWindowSpace;
            }
        }
        catch (IllegalArgumentException iae) {
            ErrorService.error(iae);
            this.closeAndCleanup((byte)5);
        }
    }

    private synchronized void safeSendAck(UDPConnectionMessage msg) {
        AckMessage ack = null;
        try {
            ack = new AckMessage(this._theirConnectionID, msg.getSequenceNumber(), this._receiveWindow.getWindowStart(), this._receiveWindow.getWindowSpace());
            if (LOG.isDebugEnabled()) {
                LOG.debug("total data packets " + this._totalDataPackets + " total acks skipped " + this._skippedAcksTotal + " skipped this session " + this._skippedAcks);
            }
            this._skippedAcks = 0;
            this.send(ack);
        }
        catch (BadPacketException bpe) {
            ErrorService.error(bpe);
            this.closeAndCleanup((byte)5);
        }
        catch (IllegalArgumentException iae) {
            ErrorService.error(iae);
            this.closeAndCleanup((byte)5);
        }
    }

    private synchronized void safeSendFin() {
        FinMessage fin = null;
        try {
            this._finSeqNo = this._sequenceNumber;
            fin = new FinMessage(this._theirConnectionID, this._sequenceNumber, this._closeReasonCode);
            this.send(fin);
        }
        catch (IllegalArgumentException iae) {
            ErrorService.error(iae);
            LOG.warn("calling recursively closeAndCleanup");
            this.closeAndCleanup((byte)5);
        }
    }

    private synchronized void safeSend(UDPConnectionMessage msg) {
        try {
            this.send(msg);
        }
        catch (IllegalArgumentException iae) {
            ErrorService.error(iae);
            this.closeAndCleanup((byte)5);
        }
    }

    private synchronized void send(UDPConnectionMessage msg) throws IllegalArgumentException {
        this._lastSendTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("send :" + msg + " ip:" + this._ip + " p:" + this._port + " t:" + this._lastSendTime);
            if (msg instanceof FinMessage) {
                Exception ex = new Exception();
                LOG.debug("", ex);
            }
        }
        this._udpService.send(msg, this._ip, this._port);
    }

    private synchronized void scheduleAckIfNeeded() {
        DataRecord drec = this._sendWindow.getOldestUnackedBlock();
        if (drec != null) {
            int rto = this._sendWindow.getRTO();
            if (rto == 0) {
                rto = 400;
            }
            long waitTime = drec.sentTime + (long)rto;
            if (this._ackResendCount > 0) {
                waitTime = this._lastSendTime + (long)rto;
                this._ackResendCount = 0;
            }
            long minTime = System.currentTimeMillis() + 5L;
            waitTime = Math.max(waitTime, minTime);
            this.scheduleAckTimeoutEvent(waitTime);
        } else {
            this.unscheduleAckTimeoutEvent();
        }
    }

    private synchronized void validateAckedData() {
        long currTime = System.currentTimeMillis();
        if (this._sendWindow.acksAppearToBeMissing(currTime, 1)) {
            int rto = this._sendWindow.getRTO();
            long start = this._sendWindow.getWindowStart();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Soft resend check:" + start + " rto:" + rto + " uS:" + this._sendWindow.getUsedSpots() + " localSeq:" + this._sequenceNumber);
            }
            int numResent = 0;
            DataRecord drec = this._sendWindow.getOldestUnackedBlock();
            int expRTO = rto * (int)Math.pow(2.0, drec.sends - 1);
            if (LOG.isDebugEnabled()) {
                LOG.debug(" exponential backoff is now " + expRTO);
            }
            if (this._sendWindow.countHigherAckBlocks() > 0) {
                expRTO = (int)((double)expRTO * 0.75);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" higher acked blocks, adjusting exponential backoff is now " + expRTO);
                }
            }
            if (drec != null && drec.acks <= 0) {
                if (drec.sends > 9) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Tried too many send on:" + drec.msg.getSequenceNumber());
                    }
                    this.closeAndCleanup((byte)4);
                    return;
                }
                int currentWait = (int)(currTime - drec.sentTime);
                if (currentWait > expRTO) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Soft resending message:" + drec.msg.getSequenceNumber());
                    }
                    this.safeSend(drec.msg);
                    this._writeRegulator.addMessageFailure();
                    this._writeRegulator.hitResendTimeout();
                    drec.sentTime = currTime = this._lastSendTime;
                    ++drec.sends;
                    ++numResent;
                } else {
                    LOG.debug(" not resending message ");
                }
            }
            this._ackResendCount = numResent;
            if (numResent > 0) {
                this._skipADataWrite = true;
            }
        }
        this.scheduleAckIfNeeded();
    }

    private synchronized void closeAndCleanup(byte reasonCode) {
        this._closeReasonCode = reasonCode;
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToConnect() throws IOException {
        try {
            this._sequenceNumber = 0L;
            long waitTime = 0L;
            SynMessage synMsg = new SynMessage(this._myConnectionID);
            while (true) {
                UDPConnectionProcessor uDPConnectionProcessor = this;
                synchronized (uDPConnectionProcessor) {
                    if (!this.isConnecting()) {
                        break;
                    }
                    if (waitTime > this._connectTimeOut) {
                        this._connectionState = 2;
                        this._multiplexor.unregister(this);
                        throw CONNECTION_TIMEOUT;
                    }
                    if (this._theirConnectionID != 0 && this._theirConnectionID != synMsg.getConnectionID()) {
                        synMsg = new SynMessage(this._myConnectionID, this._theirConnectionID);
                    }
                }
                this.send(synMsg);
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                waitTime += 400L;
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(UDPConnectionMessage msg) {
        boolean doYield = false;
        UDPConnectionProcessor uDPConnectionProcessor = this;
        synchronized (uDPConnectionProcessor) {
            this._lastReceivedTime = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug("handleMessage :" + msg + " t:" + this._lastReceivedTime);
            }
            if (msg instanceof SynMessage) {
                msg.extendSequenceNumber(this._extender.extendSequenceNumber(msg.getSequenceNumber()));
                SynMessage smsg = (SynMessage)msg;
                byte theirConnID = smsg.getSenderConnectionID();
                if (this._theirConnectionID == 0) {
                    this._theirConnectionID = theirConnID;
                } else if (this._theirConnectionID != theirConnID) {
                    return;
                }
                this.safeSendAck(msg);
            } else if (msg instanceof AckMessage) {
                msg.extendSequenceNumber(this._localExtender.extendSequenceNumber(msg.getSequenceNumber()));
                AckMessage amsg = (AckMessage)msg;
                amsg.extendWindowStart(this._localExtender.extendSequenceNumber(amsg.getWindowStart()));
                long seqNo = amsg.getSequenceNumber();
                long wStart = amsg.getWindowStart();
                int priorR = this._receiverWindowSpace;
                this._receiverWindowSpace = amsg.getWindowSpace();
                if (this._sequenceNumber > wStart) {
                    this._receiverWindowSpace = 20 + (int)(wStart - this._sequenceNumber);
                }
                if ((priorR == 0 || this._waitingForDataSpace) && this._receiverWindowSpace > 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" -- ACK wakeup");
                    }
                    this.writeSpaceActivation();
                }
                if (seqNo == 0L && this.isConnecting() && this._connectionState == 0) {
                    this.prepareOpenConnection();
                } else if (this._waitingForFinAck && seqNo == this._finSeqNo) {
                    this._waitingForFinAck = false;
                } else if (this._connectionState == 1) {
                    this._sendWindow.ackBlock(seqNo);
                    this._writeRegulator.addMessageSuccess();
                    this._sendWindow.pseudoAckToReceiverWindow(amsg.getWindowStart());
                    this._sendWindow.clearLowAckedBlocks();
                    this._chunkLimit = this._sendWindow.getWindowSpace();
                }
            } else if (msg instanceof DataMessage) {
                msg.extendSequenceNumber(this._extender.extendSequenceNumber(msg.getSequenceNumber()));
                DataMessage dmsg = (DataMessage)msg;
                long seqNo = dmsg.getSequenceNumber();
                long baseSeqNo = this._receiveWindow.getWindowStart();
                if (dmsg.getDataLength() > 4096) {
                    this.closeAndCleanup((byte)3);
                    return;
                }
                if (seqNo > baseSeqNo + 25L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received block num too far ahead: " + seqNo);
                    }
                    return;
                }
                if (seqNo >= baseSeqNo) {
                    DataRecord drec = this._receiveWindow.addData(dmsg);
                    drec.ackTime = System.currentTimeMillis();
                    ++drec.acks;
                    if (this._outputToInputStream != null && seqNo == baseSeqNo) {
                        this._outputToInputStream.wakeup();
                        if (seqNo % 2L == 0L) {
                            doYield = true;
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Received duplicate block num: " + dmsg.getSequenceNumber());
                }
                if (this._lastPeriod == 0L) {
                    this._lastPeriod = this._lastReceivedTime;
                }
                ++this._packetsThisPeriod;
                ++this._totalDataPackets;
                if (this._skipAcks && this._enoughData && this._skippedAcks < _maxSkipAck) {
                    float average = 0.0f;
                    for (int i = 0; i < _periodHistory; ++i) {
                        average += (float)this._periods[i];
                    }
                    if ((float)this._periods[this._currentPeriodId] > (average /= (float)_periodHistory) / this._deviation) {
                        ++this._skippedAcks;
                        ++this._skippedAcksTotal;
                    } else {
                        this.safeSendAck(msg);
                    }
                } else {
                    this.safeSendAck(msg);
                }
                if (this._lastReceivedTime - this._lastPeriod >= (long)this._period) {
                    this._lastPeriod = this._lastReceivedTime;
                    ++this._currentPeriodId;
                    if (this._currentPeriodId >= _periodHistory) {
                        this._currentPeriodId = 0;
                        this._enoughData = true;
                    }
                    this._periods[this._currentPeriodId] = this._packetsThisPeriod;
                    this._packetsThisPeriod = 0;
                }
            } else if (msg instanceof KeepAliveMessage) {
                KeepAliveMessage kmsg = (KeepAliveMessage)msg;
                kmsg.extendWindowStart(this._localExtender.extendSequenceNumber(kmsg.getWindowStart()));
                long seqNo = kmsg.getSequenceNumber();
                long wStart = kmsg.getWindowStart();
                int priorR = this._receiverWindowSpace;
                this._receiverWindowSpace = kmsg.getWindowSpace();
                if (this._sequenceNumber > wStart) {
                    this._receiverWindowSpace = 20 + (int)(wStart - this._sequenceNumber);
                }
                if (this.isClosed()) {
                    this.safeSendFin();
                }
                if (this._sendWindow != null) {
                    this._sendWindow.pseudoAckToReceiverWindow(wStart);
                    if ((priorR == 0 || this._waitingForDataSpace) && this._receiverWindowSpace > 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(" -- KA wakeup");
                        }
                        this.writeSpaceActivation();
                    }
                }
            } else if (msg instanceof FinMessage) {
                msg.extendSequenceNumber(this._extender.extendSequenceNumber(msg.getSequenceNumber()));
                this._receiverWindowSpace = 0;
                this.safeSendAck(msg);
                if (!this.isClosed()) {
                    this.closeAndCleanup((byte)1);
                }
            }
        }
        if (doYield) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeData() {
        long waitTime;
        int noSleepCount = 0;
        while (true) {
            Object chunk;
            if (this._inputFromOutputStream == null) {
                this.scheduleWriteDataEvent(400L);
                return;
            }
            this._waitingForDataAvailable = false;
            this._waitingForDataSpace = false;
            if (this._skipADataWrite) {
                this._skipADataWrite = false;
            } else if (this.getChunkLimit() > 0) {
                chunk = this._inputFromOutputStream.getChunk();
                if (chunk != null) {
                    this.sendData((Chunk)chunk);
                }
            } else {
                this.scheduleWriteDataEvent(System.currentTimeMillis() + 1000L);
                this._waitingForDataSpace = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Shutdown SendData cL:" + this._chunkLimit + " rWS:" + this._receiverWindowSpace);
                }
            }
            chunk = this._inputFromOutputStream;
            synchronized (chunk) {
                if (this._inputFromOutputStream.getPendingChunks() == 0) {
                    this.scheduleWriteDataEvent(System.currentTimeMillis() + 1000L);
                    this._waitingForDataAvailable = true;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Shutdown SendData no pending");
                    }
                    return;
                }
            }
            long currTime = System.currentTimeMillis();
            waitTime = this._writeRegulator.getSleepTime(currTime, this._receiverWindowSpace);
            if ((long)this._receiverWindowSpace <= 2L && this._receiverWindowSpace <= 1) {
                this._writeRegulator.hitZeroWindow();
            }
            if (waitTime == 0L && this._sequenceNumber < 10L) {
                waitTime = 400L;
            }
            if ((long)noSleepCount >= 4L) {
                ++waitTime;
            }
            if (waitTime > 0L) break;
            ++noSleepCount;
        }
        long time = System.currentTimeMillis() + waitTime;
        this.scheduleWriteDataEvent(time);
    }

    protected void finalize() {
        if (!this.isClosed()) {
            LOG.warn("finalizing an open UDPConnectionProcessor!");
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ClosedConnectionCleanupTimerEvent
    extends UDPTimerEvent {
        public ClosedConnectionCleanupTimerEvent(long time, UDPConnectionProcessor proc) {
            super(time, proc);
        }

        protected void doActualEvent(UDPConnectionProcessor udpCon) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed connection timeout: " + System.currentTimeMillis());
            }
            udpCon.finalClose();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed connection done: " + System.currentTimeMillis());
            }
            this.unregister();
        }
    }

    static class SafeWriteWakeupTimerEvent
    extends UDPTimerEvent {
        public SafeWriteWakeupTimerEvent(long time, UDPConnectionProcessor proc) {
            super(time, proc);
        }

        protected void doActualEvent(UDPConnectionProcessor udpCon) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("write wakeup timeout: " + System.currentTimeMillis());
            }
            if (udpCon.isConnected()) {
                udpCon.writeDataActivation();
            }
            this._eventTime = Long.MAX_VALUE;
            udpCon._scheduler.scheduleEvent(this);
            if (LOG.isDebugEnabled()) {
                LOG.debug("write wakeup timeout: " + System.currentTimeMillis());
            }
        }
    }

    static class AckTimeoutTimerEvent
    extends UDPTimerEvent {
        public AckTimeoutTimerEvent(long time, UDPConnectionProcessor proc) {
            super(time, proc);
        }

        protected void doActualEvent(UDPConnectionProcessor udpCon) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ack timeout: " + System.currentTimeMillis());
            }
            if (udpCon.isConnected()) {
                udpCon.validateAckedData();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("end ack timeout: " + System.currentTimeMillis());
            }
        }
    }

    static class WriteDataTimerEvent
    extends UDPTimerEvent {
        public WriteDataTimerEvent(long time, UDPConnectionProcessor proc) {
            super(time, proc);
        }

        protected void doActualEvent(UDPConnectionProcessor udpCon) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("data timeout :" + System.currentTimeMillis());
            }
            long time = System.currentTimeMillis();
            if (udpCon.isConnected() && udpCon._lastReceivedTime + 20000L < time) {
                udpCon.closeAndCleanup((byte)2);
                return;
            }
            if (udpCon.isConnected()) {
                udpCon.writeData();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("end data timeout: " + System.currentTimeMillis());
            }
        }
    }

    static class KeepAliveTimerEvent
    extends UDPTimerEvent {
        public KeepAliveTimerEvent(long time, UDPConnectionProcessor proc) {
            super(time, proc);
        }

        protected void doActualEvent(UDPConnectionProcessor udpCon) {
            long time = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug("keepalive: " + time);
            }
            if (udpCon.isClosed()) {
                udpCon._keepaliveEvent.unregister();
            }
            if (udpCon.isConnected() && udpCon._lastReceivedTime + 20000L < time) {
                LOG.debug("Keepalive generated shutdown");
                udpCon.closeAndCleanup((byte)2);
                return;
            }
            if (time + 1L >= udpCon._lastSendTime + 2500L) {
                if (udpCon.isConnected()) {
                    udpCon.sendKeepAlive();
                } else {
                    return;
                }
            }
            this._eventTime = udpCon._lastSendTime + 2500L;
            udpCon._scheduler.scheduleEvent(this);
            if (LOG.isDebugEnabled()) {
                LOG.debug("end keepalive: " + System.currentTimeMillis());
            }
        }
    }
}

