/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.BandwidthThrottle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NormalUploadState
extends UploadState {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$uploader$NormalUploadState == null ? (class$com$limegroup$gnutella$uploader$NormalUploadState = NormalUploadState.class$("com.limegroup.gnutella.uploader.NormalUploadState")) : class$com$limegroup$gnutella$uploader$NormalUploadState);
    private static final int BLOCK_SIZE = 1024;
    private final int _index;
    private final String _fileName;
    private final int _fileSize;
    private InputStream _fis;
    private int _amountWritten;
    private int _uploadBegin;
    private int _uploadEnd;
    private int _amountRequested;
    private StalledUploadWatchdog _stalledChecker;
    private static final BandwidthThrottle THROTTLE = new BandwidthThrottle(NormalUploadState.getUploadSpeed(), false);
    private static final BandwidthThrottle UDP_THROTTLE = new BandwidthThrottle(NormalUploadState.getUploadSpeed(), false);
    static /* synthetic */ Class class$com$limegroup$gnutella$uploader$NormalUploadState;

    public NormalUploadState(HTTPUploader uploader, StalledUploadWatchdog watchdog) {
        super(uploader);
        LOG.debug("creating a normal upload state");
        this._index = this.UPLOADER.getIndex();
        this._fileName = this.UPLOADER.getFileName();
        this._fileSize = this.UPLOADER.getFileSize();
        this._amountWritten = 0;
        this._stalledChecker = watchdog;
    }

    public static void setThrottleSwitching(boolean on) {
        THROTTLE.setSwitching(on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageHeaders(OutputStream network) throws IOException {
        LOG.debug("writing message headers");
        try {
            StringWriter ostream = new StringWriter();
            this._fis = this.UPLOADER.getInputStream();
            this._uploadBegin = this.UPLOADER.getUploadBegin();
            this._uploadEnd = this.UPLOADER.getUploadEnd();
            this._amountRequested = this.UPLOADER.getAmountRequested();
            if (this._fileSize < this._uploadBegin) {
                throw new IOException("Invalid Range");
            }
            if (this._uploadBegin == 0 && this._amountRequested == this._fileSize) {
                ((Writer)ostream).write("HTTP/1.1 200 OK\r\n");
            } else {
                ((Writer)ostream).write("HTTP/1.1 206 Partial Content\r\n");
            }
            HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, (Writer)ostream);
            HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_TYPE, this.getMimeType(), (Writer)ostream);
            HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_LENGTH, this._amountRequested, (Writer)ostream);
            HTTPUtils.writeDate(ostream);
            if (this._uploadBegin != 0 || this._amountRequested != this._fileSize) {
                ((Writer)ostream).write("Content-Range: bytes " + this._uploadBegin + "-" + (this._uploadEnd - 1) + "/" + this._fileSize + "\r\n");
            }
            this.writeAlts(ostream);
            this.writeRanges(ostream);
            this.writeProxies(ostream);
            if (this.FILE_DESC != null) {
                CreationTimeCache cache;
                URN urn = this.FILE_DESC.getSHA1Urn();
                if (this.UPLOADER.isFirstReply() && (cache = CreationTimeCache.instance()).getCreationTime(urn) != null) {
                    HTTPUtils.writeHeader(HTTPHeaderName.CREATION_TIME, cache.getCreationTime(urn).toString(), (Writer)ostream);
                }
            }
            if (this.UPLOADER.isFirstReply()) {
                HTTPUtils.writeFeatures(ostream);
            }
            if (this.FILE_DESC.getHashTree() != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.THEX_URI, (HTTPHeaderValue)this.FILE_DESC.getHashTree(), (Writer)ostream);
            }
            ((Writer)ostream).write("\r\n");
            this._stalledChecker.activate(network);
            network.write(((Object)ostream).toString().getBytes());
        }
        finally {
            this._stalledChecker.deactivate();
        }
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        LOG.debug("writing message body");
        try {
            this._fis.skip(this._uploadBegin);
            this.upload(ostream);
        }
        catch (IOException e) {
            this._stalledChecker.deactivate();
            throw e;
        }
    }

    private void upload(OutputStream ostream) throws IOException {
        byte[] buf = new byte[1024];
        do {
            BandwidthThrottle throttle = this.UPLOADER.isUDPTransfer() ? UDP_THROTTLE : THROTTLE;
            throttle.setRate(NormalUploadState.getUploadSpeed());
            int c = -1;
            int allowed = 1024;
            if (!this.UPLOADER.isNetworkShare()) {
                allowed = throttle.request(1024);
            }
            int burstSent = 0;
            try {
                c = this._fis.read(buf, 0, allowed);
            }
            catch (NullPointerException npe) {
                throw new IOException(npe.getMessage());
            }
            if (c == -1) {
                return;
            }
            if (c > this._amountRequested - this._amountWritten) {
                c = this._amountRequested - this._amountWritten;
            }
            this._stalledChecker.activate(ostream);
            ostream.write(buf, 0, c);
            this._stalledChecker.deactivate();
            this._amountWritten += c;
            this.UPLOADER.setAmountUploaded(this._amountWritten);
            burstSent += c;
        } while (this._amountWritten < this._amountRequested);
    }

    private String getMimeType() {
        return "application/binary";
    }

    private static float getUploadSpeed() {
        int uSpeed = UploadSettings.UPLOAD_SPEED.getValue();
        float ret = uSpeed == 100 ? Float.MAX_VALUE : Math.max((float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f * (float)uSpeed / 100.0f - RouterService.getConnectionManager().getMeasuredUpstreamBandwidth() * 1.0f, 1.0f) * 1024.0f;
        return ret;
    }

    public boolean getCloseConnection() {
        return false;
    }

    public String toString() {
        return "NormalUploadState:\r\nFile Name:  " + this._fileName + "\r\n" + "File Size:  " + this._fileSize + "\r\n" + "File Index: " + this._index + "\r\n" + "File Desc:  " + this.FILE_DESC;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

