/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.CommonUtils;

public class SystemUtils {
    private static boolean isLoaded;

    private SystemUtils() {
    }

    public static long getIdleTime() {
        if (SystemUtils.supportsIdleTime()) {
            return SystemUtils.idleTime();
        }
        return 0L;
    }

    public static boolean supportsIdleTime() {
        if (isLoaded) {
            if (CommonUtils.isWindows2000orXP()) {
                return true;
            }
            if (CommonUtils.isMacOSX()) {
                return true;
            }
        }
        return false;
    }

    public static long setOpenFileLimit(int max) {
        if (isLoaded && CommonUtils.isMacOSX()) {
            return SystemUtils.setOpenFileLimit0(max);
        }
        return -1L;
    }

    static void setWriteable(String fileName) {
        if (isLoaded && (CommonUtils.isWindows() || CommonUtils.isMacOSX())) {
            SystemUtils.setFileWriteable(fileName);
        }
    }

    private static final native long idleTime();

    private static final native int setFileWriteable(String var0);

    private static final native int setOpenFileLimit0(int var0);

    static {
        boolean canLoad;
        try {
            if (CommonUtils.isMacOSX()) {
                System.loadLibrary("SystemUtilities");
            } else if (CommonUtils.isWindows()) {
                System.loadLibrary("GenericWindowsUtils");
                if (CommonUtils.isWindows2000orXP()) {
                    System.loadLibrary("WindowsV5PlusUtils");
                }
            }
            canLoad = true;
        }
        catch (UnsatisfiedLinkError noGo) {
            canLoad = false;
        }
        isLoaded = canLoad;
    }
}

