/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2IllegalVersionException;
import de.vdheide.mp3.NoID3v2HeaderException;
import java.io.IOException;
import java.io.InputStream;

public class ID3v2Header {
    byte version = 0;
    byte revision = 0;
    boolean unsynch = false;
    boolean extended_header = false;
    boolean experimental = false;
    int size = 0;
    private static final byte FLAG_UNSYNCHRONIZATION = -128;
    private static final byte FLAG_EXTENDED_HEADER = 64;
    private static final byte FLAG_EXPERIMENTAL = 32;

    public ID3v2Header() {
        this(3, 0, false, false, false, 0);
    }

    public ID3v2Header(byte version, byte revision, boolean unsynch, boolean extended_header, boolean experimental, int length) {
        this.version = version;
        this.revision = revision;
        this.unsynch = unsynch;
        this.extended_header = extended_header;
        this.experimental = experimental;
        this.size = length;
    }

    public ID3v2Header(InputStream in) throws ID3v2IllegalVersionException, NoID3v2HeaderException, IOException {
        this.readFromFile(in);
    }

    public void readFromFile(InputStream in) throws ID3v2IllegalVersionException, NoID3v2HeaderException, IOException {
        byte[] head = new byte[10];
        ID3v2.fillBuffer(head, in);
        if (!ID3v2Header.isHeader(head)) {
            throw new NoID3v2HeaderException();
        }
        this.version = head[3];
        this.revision = head[4];
        if ((this.version & 0xFF) > 3 || this.version == 3 && (this.revision & 0xFF) > 0) {
            throw new ID3v2IllegalVersionException();
        }
        this.unsynch = (head[5] & 0xFF & 0xFFFFFF80) > 0;
        this.extended_header = (head[5] & 0xFF & 0x40) > 0;
        this.experimental = (head[5] & 0xFF & 0x20) > 0;
        this.size = (head[9] & 0xFF) + ((head[8] & 0xFF) << 7) + ((head[7] & 0xFF) << 14) + ((head[6] & 0xFF) << 21);
    }

    public static boolean isHeader(byte[] head) {
        if (head.length != 10) {
            return false;
        }
        if (head[0] != 73 || head[1] != 68 || head[2] != 51) {
            return false;
        }
        if (head[3] == -1 || head[4] == -1) {
            return false;
        }
        return (head[6] & 0xFF) < 128 && (head[7] & 0xFF) < 128 && (head[8] & 0xFF) < 128 && (head[9] & 0xFF) < 128;
    }

    public boolean getUnsynchronization() {
        return this.unsynch;
    }

    public void setUnsynchronization(boolean act) {
        this.unsynch = act;
    }

    public boolean hasExtendedHeader() {
        return this.extended_header;
    }

    public void setExtendedHeader(boolean act) {
        this.extended_header = act;
    }

    public boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(boolean act) {
        this.experimental = act;
    }

    public int getTagSize() {
        return this.size;
    }

    public void setTagSize(int size) {
        this.size = size;
    }

    public byte[] getBytes() {
        byte[] work = new byte[10];
        work[0] = 73;
        work[1] = 68;
        work[2] = 51;
        work[3] = this.version;
        work[4] = this.revision;
        int flag = 0;
        if (this.unsynch) {
            flag = (byte)(flag - 128);
        }
        if (this.extended_header) {
            flag = (byte)(flag + 64);
        }
        if (this.experimental) {
            flag = (byte)(flag + 32);
        }
        work[5] = flag;
        for (int i = 0; i < 4; ++i) {
            work[i + 6] = (byte)(this.size >> (3 - i) * 7 & 0x7F);
        }
        return work;
    }
}

