/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.protocols;

import java.math.BigInteger;
import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.keys.DHKey;
import org.logi.crypto.keys.KeyException;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.DHKeyEx;
import org.logi.crypto.protocols.InterKeyExClient;

public class DHKeyExClient
extends DHKeyEx
implements InterKeyExClient {
    public byte[] message(byte[] byArray) throws CryptoProtocolException {
        try {
            if (byArray != null) {
                this.hisPublic = new BigInteger(1, byArray);
                byte[] byArray2 = this.hisPublic.modPow(this.myPrivate, this.m).toByteArray();
                try {
                    this.sessionKey = Crypto.makeSessionKey(this.keyType, byArray2);
                    this.keyDecided = true;
                }
                catch (InvalidCDSException invalidCDSException) {
                    throw new CryptoProtocolException(invalidCDSException.getMessage());
                }
                return null;
            }
            byte[] byArray3 = this.myPublic.toByteArray();
            if (byArray3.length == this.modSize / 8) {
                return byArray3;
            }
            byte[] byArray4 = new byte[this.modSize / 8];
            int n = Math.min(byArray3.length, this.modSize / 8);
            System.arraycopy(byArray3, byArray3.length - n, byArray4, byArray4.length - n, n);
            return byArray4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CryptoProtocolException("Malformed message.");
        }
    }

    public DHKeyExClient(DHKey dHKey, String string) throws KeyException {
        super(dHKey, string);
    }

    public DHKeyExClient(int n, String string) {
        super(n, string);
    }
}

