/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.random;

import java.util.Random;
import org.logi.crypto.Crypto;
import org.logi.crypto.hash.MD5State;
import org.logi.crypto.random.PureSpinner;
import org.logi.crypto.random.Seedable;

public class RandomMD5
extends Random
implements Seedable {
    MD5State.SubState ss = new MD5State.SubState();
    int seedSinceHash = 0;
    int poolSweep = 0;
    byte[] unused;
    int unusedPos;
    Random seeder;
    private int roundEnt;
    private Thread initThread;

    public void setSeed(byte[] byArray, int n, int n2) {
        if (this.ss == null) {
            return;
        }
        if (n2 + this.seedSinceHash > 64) {
            int n3 = 64 - this.seedSinceHash;
            this.setSeed(byArray, n, n3);
            this.setSeed(byArray, n + n3, n2 - n3);
        } else {
            int n4 = n2 - 1;
            while (n4 >= 0) {
                int n5 = this.poolSweep;
                this.ss.buffer[n5] = (byte)(this.ss.buffer[n5] ^ byArray[n + n4]);
                this.poolSweep = (this.poolSweep + 1) % 64;
                --n4;
            }
            this.seedSinceHash += n2;
            if (this.seedSinceHash >= 64) {
                this.ss.transform(this.ss.buffer, 0);
                this.seedSinceHash = 0;
            }
        }
    }

    public void setSeed(long l) {
        byte[] byArray = new byte[8];
        Crypto.writeBytes(l, byArray, 0, 8);
        this.setSeed(byArray, 0, 8);
    }

    private void update() {
        while (this.initThread != null) {
            try {
                this.initThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        byte[] byArray = new byte[this.roundEnt];
        this.seeder.nextBytes(byArray);
        this.setSeed(byArray, 0, this.roundEnt);
        if (this.seedSinceHash > 0 || this.roundEnt == 0) {
            this.ss.transform(this.ss.buffer, 0);
        }
        Crypto.writeBytes(this.ss.hash[0], this.unused, 0, 4);
        Crypto.writeBytes(this.ss.hash[1], this.unused, 4, 4);
        Crypto.writeBytes(this.ss.hash[2], this.unused, 8, 4);
        Crypto.writeBytes(this.ss.hash[3], this.unused, 12, 4);
        this.unusedPos = 0;
    }

    public void nextBytes(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.unusedPos >= 16) {
                this.update();
            }
            int n3 = Math.min(n - n2, 16 - this.unusedPos);
            System.arraycopy(this.unused, this.unusedPos, byArray, n2, n3);
            n2 += n3;
            this.unusedPos += n3;
        }
    }

    protected synchronized int next(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.unusedPos >= 16) {
                this.update();
            }
            n2 = n2 << 8 | this.unused[this.unusedPos++] & 0xFF;
            n3 += 8;
        }
        return n2 >>> n3 - n;
    }

    static /* synthetic */ Thread access$0(RandomMD5 randomMD5) {
        return randomMD5.initThread;
    }

    public RandomMD5(Random random, int n, int n2) {
        this.seeder = random;
        this.roundEnt = n2;
        RandomMD5 randomMD5 = this;
        if (randomMD5 == null) {
            throw null;
        }
        this.initThread = randomMD5.new InitThread(n);
        this.initThread.start();
        this.unused = new byte[16];
        this.unusedPos = 16;
    }

    public RandomMD5() {
        this(new PureSpinner(), 256, 4);
    }

    private class InitThread
    extends Thread {
        private int seedSize;

        public void run() {
            byte[] byArray = new byte[this.seedSize];
            RandomMD5.this.seeder.nextBytes(byArray);
            RandomMD5.this.setSeed(byArray, 0, this.seedSize);
            RandomMD5.this.initThread = null;
        }

        public InitThread(int n) {
            this.seedSize = n;
        }
    }
}

