/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import org.logi.crypto.Crypto;
import org.logi.crypto.io.DecryptStream;
import org.logi.crypto.io.EncryptStream;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.TriDESKey;
import org.logi.crypto.modes.DecryptCBC;
import org.logi.crypto.modes.EncryptCBC;

public class TestDrain {
    static Random rand = new Random();

    public static void main(String[] stringArray) throws Exception {
        Crypto.initRandom();
        int n = rand.nextInt() % 32768 + 32768;
        TriDESKey triDESKey = new TriDESKey();
        W w = new W(new ServerSocket(n), triDESKey);
        R r = new R(new Socket("localhost", n), triDESKey);
    }

    private static class R
    extends Thread {
        Socket socket;
        CipherKey key;

        public void run() {
            try {
                InputStream inputStream = this.socket.getInputStream();
                DecryptStream decryptStream = new DecryptStream(inputStream, null, new DecryptCBC(this.key));
                while (true) {
                    int n = decryptStream.read();
                    System.out.print("[" + n + "] ");
                    int n2 = 0;
                    while (n2 < n) {
                        int n3 = decryptStream.read();
                        System.out.print(n3 + " ");
                        if (n3 != n2) {
                            throw new Error("Mismatch!");
                        }
                        ++n2;
                    }
                    decryptStream.drain();
                    System.out.println();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        public R(Socket socket, CipherKey cipherKey) throws IOException {
            this.socket = socket;
            this.key = cipherKey;
            this.start();
        }
    }

    private static class W
    extends Thread {
        ServerSocket socket;
        CipherKey key;

        public void run() {
            try {
                OutputStream outputStream = this.socket.accept().getOutputStream();
                EncryptStream encryptStream = new EncryptStream(outputStream, null, new EncryptCBC(this.key));
                while (true) {
                    int n = rand.nextInt() % 10 + 11;
                    encryptStream.write(n);
                    int n2 = 0;
                    while (n2 < n) {
                        encryptStream.write(n2);
                        ++n2;
                    }
                    encryptStream.flush();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        public W(ServerSocket serverSocket, CipherKey cipherKey) throws IOException {
            this.socket = serverSocket;
            this.key = cipherKey;
            this.start();
        }
    }
}

