/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import de.kapsi.net.daap.DaapChunkResponse;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.nio.DaapConnectionNIO;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class DaapChunkResponseNIO
extends DaapChunkResponse {
    private SocketChannel channel;
    private ByteBuffer headerBuffer;
    private ByteBuffer dataBuffer;

    public DaapChunkResponseNIO(DaapRequest request, byte[] data) {
        super(request, data);
        DaapConnectionNIO connection = (DaapConnectionNIO)request.getConnection();
        this.channel = connection.getChannel();
        this.headerBuffer = ByteBuffer.wrap(this.header);
        this.dataBuffer = ByteBuffer.wrap(data);
    }

    public boolean hasRemainig() {
        return this.headerBuffer.hasRemaining() || this.dataBuffer.hasRemaining();
    }

    public boolean write() throws IOException {
        if (this.headerBuffer.hasRemaining()) {
            this.channel.write(this.headerBuffer);
            if (this.headerBuffer.hasRemaining()) {
                return false;
            }
        }
        if (this.dataBuffer.hasRemaining()) {
            this.channel.write(this.dataBuffer);
            return !this.dataBuffer.hasRemaining();
        }
        return true;
    }
}

