/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapRequestProcessor;
import de.kapsi.net.daap.DaapResponse;
import de.kapsi.net.daap.DaapResponseFactory;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.nio.DaapRequestReaderNIO;
import de.kapsi.net.daap.nio.DaapResponseFactoryNIO;
import de.kapsi.net.daap.nio.DaapServerNIO;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapConnectionNIO
extends DaapConnection {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$nio$DaapConnectionNIO == null ? (class$de$kapsi$net$daap$nio$DaapConnectionNIO = DaapConnectionNIO.class$("de.kapsi.net.daap.nio.DaapConnectionNIO")) : class$de$kapsi$net$daap$nio$DaapConnectionNIO));
    private static final DaapResponseFactory FACTORY = new DaapResponseFactoryNIO();
    private static final DaapRequestProcessor PROCESSOR = new DaapRequestProcessor(FACTORY);
    private DaapServerNIO server;
    private SocketChannel channel;
    private DaapRequestReaderNIO reader;
    static /* synthetic */ Class class$de$kapsi$net$daap$nio$DaapConnectionNIO;

    public DaapConnectionNIO(DaapServerNIO server, SocketChannel channel) {
        super(server);
        this.server = server;
        this.channel = channel;
        this.reader = new DaapRequestReaderNIO(this);
    }

    int interrestOps() {
        if (this.isUndef()) {
            return 1;
        }
        if (this.isDaapConnection()) {
            int op = 1;
            if (!this.writer.isEmpty()) {
                op |= 4;
            }
            return op;
        }
        return 4;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public boolean read() throws IOException {
        DaapRequest request;
        if (!this.isAudioStream() && (request = this.reader.read()) != null) {
            if (this.isUndef()) {
                if (request.isSongRequest()) {
                    this.setConnectionType(2);
                    Integer sid = new Integer(request.getSessionId());
                    if (!this.server.isSessionIdValid(sid)) {
                        throw new IOException("Unknown Session-ID: " + sid);
                    }
                    DaapConnection connection = this.server.getConnection(sid);
                    if (connection == null) {
                        throw new IOException("No connection associated with this Session-ID: " + sid);
                    }
                    this.setProtocolVersion(connection.getProtocolVersion());
                } else if (request.isServerInfoRequest()) {
                    this.setConnectionType(1);
                    this.setProtocolVersion(DaapUtil.getProtocolVersion(request));
                } else {
                    throw new IOException("Illegal first request: " + request);
                }
                if (!DaapUtil.isSupportedProtocolVersion(this.getProtocolVersion())) {
                    throw new IOException("Unsupported Protocol Version: " + this.getProtocolVersion());
                }
                this.server.registerConnection(this);
            }
            DaapResponse response = PROCESSOR.process(request);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)request);
                LOG.trace((Object)response);
            }
            if (response != null) {
                this.writer.add(response);
            }
            return true;
        }
        return false;
    }

    public void update() throws IOException {
        DaapSession session;
        if (this.isDaapConnection() && (session = this.getSession(false)) != null && !session.hasAttribute("UPDATE_LOCK")) {
            DaapRequest request;
            DaapResponse response;
            Integer sessionId = session.getSessionId();
            Integer delta = (Integer)session.getAttribute("DELTA");
            Integer revisionNumber = (Integer)session.getAttribute("REVISION-NUMBER");
            if (delta != null && revisionNumber != null && (response = PROCESSOR.process(request = new DaapRequest((DaapConnection)this, sessionId, revisionNumber, delta))) != null) {
                this.writer.add(response);
            }
        }
    }

    public void close() {
        super.close();
        this.reader = null;
    }

    public String toString() {
        return this.channel.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

